/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import twilightforest.item.TFItems;
import twilightforest.tileentity.TileEntityTFTrophy;

public class BlockTFTrophy
extends BlockContainer {
    public BlockTFTrophy() {
        super(Material.circuits);
        this.setBlockBounds(0.25f, 0.0f, 0.25f, 0.75f, 0.5f, 0.75f);
    }

    public int getRenderType() {
        return -1;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World par1World, int par2, int par3, int par4) {
        this.setBlockBoundsBasedOnState((IBlockAccess)par1World, par2, par3, par4);
        return super.getCollisionBoundingBoxFromPool(par1World, par2, par3, par4);
    }

    public void setBlockBoundsBasedOnState(IBlockAccess par1IBlockAccess, int x, int y, int z) {
        int meta = par1IBlockAccess.getBlockMetadata(x, y, z) & 7;
        TileEntityTFTrophy trophy = (TileEntityTFTrophy)par1IBlockAccess.getTileEntity(x, y, z);
        if (trophy != null && trophy.func_145904_a() == 0) {
            switch (meta) {
                default: {
                    this.setBlockBounds(0.25f, 0.0f, 0.25f, 0.75f, 0.5f, 0.75f);
                    break;
                }
                case 2: 
                case 3: {
                    this.setBlockBounds(0.25f, 0.25f, 0.0f, 0.75f, 0.75f, 1.0f);
                    break;
                }
                case 4: 
                case 5: {
                    this.setBlockBounds(0.0f, 0.25f, 0.25f, 1.0f, 0.75f, 0.75f);
                    break;
                }
            }
        } else if (trophy != null && trophy.func_145904_a() == 3) {
            this.setBlockBounds(0.25f, 0.5f, 0.25f, 0.75f, 1.0f, 0.75f);
        } else {
            switch (meta) {
                default: {
                    this.setBlockBounds(0.25f, 0.0f, 0.25f, 0.75f, 0.5f, 0.75f);
                    break;
                }
                case 2: {
                    this.setBlockBounds(0.25f, 0.25f, 0.5f, 0.75f, 0.75f, 1.0f);
                    break;
                }
                case 3: {
                    this.setBlockBounds(0.25f, 0.25f, 0.0f, 0.75f, 0.75f, 0.5f);
                    break;
                }
                case 4: {
                    this.setBlockBounds(0.5f, 0.25f, 0.25f, 1.0f, 0.75f, 0.75f);
                    break;
                }
                case 5: {
                    this.setBlockBounds(0.0f, 0.25f, 0.25f, 0.5f, 0.75f, 0.75f);
                }
            }
        }
    }

    public void onBlockPlacedBy(World par1World, int par2, int par3, int par4, EntityLivingBase par5EntityLiving, ItemStack itemStack) {
        int rotation = MathHelper.floor_double((double)((double)(par5EntityLiving.rotationYaw * 4.0f / 360.0f) + 2.5)) & 3;
        par1World.setBlockMetadataWithNotify(par2, par3, par4, rotation, 2);
    }

    public TileEntity createNewTileEntity(World var1, int var2) {
        return new TileEntityTFTrophy();
    }

    @SideOnly(value=Side.CLIENT)
    public Item idPicked(World par1World, int par2, int par3, int par4) {
        return TFItems.trophy;
    }

    public int getDamageValue(World par1World, int par2, int par3, int par4) {
        TileEntity var5 = par1World.getTileEntity(par2, par3, par4);
        return var5 != null && var5 instanceof TileEntitySkull ? ((TileEntitySkull)var5).func_145904_a() : super.getDamageValue(par1World, par2, par3, par4);
    }

    public int damageDropped(int par1) {
        return par1;
    }

    public void onBlockHarvested(World par1World, int par2, int par3, int par4, int par5, EntityPlayer par6EntityPlayer) {
        if (par6EntityPlayer.capabilities.isCreativeMode) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, par5 |= 8, 2);
        }
        this.dropBlockAsItem(par1World, par2, par3, par4, par5, 0);
        super.onBlockHarvested(par1World, par2, par3, par4, par5, par6EntityPlayer);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if ((metadata & 8) == 0) {
            ItemStack var7 = new ItemStack(TFItems.trophy, 1, this.getDamageValue(world, x, y, z));
            TileEntityTFTrophy var8 = (TileEntityTFTrophy)world.getTileEntity(x, y, z);
            if (var8 == null) {
                return drops;
            }
            drops.add(var7);
        }
        return drops;
    }

    public Item getItemDropped(int par1, Random par2Random, int par3) {
        return TFItems.trophy;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        return Blocks.soul_sand.getIcon(side, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister par1IconRegister) {
    }
}

