/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import twilightforest.block.TFBlocks;
import twilightforest.item.TFItems;

public class BlockTFTrollRoot
extends Block
implements IShearable {
    protected BlockTFTrollRoot() {
        super(Material.plants);
        this.setTickRandomly(true);
        this.setCreativeTab(TFItems.creativeTab);
        this.setStepSound(soundTypeGrass);
        this.setBlockTextureName("TwilightForest:troll_root");
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((Block)this));
        return ret;
    }

    public boolean canBlockStay(World world, int x, int y, int z) {
        return BlockTFTrollRoot.canPlaceRootBelow(world, x, y + 1, z);
    }

    public static boolean canPlaceRootBelow(World world, int x, int y, int z) {
        Block blockAbove = world.getBlock(x, y, z);
        return blockAbove.getMaterial() == Material.rock || blockAbove == TFBlocks.trollVidr || blockAbove == TFBlocks.trollBer || blockAbove == TFBlocks.unripeTrollBer;
    }

    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return super.canPlaceBlockAt(world, x, y, z) && this.canBlockStay(world, x, y, z);
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World par1World, int x, int y, int z) {
        return null;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int getRenderType() {
        return 1;
    }

    public void updateTick(World world, int x, int y, int z, Random rand) {
        this.checkAndDropBlock(world, x, y, z);
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block block) {
        this.checkAndDropBlock(world, x, y, z);
    }

    protected void checkAndDropBlock(World world, int x, int y, int z) {
        if (!this.canBlockStay(world, x, y, z)) {
            this.dropBlockAsItem(world, x, y, z, world.getBlockMetadata(x, y, z), 0);
            world.setBlockToAir(x, y, z);
        }
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return 0;
    }
}

