/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import twilightforest.entity.EntityTFTowerTermite;
import twilightforest.item.TFItems;

public class BlockTFTowerWood
extends Block {
    private static IIcon TEX_PLAIN;
    private static IIcon TEX_ENCASED;
    private static IIcon TEX_CRACKED;
    private static IIcon TEX_MOSSY;
    private static IIcon TEX_INFESTED;
    public static final int META_INFESTED = 4;

    public BlockTFTowerWood() {
        super(Material.wood);
        this.setHardness(40.0f);
        this.setResistance(10.0f);
        this.setStepSound(Block.soundTypeWood);
        this.setCreativeTab(TFItems.creativeTab);
    }

    public int colorMultiplier(IBlockAccess par1IBlockAccess, int x, int y, int z) {
        int meta = par1IBlockAccess.getBlockMetadata(x, y, z);
        if (meta == 0 || meta == 2 || meta == 3 || meta == 4) {
            int value = x * 31 + y * 15 + z * 33;
            if ((value & 0x100) != 0) {
                value = 255 - (value & 0xFF);
            }
            value &= 0xFF;
            value >>= 1;
            return (value |= 0x80) << 16 | value << 8 | value;
        }
        return 0xFFFFFF;
    }

    public IIcon getIcon(int side, int meta) {
        switch (meta) {
            default: {
                return TEX_PLAIN;
            }
            case 1: {
                return TEX_ENCASED;
            }
            case 2: {
                return TEX_CRACKED;
            }
            case 3: {
                return TEX_MOSSY;
            }
            case 4: 
        }
        return TEX_INFESTED;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister par1IconRegister) {
        TEX_PLAIN = par1IconRegister.registerIcon("TwilightForest:towerwood_planks");
        TEX_ENCASED = par1IconRegister.registerIcon("TwilightForest:towerwood_encased");
        TEX_CRACKED = par1IconRegister.registerIcon("TwilightForest:towerwood_cracked");
        TEX_MOSSY = par1IconRegister.registerIcon("TwilightForest:towerwood_mossy");
        TEX_INFESTED = par1IconRegister.registerIcon("TwilightForest:towerwood_infested");
    }

    public void getSubBlocks(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, 0));
        par3List.add(new ItemStack(par1, 1, 1));
        par3List.add(new ItemStack(par1, 1, 2));
        par3List.add(new ItemStack(par1, 1, 3));
        par3List.add(new ItemStack(par1, 1, 4));
    }

    public int damageDropped(int meta) {
        return meta;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        if (meta == 4) {
            return 0;
        }
        return super.quantityDropped(meta, fortune, random);
    }

    public float getBlockHardness(World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        if (meta == 4) {
            return 0.75f;
        }
        return super.getBlockHardness(world, x, y, z);
    }

    public void dropBlockAsItemWithChance(World par1World, int x, int y, int z, int meta, float chance, int something) {
        if (!par1World.isRemote && meta == 4) {
            EntityTFTowerTermite termite = new EntityTFTowerTermite(par1World);
            termite.setLocationAndAngles((double)x + 0.5, y, (double)z + 0.5, 0.0f, 0.0f);
            par1World.spawnEntityInWorld((Entity)termite);
            termite.spawnExplosionParticle();
        }
        super.dropBlockAsItemWithChance(par1World, x, y, z, meta, chance, something);
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return 1;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return 0;
    }
}

