/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import twilightforest.item.TFItems;

public class BlockTFThornRose
extends Block {
    protected BlockTFThornRose() {
        super(Material.plants);
        this.setHardness(10.0f);
        this.setStepSound(soundTypeGrass);
        this.setCreativeTab(TFItems.creativeTab);
        float radius = 0.4f;
        this.setBlockBounds(0.5f - radius, 0.5f - radius, 0.5f - radius, 0.5f + radius, 0.5f + radius, 0.5f + radius);
    }

    public int getRenderType() {
        return 1;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return this.canBlockStay(world, x, y, z);
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        return null;
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block block) {
        if (!this.canBlockStay(world, x, y, z)) {
            this.dropBlockAsItem(world, x, y, z, world.getBlockMetadata(x, y, z), 0);
            world.setBlockToAir(x, y, z);
        }
    }

    public boolean canBlockStay(World world, int x, int y, int z) {
        boolean supported = false;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            if (!world.getBlock(dx, dy, dz).canSustainLeaves((IBlockAccess)world, dx, dy, dz)) continue;
            supported = true;
        }
        return supported;
    }
}

