/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import twilightforest.entity.EntityTFSlideBlock;
import twilightforest.item.TFItems;

public class BlockTFSlider
extends BlockRotatedPillar {
    private static final int TICK_TIME = 80;
    private static final int OFFSET_TIME = 20;
    private static final int PLAYER_RANGE = 32;
    private static final float BLOCK_DAMAGE = 5.0f;
    private IIcon horiIcon;
    private IIcon vertIcon;
    private IIcon topIcon;

    protected BlockTFSlider() {
        super(Material.iron);
        this.setCreativeTab(TFItems.creativeTab);
        this.setHardness(2.0f);
        this.setResistance(10.0f);
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        int rotation = meta & 0xC;
        float pixel = 0.0625f;
        float inset = 5.0f;
        switch (rotation) {
            default: {
                return AxisAlignedBB.getBoundingBox((double)((float)x + pixel * inset), (double)y, (double)((float)z + pixel * inset), (double)((float)x + 1.0f - pixel * inset), (double)((float)y + 1.0f), (double)((float)z + 1.0f - pixel * inset));
            }
            case 4: {
                return AxisAlignedBB.getBoundingBox((double)x, (double)((float)y + pixel * inset), (double)((float)z + pixel * inset), (double)((float)x + 1.0f), (double)((float)y + 1.0f - pixel * inset), (double)((float)z + 1.0f - pixel * inset));
            }
            case 8: 
        }
        return AxisAlignedBB.getBoundingBox((double)((float)x + pixel * inset), (double)((float)y + pixel * inset), (double)z, (double)((float)x + 1.0f - pixel * inset), (double)((float)y + 1.0f - pixel * inset), (double)((float)z + 1.0f));
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int x, int y, int z) {
        return this.getCollisionBoundingBoxFromPool(world, x, y, z);
    }

    public void setBlockBoundsBasedOnState(IBlockAccess world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        this.setBlockBoundsBasedOnMeta(meta);
    }

    public void setBlockBoundsBasedOnMeta(int meta) {
        int rotation = meta & 0xC;
        float pixel = 0.0625f;
        float inset = 5.0f;
        switch (rotation) {
            default: {
                this.setBlockBounds(pixel * inset, 0.0f, pixel * inset, 1.0f - pixel * inset, 1.0f, 1.0f - pixel * inset);
                break;
            }
            case 4: {
                this.setBlockBounds(0.0f, pixel * inset, pixel * inset, 1.0f, 1.0f - pixel * inset, 1.0f - pixel * inset);
                break;
            }
            case 8: {
                this.setBlockBounds(pixel * inset, pixel * inset, 0.0f, 1.0f - pixel * inset, 1.0f - pixel * inset, 1.0f);
            }
        }
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public int getRenderType() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        int rotation = meta & 0xC;
        if (rotation == 0) {
            switch (side) {
                case 0: 
                case 1: {
                    return this.topIcon;
                }
            }
            return this.vertIcon;
        }
        if (rotation == 4) {
            switch (side) {
                case 4: 
                case 5: {
                    return this.topIcon;
                }
            }
            return this.horiIcon;
        }
        switch (side) {
            case 2: 
            case 3: {
                return this.topIcon;
            }
            case 0: 
            case 1: {
                return this.vertIcon;
            }
        }
        return this.horiIcon;
    }

    @SideOnly(value=Side.CLIENT)
    protected IIcon getSideIcon(int meta) {
        if ((meta & 0xC) == 0) {
            return this.horiIcon;
        }
        if ((meta & 0xC) == 8) {
            return this.horiIcon;
        }
        return this.vertIcon;
    }

    @SideOnly(value=Side.CLIENT)
    protected IIcon getTopIcon(int p_150161_1_) {
        return this.topIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister par1IconRegister) {
        this.horiIcon = par1IconRegister.registerIcon("TwilightForest:slider_h");
        this.vertIcon = par1IconRegister.registerIcon("TwilightForest:slider_v");
        this.topIcon = par1IconRegister.registerIcon("TwilightForest:slider_top");
    }

    public void updateTick(World world, int x, int y, int z, Random par5Random) {
        if (!world.isRemote && this.isConnectedInRange(world, x, y, z)) {
            EntityTFSlideBlock slideBlock = new EntityTFSlideBlock(world, (double)x + 0.5, y, (double)z + 0.5, (Block)this, world.getBlockMetadata(x, y, z));
            world.spawnEntityInWorld((Entity)slideBlock);
        }
        this.scheduleBlockUpdate(world, x, y, z);
    }

    public boolean isConnectedInRange(World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        if ((meta & 0xC) == 0) {
            return this.anyPlayerInRange(world, x, y, z) || this.isConnectedInRangeRecursive(world, x, y, z, ForgeDirection.UP) || this.isConnectedInRangeRecursive(world, x, y, z, ForgeDirection.DOWN);
        }
        if ((meta & 0xC) == 4) {
            return this.anyPlayerInRange(world, x, y, z) || this.isConnectedInRangeRecursive(world, x, y, z, ForgeDirection.WEST) || this.isConnectedInRangeRecursive(world, x, y, z, ForgeDirection.EAST);
        }
        if ((meta & 0xC) == 8) {
            return this.anyPlayerInRange(world, x, y, z) || this.isConnectedInRangeRecursive(world, x, y, z, ForgeDirection.NORTH) || this.isConnectedInRangeRecursive(world, x, y, z, ForgeDirection.SOUTH);
        }
        return this.anyPlayerInRange(world, x, y, z);
    }

    private boolean isConnectedInRangeRecursive(World world, int x, int y, int z, ForgeDirection dir) {
        int dx = x + dir.offsetX;
        int dy = y + dir.offsetY;
        int dz = z + dir.offsetZ;
        if (world.getBlock(x, y, z) == world.getBlock(dx, dy, dz) && world.getBlockMetadata(x, y, z) == world.getBlockMetadata(dx, dy, dz)) {
            return this.anyPlayerInRange(world, dx, dy, dz) || this.isConnectedInRangeRecursive(world, dx, dy, dz, dir);
        }
        return false;
    }

    public boolean anyPlayerInRange(World world, int x, int y, int z) {
        return world.getClosestPlayer((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 32.0) != null;
    }

    public void scheduleBlockUpdate(World world, int x, int y, int z) {
        int offset = world.getBlockMetadata(x, y, z) & 3;
        int update = 80 - (int)(world.getWorldTime() - (long)(offset * 20)) % 80;
        world.scheduleBlockUpdate(x, y, z, (Block)this, update);
    }

    public void onBlockAdded(World world, int x, int y, int z) {
        this.scheduleBlockUpdate(world, x, y, z);
    }

    public void getSubBlocks(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, 0));
        par3List.add(new ItemStack(par1, 1, 1));
        par3List.add(new ItemStack(par1, 1, 2));
        par3List.add(new ItemStack(par1, 1, 3));
    }

    public void setBlockBoundsForItemRender() {
        this.setBlockBoundsBasedOnMeta(0);
    }

    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        entity.attackEntityFrom(DamageSource.generic, 5.0f);
        if (entity instanceof EntityLivingBase) {
            double kx = ((double)x + 0.5 - entity.posX) * 2.0;
            double kz = ((double)z + 0.5 - entity.posZ) * 2.0;
            ((EntityLivingBase)entity).knockBack(null, 5.0f, kx, kz);
        }
    }
}

