/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import twilightforest.item.TFItems;

public class BlockTFShield
extends Block {
    public static IIcon sprSide;
    private IIcon sprInside;
    private IIcon sprOutside;

    public BlockTFShield() {
        super(Material.rock);
        this.setBlockUnbreakable();
        this.setResistance(6000000.0f);
        this.setStepSound(Block.soundTypeMetal);
        this.setCreativeTab(TFItems.creativeTab);
    }

    public IIcon getIcon(int side, int meta) {
        if (side == meta) {
            return this.sprInside;
        }
        return this.sprOutside;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister par1IconRegister) {
        this.sprInside = par1IconRegister.registerIcon("TwilightForest:shield_inside");
        this.sprOutside = par1IconRegister.registerIcon("TwilightForest:shield_outside");
    }

    public void getSubBlocks(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, 0));
    }

    public int getRenderBlockPass() {
        return 0;
    }

    public boolean isOpaqueCube() {
        return true;
    }

    public boolean renderAsNormalBlock() {
        return true;
    }

    public int damageDropped(int meta) {
        return 0;
    }

    public int quantityDropped(Random par1Random) {
        return 0;
    }

    public void onBlockPlacedBy(World par1World, int par2, int par3, int par4, EntityLivingBase par5EntityLiving, ItemStack par6ItemStack) {
        int l = BlockPistonBase.determineOrientation((World)par1World, (int)par2, (int)par3, (int)par4, (EntityLivingBase)par5EntityLiving);
        par1World.setBlockMetadataWithNotify(par2, par3, par4, l, 2);
    }

    public float getPlayerRelativeBlockHardness(EntityPlayer player, World world, int x, int y, int z) {
        int meta;
        MovingObjectPosition mop = this.getPlayerPointVec(world, player, 6.0);
        int facing = mop != null ? mop.sideHit : -1;
        if (facing == (meta = world.getBlockMetadata(x, y, z))) {
            return player.getBreakSpeed(Blocks.stone, false, 0, x, y, z) / 1.5f / 100.0f;
        }
        return super.getPlayerRelativeBlockHardness(player, world, x, y, z);
    }

    private MovingObjectPosition getPlayerPointVec(World worldObj, EntityPlayer player, double range) {
        Vec3 position = Vec3.createVectorHelper((double)player.posX, (double)(player.posY + (double)player.getEyeHeight()), (double)player.posZ);
        Vec3 look = player.getLook(1.0f);
        Vec3 dest = position.addVector(look.xCoord * range, look.yCoord * range, look.zCoord * range);
        return worldObj.rayTraceBlocks(position, dest);
    }
}

