/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import twilightforest.TFAchievementPage;
import twilightforest.TFTeleporter;
import twilightforest.TwilightForestMod;
import twilightforest.block.TFBlocks;

public class BlockTFPortal
extends BlockBreakable {
    public BlockTFPortal() {
        super("TFPortal", Material.portal, false);
        this.setHardness(-1.0f);
        this.setStepSound(Block.soundTypeGlass);
        this.setLightLevel(0.75f);
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return null;
    }

    public void setBlockBoundsBasedOnState(IBlockAccess iblockaccess, int i, int j, int k) {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.75f, 1.0f);
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public IIcon getIcon(int side, int meta) {
        return Blocks.portal.getIcon(side, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister par1IconRegister) {
    }

    public boolean tryToCreatePortal(World world, int dx, int dy, int dz) {
        if (this.isGoodPortalPool(world, dx, dy, dz)) {
            world.addWeatherEffect((Entity)new EntityLightningBolt(world, (double)dx, (double)dy, (double)dz));
            this.transmuteWaterToPortal(world, dx, dy, dz);
            return true;
        }
        return false;
    }

    public void transmuteWaterToPortal(World world, int dx, int dy, int dz) {
        int px = dx;
        int pz = dz;
        if (world.getBlock(px - 1, dy, pz).getMaterial() == Material.water) {
            --px;
        }
        if (world.getBlock(px, dy, pz - 1).getMaterial() == Material.water) {
            --pz;
        }
        world.setBlock(px + 0, dy, pz + 0, TFBlocks.portal, 0, 2);
        world.setBlock(px + 1, dy, pz + 0, TFBlocks.portal, 0, 2);
        world.setBlock(px + 1, dy, pz + 1, TFBlocks.portal, 0, 2);
        world.setBlock(px + 0, dy, pz + 1, TFBlocks.portal, 0, 2);
    }

    public boolean isGoodPortalPool(World world, int dx, int dy, int dz) {
        boolean flag = false;
        flag |= this.isGoodPortalPoolStrict(world, dx + 0, dy, dz + 0);
        flag |= this.isGoodPortalPoolStrict(world, dx - 1, dy, dz - 1);
        flag |= this.isGoodPortalPoolStrict(world, dx + 0, dy, dz - 1);
        flag |= this.isGoodPortalPoolStrict(world, dx + 1, dy, dz - 1);
        flag |= this.isGoodPortalPoolStrict(world, dx - 1, dy, dz + 0);
        flag |= this.isGoodPortalPoolStrict(world, dx + 1, dy, dz + 0);
        flag |= this.isGoodPortalPoolStrict(world, dx - 1, dy, dz + 1);
        flag |= this.isGoodPortalPoolStrict(world, dx + 0, dy, dz + 1);
        return flag |= this.isGoodPortalPoolStrict(world, dx + 1, dy, dz + 1);
    }

    public boolean isGoodPortalPoolStrict(World world, int dx, int dy, int dz) {
        boolean flag = true;
        flag &= world.getBlock(dx + 0, dy, dz + 0).getMaterial() == Material.water;
        flag &= world.getBlock(dx + 1, dy, dz + 0).getMaterial() == Material.water;
        flag &= world.getBlock(dx + 1, dy, dz + 1).getMaterial() == Material.water;
        flag &= world.getBlock(dx + 0, dy, dz + 1).getMaterial() == Material.water;
        flag &= this.isGrassOrDirt(world, dx - 1, dy, dz - 1);
        flag &= this.isGrassOrDirt(world, dx - 1, dy, dz + 0);
        flag &= this.isGrassOrDirt(world, dx - 1, dy, dz + 1);
        flag &= this.isGrassOrDirt(world, dx - 1, dy, dz + 2);
        flag &= this.isGrassOrDirt(world, dx + 0, dy, dz - 1);
        flag &= this.isGrassOrDirt(world, dx + 1, dy, dz - 1);
        flag &= this.isGrassOrDirt(world, dx + 0, dy, dz + 2);
        flag &= this.isGrassOrDirt(world, dx + 1, dy, dz + 2);
        flag &= this.isGrassOrDirt(world, dx + 2, dy, dz - 1);
        flag &= this.isGrassOrDirt(world, dx + 2, dy, dz + 0);
        flag &= this.isGrassOrDirt(world, dx + 2, dy, dz + 1);
        flag &= this.isGrassOrDirt(world, dx + 2, dy, dz + 2);
        flag &= world.getBlock(dx + 0, dy - 1, dz + 0).getMaterial().isSolid();
        flag &= world.getBlock(dx + 1, dy - 1, dz + 0).getMaterial().isSolid();
        flag &= world.getBlock(dx + 1, dy - 1, dz + 1).getMaterial().isSolid();
        flag &= world.getBlock(dx + 0, dy - 1, dz + 1).getMaterial().isSolid();
        flag &= this.isNatureBlock(world, dx - 1, dy + 1, dz - 1);
        flag &= this.isNatureBlock(world, dx - 1, dy + 1, dz + 0);
        flag &= this.isNatureBlock(world, dx - 1, dy + 1, dz + 1);
        flag &= this.isNatureBlock(world, dx - 1, dy + 1, dz + 2);
        flag &= this.isNatureBlock(world, dx + 0, dy + 1, dz - 1);
        flag &= this.isNatureBlock(world, dx + 1, dy + 1, dz - 1);
        flag &= this.isNatureBlock(world, dx + 0, dy + 1, dz + 2);
        flag &= this.isNatureBlock(world, dx + 1, dy + 1, dz + 2);
        flag &= this.isNatureBlock(world, dx + 2, dy + 1, dz - 1);
        flag &= this.isNatureBlock(world, dx + 2, dy + 1, dz + 0);
        flag &= this.isNatureBlock(world, dx + 2, dy + 1, dz + 1);
        return flag &= this.isNatureBlock(world, dx + 2, dy + 1, dz + 2);
    }

    public boolean isNatureBlock(World world, int dx, int dy, int dz) {
        Material mat = world.getBlock(dx, dy, dz).getMaterial();
        return mat == Material.plants || mat == Material.vine || mat == Material.leaves;
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block notUsed) {
        boolean good = true;
        good = world.getBlock(x - 1, y, z) == this ? (good &= this.isGrassOrDirt(world, x + 1, y, z)) : (world.getBlock(x + 1, y, z) == this ? (good &= this.isGrassOrDirt(world, x - 1, y, z)) : false);
        good = world.getBlock(x, y, z - 1) == this ? (good &= this.isGrassOrDirt(world, x, y, z + 1)) : (world.getBlock(x, y, z + 1) == this ? (good &= this.isGrassOrDirt(world, x, y, z - 1)) : false);
        if (!good) {
            world.setBlock(x, y, z, Blocks.water, 0, 3);
        }
    }

    protected boolean isGrassOrDirt(World world, int dx, int dy, int dz) {
        Material mat = world.getBlock(dx, dy, dz).getMaterial();
        return mat == Material.grass || mat == Material.ground;
    }

    public int quantityDropped(Random random) {
        return 0;
    }

    public int getRenderBlockPass() {
        return 1;
    }

    public void onEntityCollidedWithBlock(World world, int i, int j, int k, Entity entity) {
        if (entity.ridingEntity == null && entity.riddenByEntity == null && entity.timeUntilPortal <= 0) {
            if (entity instanceof EntityPlayerMP) {
                EntityPlayerMP playerMP = (EntityPlayerMP)entity;
                if (playerMP.timeUntilPortal > 0) {
                    playerMP.timeUntilPortal = 10;
                } else if (playerMP.dimension != TwilightForestMod.dimensionID) {
                    playerMP.triggerAchievement((StatBase)TFAchievementPage.twilightPortal);
                    FMLLog.info((String)("[TwilightForest] Player touched the portal block.  Sending the player to dimension " + TwilightForestMod.dimensionID), (Object[])new Object[0]);
                    playerMP.mcServer.getConfigurationManager().transferPlayerToDimension(playerMP, TwilightForestMod.dimensionID, (Teleporter)new TFTeleporter(playerMP.mcServer.worldServerForDimension(TwilightForestMod.dimensionID)));
                    playerMP.triggerAchievement((StatBase)TFAchievementPage.twilightArrival);
                    int spawnX = MathHelper.floor_double((double)playerMP.posX);
                    int spawnY = MathHelper.floor_double((double)playerMP.posY);
                    int spawnZ = MathHelper.floor_double((double)playerMP.posZ);
                    playerMP.setSpawnChunk(new ChunkCoordinates(spawnX, spawnY, spawnZ), true, TwilightForestMod.dimensionID);
                } else {
                    playerMP.mcServer.getConfigurationManager().transferPlayerToDimension(playerMP, 0, (Teleporter)new TFTeleporter(playerMP.mcServer.worldServerForDimension(0)));
                }
            } else if (entity.dimension == TwilightForestMod.dimensionID) {
                this.sendEntityToDimension(entity, 0);
            }
        }
    }

    public void sendEntityToDimension(Entity entity, int dimensionID) {
        if (!entity.worldObj.isRemote && !entity.isDead) {
            entity.worldObj.theProfiler.startSection("changeDimension");
            MinecraftServer minecraftserver = MinecraftServer.getServer();
            int dim = entity.dimension;
            WorldServer worldserver = minecraftserver.worldServerForDimension(dim);
            WorldServer worldserver1 = minecraftserver.worldServerForDimension(dimensionID);
            entity.dimension = dimensionID;
            entity.worldObj.removeEntity(entity);
            entity.isDead = false;
            entity.worldObj.theProfiler.startSection("reposition");
            minecraftserver.getConfigurationManager().transferEntityToWorld(entity, dim, worldserver, worldserver1, (Teleporter)new TFTeleporter(worldserver1));
            entity.worldObj.theProfiler.endStartSection("reloading");
            Entity transferEntity = EntityList.createEntityByName((String)EntityList.getEntityString((Entity)entity), (World)worldserver1);
            if (transferEntity != null) {
                transferEntity.copyDataFrom(entity, true);
                worldserver1.spawnEntityInWorld(transferEntity);
            }
            entity.isDead = true;
            entity.worldObj.theProfiler.endSection();
            worldserver.resetUpdateEntityTick();
            worldserver1.resetUpdateEntityTick();
            entity.worldObj.theProfiler.endSection();
        }
    }

    public void randomDisplayTick(World world, int i, int j, int k, Random random) {
        if (random.nextInt(100) == 0) {
            world.playSoundEffect((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "portal.portal", 1.0f, random.nextFloat() * 0.4f + 0.8f);
        }
        for (int l = 0; l < 4; ++l) {
            double d = (float)i + random.nextFloat();
            double d1 = (float)j + random.nextFloat();
            double d2 = (float)k + random.nextFloat();
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            int i1 = random.nextInt(2) * 2 - 1;
            d3 = ((double)random.nextFloat() - 0.5) * 0.5;
            d4 = ((double)random.nextFloat() - 0.5) * 0.5;
            d5 = ((double)random.nextFloat() - 0.5) * 0.5;
            if (world.getBlock(i - 1, j, k) == this || world.getBlock(i + 1, j, k) == this) {
                d2 = (double)k + 0.5 + 0.25 * (double)i1;
                d5 = random.nextFloat() * 2.0f * (float)i1;
            } else {
                d = (double)i + 0.5 + 0.25 * (double)i1;
                d3 = random.nextFloat() * 2.0f * (float)i1;
            }
            world.spawnParticle("portal", d, d1, d2, d3, d4, d5);
        }
    }

    public void getSubBlocks(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, 0));
    }
}

