/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import twilightforest.block.BlockTFCritter;
import twilightforest.tileentity.TileEntityTFMoonworm;

public class BlockTFMoonworm
extends BlockTFCritter {
    public static int sprMoonworm = 52;

    protected BlockTFMoonworm() {
    }

    public int tickRate() {
        return 50;
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess world, int x, int y, int z) {
        int facing = world.getBlockMetadata(x, y, z) & 7;
        float wide = 0.25f;
        switch (facing) {
            case 1: {
                this.setBlockBounds(0.0f, 0.25f, 0.5f - wide, wide, 0.75f, 0.5f + wide);
                break;
            }
            case 2: {
                this.setBlockBounds(1.0f - wide, 0.25f, 0.5f - wide, 1.0f, 0.75f, 0.5f + wide);
                break;
            }
            case 3: {
                this.setBlockBounds(0.5f - wide, 0.25f, 0.0f, 0.5f + wide, 0.75f, wide);
                break;
            }
            case 4: {
                this.setBlockBounds(0.5f - wide, 0.25f, 1.0f - wide, 0.5f + wide, 0.75f, 1.0f);
                break;
            }
            case 5: {
                this.setBlockBounds(0.5f - wide, 0.0f, 0.25f, 0.5f + wide, wide, 0.75f);
                break;
            }
            case 6: {
                this.setBlockBounds(0.5f - wide, 1.0f - wide, 0.25f, 0.5f + wide, 1.0f, 0.75f);
                break;
            }
            default: {
                float f1 = 0.1f;
                this.setBlockBounds(0.5f - f1, 0.0f, 0.5f - f1, 0.5f + f1, 0.6f, 0.5f + f1);
            }
        }
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return 14;
    }

    @Override
    public TileEntity createTileEntity(World world, int metadata) {
        return new TileEntityTFMoonworm();
    }

    @Override
    public void onBlockAdded(World world, int x, int y, int z) {
        super.onBlockAdded(world, x, y, z);
        world.scheduleBlockUpdate(x, y, z, (Block)this, this.tickRate());
    }

    public void updateTick(World world, int x, int y, int z, Random random) {
        if (world.getBlockLightValue(x, y, z) < 12) {
            world.scheduleBlockUpdate(x, y, z, (Block)this, this.tickRate());
        }
    }

    @Override
    public boolean dropCritterIfCantStay(World world, int x, int y, int z) {
        if (!this.canPlaceBlockAt(world, x, y, z)) {
            world.setBlockToAir(x, y, z);
            return false;
        }
        return true;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return 0;
    }
}

