/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import twilightforest.TwilightForestMod;
import twilightforest.block.TFBlocks;
import twilightforest.item.TFItems;

public class BlockTFMagicLeaves
extends BlockLeaves {
    int oakColor = 4764952;
    int canopyColor = 6330464;
    int mangroveColor = 8431445;
    public static final int META_TIME = 0;
    public static final int META_TRANS = 1;
    public static final int META_MINE = 2;
    public static final int META_SORT = 3;
    public static IIcon SPR_TIMELEAVES;
    public static IIcon SPR_TIMELEAVES_OPAQUE;
    public static IIcon SPR_TIMEFX;
    public static IIcon SPR_TRANSLEAVES;
    public static IIcon SPR_TRANSLEAVES_OPAQUE;
    public static IIcon SPR_TRANSFX;
    public static IIcon SPR_SORTLEAVES;
    public static IIcon SPR_SORTLEAVES_OPAQUE;
    public static IIcon SPR_SORTFX;
    private static final int SAPLING_ITEM_META_OFFSET = 5;

    protected BlockTFMagicLeaves() {
        this.setHardness(0.2f);
        this.setLightOpacity(2);
        this.setStepSound(Block.soundTypeGrass);
        this.setCreativeTab(TFItems.creativeTab);
    }

    public int getRenderColor(int par1) {
        switch (par1 & 3) {
            case 0: {
                return 6986775;
            }
            case 1: {
                return 7130346;
            }
            case 2: {
                return 16576836;
            }
            case 3: {
                return 3558403;
            }
        }
        return 0xFFFFFF;
    }

    public int colorMultiplier(IBlockAccess world, int x, int y, int z) {
        int leafType = world.getBlockMetadata(x, y, z) & 3;
        int red = 0;
        int green = 0;
        int blue = 0;
        switch (leafType) {
            case 0: {
                int fade = x * 16 + y * 16 + z * 16;
                if ((fade & 0x100) != 0) {
                    fade = 255 - (fade & 0xFF);
                }
                float spring = (float)(255 - (fade &= 0xFF)) / 255.0f;
                float fall = (float)fade / 255.0f;
                red = (int)(spring * 106.0f + fall * 251.0f);
                green = (int)(spring * 156.0f + fall * 108.0f);
                blue = (int)(spring * 23.0f + fall * 27.0f);
                break;
            }
            case 1: {
                int fade = x * 27 + y * 63 + z * 39;
                if ((fade & 0x100) != 0) {
                    fade = 255 - (fade & 0xFF);
                }
                float spring = (float)(255 - (fade &= 0xFF)) / 255.0f;
                float fall = (float)fade / 255.0f;
                red = (int)(spring * 108.0f + fall * 96.0f);
                green = (int)(spring * 204.0f + fall * 107.0f);
                blue = (int)(spring * 234.0f + fall * 121.0f);
                break;
            }
            case 2: {
                int fade = x * 31 + y * 33 + z * 32;
                if ((fade & 0x100) != 0) {
                    fade = 255 - (fade & 0xFF);
                }
                float spring = (float)(255 - (fade &= 0xFF)) / 255.0f;
                float fall = (float)fade / 255.0f;
                red = (int)(spring * 252.0f + fall * 237.0f);
                green = (int)(spring * 241.0f + fall * 172.0f);
                blue = (int)(spring * 68.0f + fall * 9.0f);
                break;
            }
            case 3: {
                int fade = x * 63 + y * 63 + z * 63;
                if ((fade & 0x100) != 0) {
                    fade = 255 - (fade & 0xFF);
                }
                float spring = (float)(255 - (fade &= 0xFF)) / 255.0f;
                float fall = (float)fade / 255.0f;
                red = (int)(spring * 54.0f + fall * 168.0f);
                green = (int)(spring * 76.0f + fall * 199.0f);
                blue = (int)(spring * 3.0f + fall * 43.0f);
            }
        }
        return red << 16 | green << 8 | blue;
    }

    public int getRenderType() {
        return TwilightForestMod.proxy.getMagicLeavesBlockRenderID();
    }

    public int getRenderBlockPass() {
        return 0;
    }

    public boolean isOpaqueCube() {
        return Blocks.leaves.isOpaqueCube();
    }

    public IIcon getIcon(int side, int meta) {
        if (Blocks.leaves.isOpaqueCube()) {
            switch (meta & 3) {
                default: {
                    return SPR_TIMELEAVES_OPAQUE;
                }
                case 1: {
                    return SPR_TRANSLEAVES_OPAQUE;
                }
                case 3: 
            }
            return SPR_SORTLEAVES_OPAQUE;
        }
        switch (meta & 3) {
            default: {
                return SPR_TIMELEAVES;
            }
            case 1: {
                return SPR_TRANSLEAVES;
            }
            case 3: 
        }
        return SPR_SORTLEAVES;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister par1IconRegister) {
        SPR_TIMELEAVES = par1IconRegister.registerIcon("TwilightForest:time_leaves");
        SPR_TIMELEAVES_OPAQUE = par1IconRegister.registerIcon("TwilightForest:time_leaves_opaque");
        SPR_TRANSLEAVES = par1IconRegister.registerIcon("TwilightForest:trans_leaves");
        SPR_TRANSLEAVES_OPAQUE = par1IconRegister.registerIcon("TwilightForest:trans_leaves_opaque");
        SPR_SORTLEAVES = par1IconRegister.registerIcon("TwilightForest:sort_leaves");
        SPR_SORTLEAVES_OPAQUE = par1IconRegister.registerIcon("TwilightForest:sort_leaves_opaque");
    }

    public void getSubBlocks(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        itemList.add(new ItemStack(item, 1, 0));
        itemList.add(new ItemStack(item, 1, 1));
        itemList.add(new ItemStack(item, 1, 2));
        itemList.add(new ItemStack(item, 1, 3));
    }

    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
        int meta = world.getBlockMetadata(x, y, z);
        if ((meta & 3) == 1) {
            for (int i = 0; i < 1; ++i) {
                this.sparkleRunes(world, x, y, z, rand);
            }
        }
    }

    private void sparkleRunes(World world, int x, int y, int z, Random rand) {
        double offset = 0.0625;
        int side = rand.nextInt(5) + 1;
        double rx = (float)x + rand.nextFloat();
        double ry = (float)y + rand.nextFloat();
        double rz = (float)z + rand.nextFloat();
        if (side == 0 && world.isAirBlock(x, y + 1, z)) {
            ry = (double)(y + 1) + offset;
        }
        if (side == 1 && world.isAirBlock(x, y - 1, z)) {
            ry = (double)y - offset;
        }
        if (side == 2 && world.isAirBlock(x, y, z + 1)) {
            rz = (double)(z + 1) + offset;
        }
        if (side == 3 && world.isAirBlock(x, y, z - 1)) {
            rz = (double)z - offset;
        }
        if (side == 4 && world.isAirBlock(x + 1, y, z)) {
            rx = (double)(x + 1) + offset;
        }
        if (side == 5 && world.isAirBlock(x - 1, y, z)) {
            rx = (double)x - offset;
        }
        if (rx < (double)x || rx > (double)(x + 1) || ry < (double)y || ry > (double)(y + 1) || rz < (double)z || rz > (double)(z + 1)) {
            TwilightForestMod.proxy.spawnParticle(world, "leafrune", rx, ry, rz, 0.0, 0.0, 0.0);
        }
    }

    public String[] func_150125_e() {
        return new String[]{"time", "trans", "mine", "sort"};
    }

    public Item getItemDropped(int p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return Item.getItemFromBlock((Block)TFBlocks.sapling);
    }

    public int damageDropped(int metadata) {
        return (metadata & 3) + 5;
    }

    protected int func_150123_b(int metadata) {
        return 150;
    }

    protected void func_150124_c(World world, int x, int y, int z, int metadata, int chance) {
        if (world.rand.nextInt(chance) == 0) {
            block0 : switch (metadata & 3) {
                case 0: {
                    this.dropBlockAsItem(world, x, y, z, new ItemStack(Items.clock, 1, 0));
                    break;
                }
                case 1: {
                    this.dropBlockAsItem(world, x, y, z, new ItemStack(TFBlocks.firefly, 2, 0));
                    break;
                }
                case 2: {
                    switch (world.rand.nextInt(6)) {
                        case 0: {
                            this.dropBlockAsItem(world, x, y, z, new ItemStack(Blocks.iron_ore, 1, 0));
                            break block0;
                        }
                        case 1: {
                            this.dropBlockAsItem(world, x, y, z, new ItemStack(Blocks.gold_ore, 1, 0));
                            break block0;
                        }
                        case 2: {
                            this.dropBlockAsItem(world, x, y, z, new ItemStack(Blocks.diamond_ore, 1, 0));
                            break block0;
                        }
                        case 3: {
                            this.dropBlockAsItem(world, x, y, z, new ItemStack(Blocks.emerald_ore, 1, 0));
                            break block0;
                        }
                        case 4: {
                            this.dropBlockAsItem(world, x, y, z, new ItemStack(Blocks.coal_ore, 1, 0));
                            break block0;
                        }
                        case 5: {
                            this.dropBlockAsItem(world, x, y, z, new ItemStack(Blocks.redstone_ore, 1, 0));
                            break block0;
                        }
                    }
                }
                case 3: {
                    this.dropBlockAsItem(world, x, y, z, new ItemStack((Block)Blocks.chest, 1, 0));
                    break;
                }
            }
        }
    }
}

