/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import twilightforest.TwilightForestMod;
import twilightforest.item.TFItems;

public class BlockTFHugeLilyPad
extends BlockBush {
    private IIcon pad1;
    private IIcon pad2;
    private IIcon pad3;
    private IIcon blank;
    private boolean isSelfDestructing = false;

    protected BlockTFHugeLilyPad() {
        super(Material.plants);
        float f = 0.5f;
        float f1 = 0.015625f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f1, 0.5f + f);
        this.setStepSound(soundTypeGrass);
        this.setCreativeTab(TFItems.creativeTab);
    }

    public int getRenderType() {
        return TwilightForestMod.proxy.getHugeLilyPadBlockRenderID();
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World p_149668_1_, int p_149668_2_, int p_149668_3_, int p_149668_4_) {
        return AxisAlignedBB.getBoundingBox((double)((double)p_149668_2_ + this.minX), (double)((double)p_149668_3_ + this.minY), (double)((double)p_149668_4_ + this.minZ), (double)((double)p_149668_2_ + this.maxX), (double)((double)p_149668_3_ + this.maxY), (double)((double)p_149668_4_ + this.maxZ));
    }

    public void getSubBlocks(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, 0));
    }

    public IIcon getIcon(int side, int meta) {
        if (side > 1) {
            return this.blank;
        }
        int orient = meta >> 2;
        int piece = meta & 3;
        if (orient == 1) {
            orient = 3;
        } else if (orient == 3) {
            orient = 1;
        }
        int display = (piece + orient) % 4;
        switch (display) {
            default: {
                return this.blockIcon;
            }
            case 1: {
                return this.pad1;
            }
            case 2: {
                return this.pad2;
            }
            case 3: 
        }
        return this.pad3;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister par1IconRegister) {
        this.blockIcon = par1IconRegister.registerIcon("TwilightForest:huge_lilypad_0");
        this.pad1 = par1IconRegister.registerIcon("TwilightForest:huge_lilypad_1");
        this.pad2 = par1IconRegister.registerIcon("TwilightForest:huge_lilypad_2");
        this.pad3 = par1IconRegister.registerIcon("TwilightForest:huge_lilypad_3");
        this.blank = par1IconRegister.registerIcon("TwilightForest:blank");
    }

    protected boolean canPlaceBlockOn(Block block) {
        return block == Blocks.water;
    }

    public void onBlockHarvested(World world, int x, int y, int z, int meta, EntityPlayer player) {
        this.setGiantBlockToAir(world, x, y, z);
    }

    public void onBlockExploded(World world, int x, int y, int z, Explosion explosion) {
        world.setBlockToAir(x, y, z);
        this.setGiantBlockToAir(world, x, y, z);
    }

    public void onBlockPreDestroy(World world, int x, int y, int z, int meta) {
        int orient = meta >> 2;
        int piece = meta & 3;
        int display = (piece + orient) % 4;
        if (!this.isSelfDestructing && !this.canBlockStay(world, x, y, z)) {
            this.setGiantBlockToAir(world, x, y, z);
        }
    }

    private void setGiantBlockToAir(World world, int x, int y, int z) {
        this.isSelfDestructing = true;
        int bx = x >> 1 << 1;
        int bz = z >> 1 << 1;
        for (int dx = 0; dx < 2; ++dx) {
            for (int dz = 0; dz < 2; ++dz) {
                if (x == bx + dx && z == bz + dz || world.getBlock(bx + dx, y, bz + dz) != this) continue;
                world.setBlock(bx + dx, y, bz + dz, Blocks.air, 0, 2);
            }
        }
        this.isSelfDestructing = false;
    }

    public boolean canBlockStay(World world, int x, int y, int z) {
        boolean allThisBlock = true;
        boolean allWater = true;
        int bx = x >> 1 << 1;
        int bz = z >> 1 << 1;
        for (int dx = 0; dx < 2; ++dx) {
            for (int dz = 0; dz < 2; ++dz) {
                allThisBlock &= world.getBlock(bx + dx, y, bz + dz) == this;
                allWater &= world.getBlock(bx + dx, y - 1, bz + dz).getMaterial() == Material.water && world.getBlockMetadata(bx + dx, y - 1, bz + dz) == 0;
            }
        }
        return allThisBlock && allWater;
    }

    protected void checkAndDropBlock(World p_149855_1_, int p_149855_2_, int p_149855_3_, int p_149855_4_) {
        if (!this.canBlockStay(p_149855_1_, p_149855_2_, p_149855_3_, p_149855_4_)) {
            p_149855_1_.setBlock(p_149855_2_, p_149855_3_, p_149855_4_, BlockTFHugeLilyPad.getBlockById((int)0), 0, 2);
        }
    }

    public int getMobilityFlag() {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBlockColor() {
        return 2129968;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderColor(int p_149741_1_) {
        return 2129968;
    }

    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(IBlockAccess p_149720_1_, int p_149720_2_, int p_149720_3_, int p_149720_4_) {
        return 2129968;
    }
}

