/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import twilightforest.block.TFBlocks;
import twilightforest.item.TFItems;

public class BlockTFHedge
extends BlockLeavesBase {
    public int damageDone = 3;
    public static IIcon sprHedge;
    public static IIcon sprDarkwoodLeaves;

    protected BlockTFHedge() {
        super(Material.cactus, false);
        this.setHardness(2.0f);
        this.setResistance(10.0f);
        this.setStepSound(Block.soundTypeGrass);
        this.setCreativeTab(TFItems.creativeTab);
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        switch (meta) {
            case 0: {
                float f = 0.0625f;
                return AxisAlignedBB.getBoundingBox((double)x, (double)y, (double)z, (double)(x + 1), (double)((float)(y + 1) - f), (double)(z + 1));
            }
        }
        return AxisAlignedBB.getBoundingBox((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
    }

    public boolean isOpaqueCube() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        Block i1 = par1IBlockAccess.getBlock(par2, par3, par4);
        return !this.field_150121_P && i1 == this ? false : super.shouldSideBeRendered(par1IBlockAccess, par2, par3, par4, par5);
    }

    public int damageDropped(int meta) {
        if (meta == 2) {
            meta = 0;
        }
        if (meta == 1) {
            return 3;
        }
        return meta;
    }

    public IIcon getIcon(int side, int meta) {
        switch (meta) {
            case 1: {
                return sprDarkwoodLeaves;
            }
        }
        return sprHedge;
    }

    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        int meta = world.getBlockMetadata(x, y, z);
        if (meta == 2) {
            meta = 0;
        }
        if (meta == 0 && this.shouldDamage(entity)) {
            entity.attackEntityFrom(DamageSource.cactus, (float)this.damageDone);
        }
    }

    public void onEntityWalking(World world, int x, int y, int z, Entity entity) {
        int meta = world.getBlockMetadata(x, y, z);
        if (meta == 2) {
            meta = 0;
        }
        if (meta == 0 && this.shouldDamage(entity)) {
            entity.attackEntityFrom(DamageSource.cactus, (float)this.damageDone);
        }
    }

    public void onBlockClicked(World world, int x, int y, int z, EntityPlayer entityplayer) {
        int meta = world.getBlockMetadata(x, y, z);
        if (meta == 2) {
            meta = 0;
        }
        if (meta == 0 && !world.isRemote) {
            world.scheduleBlockUpdate(x, y, z, (Block)this, 10);
        }
    }

    public void harvestBlock(World world, EntityPlayer entityplayer, int i, int j, int k, int meta) {
        super.harvestBlock(world, entityplayer, i, j, k, meta);
        if (meta == 2) {
            meta = 0;
        }
        if (meta == 0) {
            entityplayer.attackEntityFrom(DamageSource.cactus, (float)this.damageDone);
        }
    }

    public void updateTick(World world, int x, int y, int z, Random random) {
        double range = 4.0;
        List nearbyPlayers = world.getEntitiesWithinAABB(EntityPlayer.class, AxisAlignedBB.getBoundingBox((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).expand(range, range, range));
        for (EntityPlayer player : nearbyPlayers) {
            MovingObjectPosition mop;
            if (!player.isSwingInProgress || (mop = this.getPlayerPointVec(world, player, range)) == null || world.getBlock(mop.blockX, mop.blockY, mop.blockZ) != this) continue;
            player.attackEntityFrom(DamageSource.cactus, (float)this.damageDone);
            world.scheduleBlockUpdate(x, y, z, (Block)this, 10);
        }
    }

    private MovingObjectPosition getPlayerPointVec(World worldObj, EntityPlayer player, double range) {
        Vec3 position = Vec3.createVectorHelper((double)player.posX, (double)(player.posY + (double)player.getEyeHeight()), (double)player.posZ);
        Vec3 look = player.getLook(1.0f);
        Vec3 dest = position.addVector(look.xCoord * range, look.yCoord * range, look.zCoord * range);
        return worldObj.rayTraceBlocks(position, dest);
    }

    private boolean shouldDamage(Entity entity) {
        return !(entity instanceof EntitySpider) && !(entity instanceof EntityItem) && !entity.doesEntityNotTriggerPressurePlate();
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        int metadata = world.getBlockMetadata(x, y, z);
        return metadata == 1 ? 1 : 0;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return 0;
    }

    public int quantityDropped(Random par1Random) {
        return par1Random.nextInt(40) == 0 ? 1 : 0;
    }

    public Item getItemDropped(int meta, Random par2Random, int par3) {
        if (meta == 1) {
            return Item.getItemFromBlock((Block)TFBlocks.sapling);
        }
        return null;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return new ItemStack((Block)this, 1, world.getBlockMetadata(x, y, z));
    }

    public void dropBlockAsItemWithChance(World par1World, int par2, int par3, int par4, int meta, float par6, int fortune) {
        if (!par1World.isRemote && meta == 1 && par1World.rand.nextInt(40) == 0) {
            Item var9 = this.getItemDropped(meta, par1World.rand, fortune);
            this.dropBlockAsItem(par1World, par2, par3, par4, new ItemStack(var9, 1, this.damageDropped(meta)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister par1IconRegister) {
        sprHedge = par1IconRegister.registerIcon("TwilightForest:hedge");
        sprDarkwoodLeaves = par1IconRegister.registerIcon("TwilightForest:darkwood_leaves");
    }
}

