/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import twilightforest.block.GiantBlockIcon;

public abstract class BlockTFGiantBlock
extends Block {
    private IIcon[][][] giantIcon;
    private Block baseBlock;
    private boolean isSelfDestructing;

    public BlockTFGiantBlock(Block baseBlock) {
        super(baseBlock.getMaterial());
        this.setStepSound(baseBlock.stepSound);
        this.baseBlock = baseBlock;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister par1IconRegister) {
        this.giantIcon = new GiantBlockIcon[4][4][6];
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                for (int side = 0; side < 6; ++side) {
                    this.giantIcon[x][y][side] = new GiantBlockIcon(this.baseBlock.getBlockTextureFromSide(side), x, y);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(IBlockAccess world, int x, int y, int z, int side) {
        switch (side) {
            default: {
                return this.giantIcon[x & 3][z & 3][side];
            }
            case 2: {
                return this.giantIcon[3 - (x & 3)][3 - (y & 3)][side];
            }
            case 3: {
                return this.giantIcon[x & 3][3 - (y & 3)][side];
            }
            case 4: {
                return this.giantIcon[z & 3][3 - (y & 3)][side];
            }
            case 5: 
        }
        return this.giantIcon[3 - (z & 3)][3 - (y & 3)][side];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        return this.giantIcon[0][0][side];
    }

    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        int bx = x >> 2 << 2;
        int by = y >> 2 << 2;
        int bz = z >> 2 << 2;
        boolean allReplaceable = true;
        for (int dx = 0; dx < 4; ++dx) {
            for (int dy = 0; dy < 4; ++dy) {
                for (int dz = 0; dz < 4; ++dz) {
                    allReplaceable &= world.getBlock(bx + dx, by + dy, bz + dz).isReplaceable((IBlockAccess)world, bx + dx, by + dy, bz + dz);
                }
            }
        }
        return super.canPlaceBlockAt(world, x, y, z) && allReplaceable;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        int bx = x >> 2 << 2;
        int by = y >> 2 << 2;
        int bz = z >> 2 << 2;
        return AxisAlignedBB.getBoundingBox((double)((double)bx + this.minX), (double)((double)by + this.minY), (double)((double)bz + this.minZ), (double)((double)bx + this.maxX * 4.0), (double)((double)by + this.maxY * 4.0), (double)((double)bz + this.maxZ * 4.0));
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemStack) {
        if (!world.isRemote) {
            int bx = x >> 2 << 2;
            int by = y >> 2 << 2;
            int bz = z >> 2 << 2;
            for (int dx = 0; dx < 4; ++dx) {
                for (int dy = 0; dy < 4; ++dy) {
                    for (int dz = 0; dz < 4; ++dz) {
                        world.setBlock(bx + dx, by + dy, bz + dz, (Block)this, 0, 2);
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        int bx = x >> 2 << 2;
        int by = y >> 2 << 2;
        int bz = z >> 2 << 2;
        Block blockThere = world.getBlock(x, y, z);
        int metaThere = world.getBlockMetadata(x, y, z);
        int b0 = 16;
        for (int i1 = 0; i1 < b0; ++i1) {
            for (int j1 = 0; j1 < b0; ++j1) {
                for (int k1 = 0; k1 < b0; ++k1) {
                    double d0 = (double)bx + ((double)i1 + 0.5) / 4.0;
                    double d1 = (double)by + ((double)j1 + 0.5) / 4.0;
                    double d2 = (double)bz + ((double)k1 + 0.5) / 4.0;
                    effectRenderer.addEffect((EntityFX)new EntityDiggingFX(world, d0, d1, d2, d0 - (double)x - 0.5, d1 - (double)y - 0.5, d2 - (double)z - 0.5, blockThere, metaThere).applyColourMultiplier(x, y, z));
                }
            }
        }
        return true;
    }

    public void onBlockHarvested(World world, int x, int y, int z, int meta, EntityPlayer player) {
        this.setGiantBlockToAir(world, x, y, z);
    }

    public void onBlockExploded(World world, int x, int y, int z, Explosion explosion) {
        world.setBlockToAir(x, y, z);
        this.setGiantBlockToAir(world, x, y, z);
    }

    public void onBlockPreDestroy(World world, int x, int y, int z, int meta) {
        if (!this.isSelfDestructing && !this.canBlockStay(world, x, y, z)) {
            this.setGiantBlockToAir(world, x, y, z);
        }
    }

    private void setGiantBlockToAir(World world, int x, int y, int z) {
        this.isSelfDestructing = true;
        int bx = x >> 2 << 2;
        int by = y >> 2 << 2;
        int bz = z >> 2 << 2;
        for (int dx = 0; dx < 4; ++dx) {
            for (int dy = 0; dy < 4; ++dy) {
                for (int dz = 0; dz < 4; ++dz) {
                    if (x == bx + dx && y == by + dy && z == bz + dz || world.getBlock(bx + dx, by + dy, bz + dz) != this) continue;
                    world.setBlockToAir(bx + dx, by + dy, bz + dz);
                }
            }
        }
        this.isSelfDestructing = false;
    }

    public boolean canBlockStay(World world, int x, int y, int z) {
        boolean allThisBlock = true;
        int bx = x >> 2 << 2;
        int by = y >> 2 << 2;
        int bz = z >> 2 << 2;
        for (int dx = 0; dx < 4; ++dx) {
            for (int dy = 0; dy < 4; ++dy) {
                for (int dz = 0; dz < 4; ++dz) {
                    allThisBlock &= world.getBlock(bx + dx, by + dy, bz + dz) == this;
                }
            }
        }
        return allThisBlock;
    }

    public int getMobilityFlag() {
        return 2;
    }
}

