/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import twilightforest.block.TFBlocks;
import twilightforest.item.TFItems;
import twilightforest.tileentity.TileEntityTFFlameJet;
import twilightforest.tileentity.TileEntityTFPoppingJet;
import twilightforest.tileentity.TileEntityTFSmoker;

public class BlockTFFireJet
extends Block {
    public static final int META_SMOKER = 0;
    public static final int META_ENCASED_SMOKER_OFF = 1;
    public static final int META_ENCASED_SMOKER_ON = 2;
    public static final int META_JET_IDLE = 8;
    public static final int META_JET_POPPING = 9;
    public static final int META_JET_FLAME = 10;
    public static final int META_ENCASED_JET_IDLE = 11;
    public static final int META_ENCASED_JET_POPPING = 12;
    public static final int META_ENCASED_JET_FLAME = 13;
    private IIcon iconJet;
    private IIcon iconSide;
    private IIcon iconSmokerInactive;
    private IIcon iconSmokerActive;
    private IIcon iconJetInactive;
    private IIcon iconJetActive;

    protected BlockTFFireJet() {
        super(Material.rock);
        this.setHardness(1.5f);
        this.setStepSound(Block.soundTypeWood);
        this.setCreativeTab(TFItems.creativeTab);
        this.setTickRandomly(true);
    }

    public int damageDropped(int meta) {
        switch (meta) {
            default: {
                return meta;
            }
            case 2: {
                return 1;
            }
            case 12: 
            case 13: {
                return 11;
            }
            case 9: 
            case 10: 
        }
        return 8;
    }

    public IIcon getIcon(int side, int meta) {
        if (meta == 1) {
            if (side >= 2) {
                return this.iconSmokerInactive;
            }
            if (side == 1) {
                return TFBlocks.towerDevice.getIcon(side, 10);
            }
            return TFBlocks.towerWood.getIcon(side, 1);
        }
        if (meta == 2) {
            if (side >= 2) {
                return this.iconSmokerActive;
            }
            if (side == 1) {
                return TFBlocks.towerDevice.getIcon(side, 11);
            }
            return TFBlocks.towerWood.getIcon(side, 1);
        }
        if (meta == 11) {
            if (side >= 2) {
                return this.iconJetInactive;
            }
            if (side == 1) {
                return TFBlocks.towerDevice.getIcon(side, 10);
            }
            return TFBlocks.towerWood.getIcon(side, 1);
        }
        if (meta == 12 || meta == 13) {
            if (side >= 2) {
                return this.iconJetActive;
            }
            if (side == 1) {
                return TFBlocks.towerDevice.getIcon(side, 11);
            }
            return TFBlocks.towerWood.getIcon(side, 1);
        }
        if (side == 1) {
            return this.iconJet;
        }
        return this.iconSide;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister par1IconRegister) {
        this.iconSide = par1IconRegister.registerIcon("TwilightForest:firejet_side");
        this.iconJet = par1IconRegister.registerIcon("TwilightForest:firejet_top");
        this.iconSmokerInactive = par1IconRegister.registerIcon("TwilightForest:towerdev_smoker_off");
        this.iconSmokerActive = par1IconRegister.registerIcon("TwilightForest:towerdev_smoker_on");
        this.iconJetInactive = par1IconRegister.registerIcon("TwilightForest:towerdev_firejet_off");
        this.iconJetActive = par1IconRegister.registerIcon("TwilightForest:towerdev_firejet_on");
    }

    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(IBlockAccess par1IBlockAccess, int x, int y, int z) {
        int meta = par1IBlockAccess.getBlockMetadata(x, y, z);
        if (meta == 1 || meta == 2 || meta == 11 || meta == 12 || meta == 13) {
            return super.colorMultiplier(par1IBlockAccess, x, y, z);
        }
        int red = 0;
        int grn = 0;
        int blu = 0;
        for (int var8 = -1; var8 <= 1; ++var8) {
            for (int var9 = -1; var9 <= 1; ++var9) {
                int biomeColor = par1IBlockAccess.getBiomeGenForCoords(x + var9, z + var8).getBiomeGrassColor(x + var9, y, z + var8);
                red += (biomeColor & 0xFF0000) >> 16;
                grn += (biomeColor & 0xFF00) >> 8;
                blu += biomeColor & 0xFF;
            }
        }
        return (red / 9 & 0xFF) << 16 | (grn / 9 & 0xFF) << 8 | blu / 9 & 0xFF;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        if (world.getBlock(x, y, z) == this) {
            int meta = world.getBlockMetadata(x, y, z);
            switch (meta) {
                default: {
                    return 0;
                }
                case 10: 
                case 13: 
            }
            return 15;
        }
        return 0;
    }

    public void updateTick(World world, int x, int y, int z, Random random) {
        if (!world.isRemote && world.getBlockMetadata(x, y, z) == 8) {
            ChunkCoordinates lavaPos = this.findLavaAround(world, x, y - 1, z);
            if (this.isLava(world, lavaPos.posX, lavaPos.posY, lavaPos.posZ)) {
                world.setBlock(lavaPos.posX, lavaPos.posY, lavaPos.posZ, Blocks.air, 0, 2);
                world.setBlock(x, y, z, (Block)this, 9, 0);
            }
        }
    }

    public void onNeighborBlockChange(World par1World, int x, int y, int z, Block myBlockID) {
        int meta = par1World.getBlockMetadata(x, y, z);
        if (!par1World.isRemote) {
            if (meta == 1 && par1World.isBlockIndirectlyGettingPowered(x, y, z)) {
                par1World.setBlock(x, y, z, (Block)this, 2, 3);
                par1World.playSoundEffect((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 0.3f, 0.6f);
            }
            if (meta == 2 && !par1World.isBlockIndirectlyGettingPowered(x, y, z)) {
                par1World.setBlock(x, y, z, (Block)this, 1, 3);
                par1World.playSoundEffect((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 0.3f, 0.6f);
            }
            if (meta == 11 && par1World.isBlockIndirectlyGettingPowered(x, y, z)) {
                par1World.setBlock(x, y, z, (Block)this, 12, 3);
                par1World.playSoundEffect((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 0.3f, 0.6f);
            }
        }
    }

    private ChunkCoordinates findLavaAround(World world, int x, int y, int z) {
        int rz;
        if (this.isLava(world, x, y, z)) {
            return new ChunkCoordinates(x, y, z);
        }
        int rx = x + world.rand.nextInt(3) - 1;
        if (this.isLava(world, rx, y, rz = z + world.rand.nextInt(3) - 1)) {
            return new ChunkCoordinates(rx, y, rz);
        }
        rx = x + world.rand.nextInt(3) - 1;
        if (this.isLava(world, rx, y, rz = z + world.rand.nextInt(3) - 1)) {
            return new ChunkCoordinates(rx, y, rz);
        }
        rx = x + world.rand.nextInt(3) - 1;
        if (this.isLava(world, rx, y, rz = z + world.rand.nextInt(3) - 1)) {
            return new ChunkCoordinates(rx, y, rz);
        }
        return new ChunkCoordinates(x, y, z);
    }

    private boolean isLava(World world, int x, int y, int z) {
        return world.getBlock(x, y, z).getMaterial() == Material.lava && world.getBlockMetadata(x, y, z) == 0;
    }

    public boolean hasTileEntity(int meta) {
        switch (meta) {
            case 0: 
            case 2: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        switch (metadata) {
            case 0: 
            case 2: {
                return new TileEntityTFSmoker();
            }
            case 9: {
                return new TileEntityTFPoppingJet(10);
            }
            case 10: {
                return new TileEntityTFFlameJet(8);
            }
            case 12: {
                return new TileEntityTFPoppingJet(13);
            }
            case 13: {
                return new TileEntityTFFlameJet(11);
            }
        }
        return null;
    }

    public void getSubBlocks(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        itemList.add(new ItemStack(item, 1, 0));
        itemList.add(new ItemStack(item, 1, 8));
        itemList.add(new ItemStack(item, 1, 1));
        itemList.add(new ItemStack(item, 1, 11));
    }
}

