/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import twilightforest.block.TFBlocks;
import twilightforest.item.TFItems;

public class BlockTFDarkLeaves
extends Block {
    protected BlockTFDarkLeaves() {
        super(Material.leaves);
        this.setHardness(2.0f);
        this.setResistance(10.0f);
        this.setStepSound(Block.soundTypeGrass);
        this.setCreativeTab(TFItems.creativeTab);
        this.textureName = "TwilightForest:darkwood_leaves2";
    }

    @SideOnly(value=Side.CLIENT)
    public int getBlockColor() {
        double d0 = 0.5;
        double d1 = 1.0;
        return ColorizerFoliage.getFoliageColor((double)d0, (double)d1);
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderColor(int p_149741_1_) {
        return ColorizerFoliage.getFoliageColorBasic();
    }

    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(IBlockAccess world, int x, int y, int z) {
        int red = 0;
        int grn = 0;
        int blu = 0;
        for (int dz = -1; dz <= 1; ++dz) {
            for (int dx = -1; dx <= 1; ++dx) {
                int i2 = world.getBiomeGenForCoords(x + dx, z + dz).getBiomeFoliageColor(x + dx, y, z + dz);
                red += (i2 & 0xFF0000) >> 16;
                grn += (i2 & 0xFF00) >> 8;
                blu += i2 & 0xFF;
            }
        }
        return (red / 9 & 0xFF) << 16 | (grn / 9 & 0xFF) << 8 | blu / 9 & 0xFF;
    }

    public int damageDropped(int meta) {
        return 3;
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return 1;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return 0;
    }

    public int quantityDropped(Random par1Random) {
        return par1Random.nextInt(40) == 0 ? 1 : 0;
    }

    public Item getItemDropped(int meta, Random par2Random, int par3) {
        return Item.getItemFromBlock((Block)TFBlocks.sapling);
    }

    public void dropBlockAsItemWithChance(World par1World, int par2, int par3, int par4, int meta, float par6, int fortune) {
        if (!par1World.isRemote && par1World.rand.nextInt(40) == 0) {
            Item var9 = this.getItemDropped(meta, par1World.rand, fortune);
            this.dropBlockAsItem(par1World, par2, par3, par4, new ItemStack(var9, 1, this.damageDropped(meta)));
        }
    }
}

