/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import twilightforest.TFGenericPacketHandler;
import twilightforest.TwilightForestMod;
import twilightforest.block.TFBlocks;
import twilightforest.item.TFItems;
import twilightforest.world.ChunkProviderTwilightForest;
import twilightforest.world.WorldProviderTwilightForest;

public class BlockTFCastleDoor
extends Block {
    private IIcon activeIcon;
    private boolean isVanished;

    public BlockTFCastleDoor(boolean isVanished) {
        super(isVanished ? Material.glass : Material.rock);
        this.isVanished = isVanished;
        this.lightOpacity = isVanished ? 0 : 255;
        this.setCreativeTab(TFItems.creativeTab);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister register) {
        if (this.isVanished) {
            this.blockIcon = register.registerIcon("TwilightForest:castle_door_vanished");
            this.activeIcon = register.registerIcon("TwilightForest:castle_door_vanished_active");
        } else {
            this.blockIcon = register.registerIcon("TwilightForest:castle_door");
            this.activeIcon = register.registerIcon("TwilightForest:castle_door_active");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.getBlockMetadata(x, y, z);
        if (BlockTFCastleDoor.isMetaActive(meta)) {
            return this.activeIcon;
        }
        return this.blockIcon;
    }

    public boolean isOpaqueCube() {
        return !this.isVanished;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World par1World, int x, int y, int z) {
        if (this.isVanished) {
            return null;
        }
        this.setBlockBoundsBasedOnState((IBlockAccess)par1World, x, y, z);
        return super.getCollisionBoundingBoxFromPool(par1World, x, y, z);
    }

    public boolean getBlocksMovement(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        return !this.isVanished;
    }

    public boolean onBlockActivated(World par1World, int x, int y, int z, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
        int meta = par1World.getBlockMetadata(x, y, z);
        if (!BlockTFCastleDoor.isMetaActive(meta)) {
            if (BlockTFCastleDoor.isBlockLocked(par1World, x, y, z)) {
                par1World.playSoundEffect((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 1.0f, 0.3f);
            } else {
                BlockTFCastleDoor.changeToActiveBlock(par1World, x, y, z, meta);
            }
            return true;
        }
        return false;
    }

    public static void changeToActiveBlock(World par1World, int x, int y, int z, int meta) {
        BlockTFCastleDoor.changeToBlockMeta(par1World, x, y, z, meta | 8);
        BlockTFCastleDoor.playVanishSound(par1World, x, y, z);
        Block blockAt = par1World.getBlock(x, y, z);
        par1World.scheduleBlockUpdate(x, y, z, blockAt, 2 + par1World.rand.nextInt(5));
    }

    private static void changeToBlockMeta(World par1World, int x, int y, int z, int meta) {
        Block blockAt = par1World.getBlock(x, y, z);
        if (blockAt == TFBlocks.castleDoor || blockAt == TFBlocks.castleDoorVanished) {
            par1World.setBlock(x, y, z, blockAt, meta, 3);
            par1World.markBlockRangeForRenderUpdate(x, y, z, x, y, z);
            par1World.notifyBlocksOfNeighborChange(x, y, z, blockAt);
        }
    }

    public static boolean isBlockLocked(World par1World, int x, int y, int z) {
        int meta = par1World.getBlockMetadata(x, y, z);
        if (!par1World.isRemote && par1World.provider instanceof WorldProviderTwilightForest) {
            ChunkProviderTwilightForest chunkProvider = ((WorldProviderTwilightForest)par1World.provider).getChunkProvider();
            return chunkProvider.isStructureLocked(x, y, z, meta);
        }
        return false;
    }

    public static boolean isMetaActive(int meta) {
        return (meta & 8) != 0;
    }

    public int tickRate() {
        return 5;
    }

    public int getRenderType() {
        return TwilightForestMod.proxy.getCastleMagicBlockRenderID();
    }

    public void updateTick(World par1World, int x, int y, int z, Random par5Random) {
        if (!par1World.isRemote) {
            int meta = par1World.getBlockMetadata(x, y, z);
            if (this.isVanished) {
                if (BlockTFCastleDoor.isMetaActive(meta)) {
                    par1World.setBlock(x, y, z, TFBlocks.castleDoor, meta & 7, 3);
                    par1World.notifyBlocksOfNeighborChange(x, y, z, (Block)this);
                    BlockTFCastleDoor.playVanishSound(par1World, x, y, z);
                } else {
                    BlockTFCastleDoor.changeToActiveBlock(par1World, x, y, z, meta);
                }
            } else if (BlockTFCastleDoor.isMetaActive(meta)) {
                par1World.setBlock(x, y, z, BlockTFCastleDoor.getOtherBlock(this), meta & 7, 3);
                par1World.scheduleBlockUpdate(x, y, z, BlockTFCastleDoor.getOtherBlock(this), 80);
                par1World.notifyBlocksOfNeighborChange(x, y, z, (Block)this);
                BlockTFCastleDoor.playReappearSound(par1World, x, y, z);
                par1World.markBlockRangeForRenderUpdate(x, y, z, x, y, z);
                this.sendAnnihilateBlockPacket(par1World, x, y, z);
                BlockTFCastleDoor.checkAndActivateCastleDoor(par1World, x - 1, y, z);
                BlockTFCastleDoor.checkAndActivateCastleDoor(par1World, x + 1, y, z);
                BlockTFCastleDoor.checkAndActivateCastleDoor(par1World, x, y + 1, z);
                BlockTFCastleDoor.checkAndActivateCastleDoor(par1World, x, y - 1, z);
                BlockTFCastleDoor.checkAndActivateCastleDoor(par1World, x, y, z + 1);
                BlockTFCastleDoor.checkAndActivateCastleDoor(par1World, x, y, z - 1);
            }
        }
    }

    private void sendAnnihilateBlockPacket(World world, int x, int y, int z) {
        FMLProxyPacket message = TFGenericPacketHandler.makeAnnihilateBlockPacket(x, y, z);
        NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(world.provider.dimensionId, (double)x, (double)y, (double)z, 64.0);
        TwilightForestMod.genericChannel.sendToAllAround(message, targetPoint);
    }

    private static void playVanishSound(World par1World, int x, int y, int z) {
        par1World.playSoundEffect((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.fizz", 0.125f, par1World.rand.nextFloat() * 0.25f + 1.75f);
    }

    private static void playReappearSound(World par1World, int x, int y, int z) {
        par1World.playSoundEffect((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.fizz", 0.125f, par1World.rand.nextFloat() * 0.25f + 1.25f);
    }

    private static Block getOtherBlock(Block block) {
        return block == TFBlocks.castleDoor ? TFBlocks.castleDoorVanished : TFBlocks.castleDoor;
    }

    public static void checkAndActivateCastleDoor(World world, int x, int y, int z) {
        Block block = world.getBlock(x, y, z);
        int meta = world.getBlockMetadata(x, y, z);
        if (block == TFBlocks.castleDoor && !BlockTFCastleDoor.isMetaActive(meta) && !BlockTFCastleDoor.isBlockLocked(world, x, y, z)) {
            BlockTFCastleDoor.changeToActiveBlock(world, x, y, z, meta);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World par1World, int x, int y, int z, Random par5Random) {
        int meta = par1World.getBlockMetadata(x, y, z);
        if (BlockTFCastleDoor.isMetaActive(meta)) {
            // empty if block
        }
        for (int i = 0; i < 1; ++i) {
        }
    }

    public void sparkle(World world, int x, int y, int z, Random rand) {
        double offset = 0.0625;
        for (int side = 0; side < 6; ++side) {
            double rx = (float)x + rand.nextFloat();
            double ry = (float)y + rand.nextFloat();
            double rz = (float)z + rand.nextFloat();
            if (side == 0 && !world.getBlock(x, y + 1, z).isOpaqueCube()) {
                ry = (double)(y + 1) + offset;
            }
            if (side == 1 && !world.getBlock(x, y - 1, z).isOpaqueCube()) {
                ry = (double)(y + 0) - offset;
            }
            if (side == 2 && !world.getBlock(x, y, z + 1).isOpaqueCube()) {
                rz = (double)(z + 1) + offset;
            }
            if (side == 3 && !world.getBlock(x, y, z - 1).isOpaqueCube()) {
                rz = (double)(z + 0) - offset;
            }
            if (side == 4 && !world.getBlock(x + 1, y, z).isOpaqueCube()) {
                rx = (double)(x + 1) + offset;
            }
            if (side == 5 && !world.getBlock(x - 1, y, z).isOpaqueCube()) {
                rx = (double)(x + 0) - offset;
            }
            if (!(rx < (double)x || rx > (double)(x + 1) || ry < 0.0 || ry > (double)(y + 1) || rz < (double)z) && !(rz > (double)(z + 1))) continue;
            world.spawnParticle("reddust", rx, ry, rz, 0.0, 0.0, 0.0);
        }
    }
}

