/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.biomes;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenPumpkin;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import twilightforest.TFFeature;
import twilightforest.biomes.TFBiomeDecorator;
import twilightforest.block.TFBlocks;
import twilightforest.world.TFGenDarkCanopyTree;
import twilightforest.world.TFGenTallGrass;
import twilightforest.world.TFTreeGenerator;
import twilightforest.world.TFWorld;

public class TFDarkForestBiomeDecorator
extends TFBiomeDecorator {
    TFTreeGenerator darkCanopyTreeGen = new TFGenDarkCanopyTree();
    TFGenTallGrass worldGenDeadBush = new TFGenTallGrass(TFBlocks.plant, 11, 8);
    WorldGenTallGrass worldGenForestGrass = new WorldGenTallGrass(TFBlocks.plant, 10);
    WorldGenTallGrass worldGenMushgloom = new WorldGenTallGrass(TFBlocks.plant, 9);

    @Override
    public void decorateChunk(World world, Random rand, BiomeGenBase biome, int mapX, int mapZ) {
        TFFeature nearFeature = TFFeature.getNearestFeature(mapX >> 4, mapZ >> 4, world);
        if (nearFeature.areChunkDecorationsEnabled) {
            int ry;
            int rz;
            int rx;
            int ry2;
            int rz2;
            int rx2;
            int i;
            int nc = (int)this.canopyPerChunk + (rand.nextFloat() < this.canopyPerChunk - (float)((int)this.canopyPerChunk) ? 1 : 0);
            for (i = 0; i < nc; ++i) {
                rx2 = mapX + rand.nextInt(16) + 8;
                rz2 = mapZ + rand.nextInt(16) + 8;
                ry2 = world.getHeightValue(rx2, rz2);
                this.darkCanopyTreeGen.generate(world, rand, rx2, ry2, rz2);
            }
            for (i = 0; i < this.treesPerChunk; ++i) {
                rx2 = mapX + rand.nextInt(16) + 8;
                rz2 = mapZ + rand.nextInt(16) + 8;
                ry2 = this.getGroundLevel(world, rx2, rz2);
                WorldGenAbstractTree var5 = biome.func_150567_a(rand);
                var5.setScale(1.0, 1.0, 1.0);
                var5.generate(world, rand, rx2, ry2, rz2);
            }
            for (i = 0; i < this.deadBushPerChunk; ++i) {
                rx2 = mapX + rand.nextInt(16) + 8;
                rz2 = mapZ + rand.nextInt(16) + 8;
                ry2 = rand.nextInt(128);
                this.worldGenDeadBush.generate(world, rand, rx2, ry2, rz2);
            }
            for (i = 0; i < this.deadBushPerChunk; ++i) {
                rx2 = mapX + rand.nextInt(16) + 8;
                rz2 = mapZ + rand.nextInt(16) + 8;
                ry2 = rand.nextInt(128);
                this.worldGenForestGrass.generate(world, rand, rx2, ry2, rz2);
            }
            for (i = 0; i < this.mushroomsPerChunk; ++i) {
                if (rand.nextInt(8) == 0) {
                    rx2 = mapX + rand.nextInt(16) + 8;
                    rz2 = mapZ + rand.nextInt(16) + 8;
                    ry2 = this.getGroundLevel(world, rx2, rz2);
                    this.mushroomBrownGen.generate(world, rand, rx2, ry2, rz2);
                }
                if (rand.nextInt(16) == 0) {
                    rx2 = mapX + rand.nextInt(16) + 8;
                    rz2 = mapZ + rand.nextInt(16) + 8;
                    ry2 = this.getGroundLevel(world, rx2, rz2);
                    this.mushroomRedGen.generate(world, rand, rx2, ry2, rz2);
                }
                if (rand.nextInt(24) != 0) continue;
                rx2 = mapX + rand.nextInt(16) + 8;
                rz2 = mapZ + rand.nextInt(16) + 8;
                ry2 = this.getGroundLevel(world, rx2, rz2);
                this.worldGenMushgloom.generate(world, rand, rx2, ry2, rz2);
            }
            if (rand.nextInt(4) == 0) {
                rx = mapX + rand.nextInt(16) + 8;
                rz = mapZ + rand.nextInt(16) + 8;
                ry = rand.nextInt(128);
                this.mushroomBrownGen.generate(world, rand, rx, ry, rz);
            }
            if (rand.nextInt(8) == 0) {
                rx = mapX + rand.nextInt(16) + 8;
                rz = mapZ + rand.nextInt(16) + 8;
                ry = rand.nextInt(128);
                this.mushroomRedGen.generate(world, rand, rx, ry, rz);
            }
            if (rand.nextInt(32) == 0) {
                rx = mapX + rand.nextInt(16) + 8;
                rz = mapZ + rand.nextInt(16) + 8;
                ry = this.getGroundLevel(world, rx, rz);
                new WorldGenPumpkin().generate(world, rand, rx, ry, rz);
            }
        }
        this.decorateUnderground(world, rand, mapX, mapZ);
        this.decorateOnlyOres(world, rand, mapX, mapZ);
    }

    public int getGroundLevel(World world, int x, int z) {
        Chunk chunk = world.getChunkFromBlockCoords(x, z);
        int lastDirt = TFWorld.SEALEVEL;
        for (int y = TFWorld.SEALEVEL; y < TFWorld.CHUNKHEIGHT - 1; ++y) {
            Block blockID = chunk.getBlock(x & 0xF, y, z & 0xF);
            if (blockID == Blocks.grass) {
                return y + 1;
            }
            if (blockID != Blocks.dirt && blockID != Blocks.stone && blockID != Blocks.gravel) continue;
            lastDirt = y + 1;
        }
        return lastDirt;
    }
}

