/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.biomes;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.stats.Achievement;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import twilightforest.TFAchievementPage;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.block.TFBlocks;
import twilightforest.world.TFGenThorns;
import twilightforest.world.TFWorld;

public class TFBiomeThornlands
extends TFBiomeBase {
    private TFGenThorns tfGenThorns;

    public TFBiomeThornlands(int i) {
        super(i);
        this.topBlock = TFBlocks.deadrock;
        this.field_150604_aj = 0;
        this.fillerBlock = TFBlocks.deadrock;
        this.field_76754_C = 1;
        this.temperature = 0.3f;
        this.rainfall = 0.2f;
        this.getTFBiomeDecorator().canopyPerChunk = -999.0f;
        this.getTFBiomeDecorator().setTreesPerChunk(-999);
        this.theBiomeDecorator.deadBushPerChunk = 2;
        this.theBiomeDecorator.cactiPerChunk = -9999;
        this.spawnableCreatureList.clear();
        this.tfGenThorns = new TFGenThorns();
        this.theBiomeDecorator.generateLakes = false;
    }

    public void decorate(World world, Random rand, int mapX, int mapZ) {
        super.decorate(world, rand, mapX, mapZ);
        for (int i = 0; i < 128; ++i) {
            int rx = mapX + rand.nextInt(16) + 8;
            int rz = mapZ + rand.nextInt(16) + 8;
            int ry = this.getGroundLevel(world, rx, rz);
            this.tfGenThorns.generate(world, rand, rx, ry, rz);
        }
    }

    public int getGroundLevel(World world, int x, int z) {
        Chunk chunk = world.getChunkFromBlockCoords(x, z);
        int lastDirt = TFWorld.SEALEVEL;
        for (int y = TFWorld.SEALEVEL; y < TFWorld.CHUNKHEIGHT - 1; ++y) {
            Block blockID = chunk.getBlock(x & 0xF, y, z & 0xF);
            if (blockID == Blocks.grass) {
                return y + 1;
            }
            if (blockID != Blocks.dirt && blockID != Blocks.stone && blockID != Blocks.gravel && blockID != Blocks.sandstone && blockID != Blocks.sand && blockID != Blocks.clay && blockID != TFBlocks.deadrock) continue;
            lastDirt = y + 1;
        }
        return lastDirt;
    }

    @Override
    public Block getStoneReplacementBlock() {
        return TFBlocks.deadrock;
    }

    @Override
    public byte getStoneReplacementMeta() {
        return 2;
    }

    @Override
    protected Achievement getRequiredAchievement() {
        return TFAchievementPage.twilightProgressGlacier;
    }
}

