/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.biomes;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.Achievement;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenTaiga1;
import net.minecraft.world.gen.feature.WorldGenTaiga2;
import twilightforest.TFAchievementPage;
import twilightforest.TFFeature;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.entity.EntityTFWinterWolf;
import twilightforest.entity.EntityTFYeti;
import twilightforest.world.TFGenLargeWinter;

public class TFBiomeSnow
extends TFBiomeBase {
    private static final int MONSTER_SPAWN_RATE = 10;
    Random monsterRNG = new Random(53439L);
    ArrayList<BiomeGenBase.SpawnListEntry> emptyList = new ArrayList();

    public TFBiomeSnow(int i) {
        super(i);
        this.getTFBiomeDecorator().setTreesPerChunk(7);
        this.getTFBiomeDecorator().setGrassPerChunk(1);
        this.temperature = 0.125f;
        this.rainfall = 0.9f;
        this.getTFBiomeDecorator().canopyPerChunk = -999.0f;
        this.getTFBiomeDecorator().generateLakes = false;
        this.spawnableMonsterList.add(new BiomeGenBase.SpawnListEntry(EntityTFYeti.class, 20, 4, 4));
        this.spawnableMonsterList.add(new BiomeGenBase.SpawnListEntry(EntityTFWinterWolf.class, 5, 1, 4));
    }

    @Override
    public WorldGenAbstractTree func_150567_a(Random random) {
        if (random.nextInt(3) == 0) {
            return new WorldGenTaiga1();
        }
        if (random.nextInt(8) == 0) {
            return new TFGenLargeWinter();
        }
        return new WorldGenTaiga2(true);
    }

    public boolean getEnableSnow() {
        return true;
    }

    public boolean canSpawnLightningBolt() {
        return false;
    }

    public List getSpawnableList(EnumCreatureType par1EnumCreatureType) {
        if (par1EnumCreatureType == EnumCreatureType.monster) {
            return this.monsterRNG.nextInt(10) == 0 ? this.spawnableMonsterList : this.emptyList;
        }
        return par1EnumCreatureType == EnumCreatureType.creature ? this.spawnableCreatureList : (par1EnumCreatureType == EnumCreatureType.waterCreature ? this.spawnableWaterCreatureList : (par1EnumCreatureType == EnumCreatureType.ambient ? this.spawnableCaveCreatureList : null));
    }

    @Override
    protected Achievement getRequiredAchievement() {
        return TFAchievementPage.twilightProgressUrghast;
    }

    @Override
    public void enforceProgession(EntityPlayer player, World world) {
        if (!world.isRemote && world.getWorldTime() % 60L == 0L) {
            player.addPotionEffect(new PotionEffect(Potion.moveSlowdown.id, 100, 2));
            if (world.rand.nextInt(4) == 0) {
                TFFeature.yetiCave.trySpawnHintMonster(world, player);
            }
        }
    }
}

