/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.biomes;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.feature.WorldGenPumpkin;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import twilightforest.biomes.TFBiomeTwilightForest;
import twilightforest.block.TFBlocks;
import twilightforest.world.TFGenHangingLamps;
import twilightforest.world.TFGenLampposts;
import twilightforest.world.TFWorld;

public class TFBiomeFireflyForest
extends TFBiomeTwilightForest {
    private static final int LAMPPOST_CHANCE = 4;
    TFGenHangingLamps tfGenHangingLamps;
    TFGenLampposts tfGenLampposts;
    WorldGenTallGrass worldGenMushgloom = new WorldGenTallGrass(TFBlocks.plant, 9);

    public TFBiomeFireflyForest(int i) {
        super(i);
        this.tfGenHangingLamps = new TFGenHangingLamps();
        this.tfGenLampposts = new TFGenLampposts();
        this.temperature = 0.5f;
        this.rainfall = 1.0f;
        this.theBiomeDecorator.flowersPerChunk = 4;
        this.theBiomeDecorator.grassPerChunk = 1;
        this.getTFBiomeDecorator().setTreesPerChunk(2);
    }

    public void decorate(World world, Random rand, int mapX, int mapZ) {
        int ry;
        int rz;
        int rx;
        int flowerCycles = rand.nextInt(3) - 1;
        for (int successfulFlowers = 0; successfulFlowers < flowerCycles; ++successfulFlowers) {
            int i2;
            int l1;
            int k1;
            int flowerType = rand.nextInt(3);
            if (flowerType == 0) {
                genTallFlowers.func_150548_a(1);
            } else if (flowerType == 1) {
                genTallFlowers.func_150548_a(4);
            } else if (flowerType == 2) {
                genTallFlowers.func_150548_a(5);
            }
            for (int tallFlowerTries = 0; tallFlowerTries < 1 && !genTallFlowers.generate(world, rand, k1 = mapX + rand.nextInt(16) + 8, l1 = rand.nextInt(world.getHeightValue(k1, i2 = mapZ + rand.nextInt(16) + 8) + 32), i2); ++tallFlowerTries) {
            }
        }
        super.decorate(world, rand, mapX, mapZ);
        if (rand.nextInt(24) == 0) {
            rx = mapX + rand.nextInt(16) + 8;
            rz = mapZ + rand.nextInt(16) + 8;
            ry = this.getGroundLevel(world, rx, rz);
            this.worldGenMushgloom.generate(world, rand, rx, ry, rz);
        }
        for (int i = 0; i < 30; ++i) {
            int rx2 = mapX + rand.nextInt(16) + 8;
            int rz2 = mapZ + rand.nextInt(16) + 8;
            int ry2 = TFWorld.SEALEVEL + rand.nextInt(TFWorld.CHUNKHEIGHT - TFWorld.SEALEVEL);
            this.tfGenHangingLamps.generate(world, rand, rx2, ry2, rz2);
        }
        if (rand.nextInt(4) == 0) {
            rx = mapX + rand.nextInt(16) + 8;
            rz = mapZ + rand.nextInt(16) + 8;
            ry = this.getGroundLevel(world, rx, rz);
            this.tfGenLampposts.generate(world, rand, rx, ry, rz);
        }
        if (rand.nextInt(32) == 0) {
            rx = mapX + rand.nextInt(16) + 8;
            rz = mapZ + rand.nextInt(16) + 8;
            ry = this.getGroundLevel(world, rx, rz);
            new WorldGenPumpkin().generate(world, rand, rx, ry, rz);
        }
    }

    public int getGroundLevel(World world, int x, int z) {
        Chunk chunk = world.getChunkFromBlockCoords(x, z);
        int lastDirt = TFWorld.SEALEVEL;
        for (int y = TFWorld.SEALEVEL; y < TFWorld.CHUNKHEIGHT - 1; ++y) {
            Block blockID = chunk.getBlock(x & 0xF, y, z & 0xF);
            if (blockID == Blocks.grass) {
                return y + 1;
            }
            if (blockID != Blocks.dirt && blockID != Blocks.stone && blockID != Blocks.gravel) continue;
            lastDirt = y + 1;
        }
        return lastDirt;
    }

    public String func_150572_a(Random p_150572_1_, int p_150572_2_, int p_150572_3_, int p_150572_4_) {
        double flowerVar = MathHelper.clamp_double((double)((1.0 + plantNoise.func_151601_a((double)p_150572_2_ / 48.0, (double)p_150572_4_ / 48.0)) / 2.0), (double)0.0, (double)0.9999);
        int flowerIndex = (int)(flowerVar * (double)BlockFlower.field_149859_a.length);
        if (flowerIndex == 1) {
            flowerIndex = 0;
        }
        return BlockFlower.field_149859_a[flowerIndex];
    }
}

