/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.biomes;

import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.stats.Achievement;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenShrub;
import net.minecraft.world.gen.feature.WorldGenVines;
import twilightforest.TFAchievementPage;
import twilightforest.TFFeature;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.block.TFBlocks;
import twilightforest.world.TFGenFireJet;
import twilightforest.world.TFWorld;

public class TFBiomeFireSwamp
extends TFBiomeBase {
    protected TFBiomeFireSwamp(int i) {
        super(i);
        this.temperature = 1.0f;
        this.rainfall = 0.4f;
        this.getTFBiomeDecorator().setDeadBushPerChunk(2);
        this.getTFBiomeDecorator().setMushroomsPerChunk(8);
        this.getTFBiomeDecorator().setReedsPerChunk(4);
        this.getTFBiomeDecorator().setClayPerChunk(1);
        this.getTFBiomeDecorator().setTreesPerChunk(3);
        this.getTFBiomeDecorator().setWaterlilyPerChunk(6);
        this.waterColorMultiplier = 0x6C2C2C;
        this.getTFBiomeDecorator().canopyPerChunk = -999.0f;
        this.getTFBiomeDecorator().lavaPoolChance = 0.125f;
        this.getTFBiomeDecorator().mangrovesPerChunk = 3;
    }

    @Override
    public WorldGenAbstractTree func_150567_a(Random random) {
        if (random.nextInt(3) == 0) {
            return new WorldGenShrub(3, 0);
        }
        return this.worldGeneratorSwamp;
    }

    public void decorate(World par1World, Random par2Random, int mapX, int mapZ) {
        super.decorate(par1World, par2Random, mapX, mapZ);
        TFFeature nearFeature = TFFeature.getNearestFeature(mapX >> 4, mapZ >> 4, par1World);
        if (nearFeature.areChunkDecorationsEnabled) {
            int k;
            byte byte0;
            int j;
            WorldGenVines worldgenvines = new WorldGenVines();
            for (int i = 0; i < 50; ++i) {
                j = mapX + par2Random.nextInt(16) + 8;
                byte0 = (byte)TFWorld.SEALEVEL;
                k = mapZ + par2Random.nextInt(16) + 8;
                worldgenvines.generate(par1World, par2Random, j, (int)byte0, k);
            }
            TFGenFireJet genSmoker = new TFGenFireJet(TFBlocks.fireJet, 0);
            if (par2Random.nextInt(4) == 0) {
                j = mapX + par2Random.nextInt(16) + 8;
                byte0 = (byte)TFWorld.SEALEVEL;
                k = mapZ + par2Random.nextInt(16) + 8;
                genSmoker.generate(par1World, par2Random, j, byte0, k);
            }
            TFGenFireJet genFireJet = new TFGenFireJet(TFBlocks.fireJet, 8);
            for (int i = 0; i < 1; ++i) {
                int j2 = mapX + par2Random.nextInt(16) + 8;
                byte byte02 = (byte)TFWorld.SEALEVEL;
                int k2 = mapZ + par2Random.nextInt(16) + 8;
                genFireJet.generate(par1World, par2Random, j2, byte02, k2);
            }
        }
    }

    public int getBiomeGrassColor(int x, int y, int z) {
        return 5713443;
    }

    public int getBiomeFoliageColor(int x, int y, int z) {
        return 6563343;
    }

    @Override
    protected Achievement getRequiredAchievement() {
        return TFAchievementPage.twilightProgressLabyrinth;
    }

    @Override
    public void enforceProgession(EntityPlayer player, World world) {
        if (!world.isRemote && world.getWorldTime() % 60L == 0L) {
            player.setFire(8);
        }
        if (world.rand.nextInt(4) == 0) {
            TFFeature.hydraLair.trySpawnHintMonster(world, player);
        }
    }
}

