/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.biomes;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.feature.WorldGenLiquids;
import twilightforest.TFFeature;
import twilightforest.TwilightForestMod;
import twilightforest.world.TFGenCanopyMushroom;
import twilightforest.world.TFGenCanopyTree;
import twilightforest.world.TFGenFallenHollowLog;
import twilightforest.world.TFGenFallenSmallLog;
import twilightforest.world.TFGenFoundation;
import twilightforest.world.TFGenGroveRuins;
import twilightforest.world.TFGenHollowStump;
import twilightforest.world.TFGenHollowTree;
import twilightforest.world.TFGenMangroveTree;
import twilightforest.world.TFGenMonolith;
import twilightforest.world.TFGenMyceliumBlob;
import twilightforest.world.TFGenOutsideStalagmite;
import twilightforest.world.TFGenPlantRoots;
import twilightforest.world.TFGenStoneCircle;
import twilightforest.world.TFGenTorchBerries;
import twilightforest.world.TFGenWell;
import twilightforest.world.TFGenWitchHut;
import twilightforest.world.TFGenWoodRoots;
import twilightforest.world.TFGenerator;
import twilightforest.world.TFTreeGenerator;

public class TFBiomeDecorator
extends BiomeDecorator {
    TFGenCanopyTree canopyTreeGen = new TFGenCanopyTree();
    TFTreeGenerator alternateCanopyGen = new TFGenCanopyMushroom();
    TFGenHollowTree hollowTreeGen;
    TFGenMyceliumBlob myceliumBlobGen;
    WorldGenLakes extraLakeGen;
    WorldGenLakes extraLavaPoolGen;
    TFGenMangroveTree mangroveTreeGen = new TFGenMangroveTree();
    TFGenPlantRoots plantRootGen;
    TFGenWoodRoots woodRootGen;
    WorldGenLiquids caveWaterGen;
    TFGenTorchBerries torchBerryGen;
    public float canopyPerChunk;
    public float alternateCanopyChance = 0.0f;
    public int myceliumPerChunk = 0;
    public int mangrovesPerChunk = 0;
    public int lakesPerChunk = 0;
    public float lavaPoolChance = 0.0f;
    static final List<RuinEntry> ruinList = new ArrayList<RuinEntry>();

    public TFBiomeDecorator() {
        this.myceliumBlobGen = new TFGenMyceliumBlob(5);
        this.hollowTreeGen = new TFGenHollowTree();
        this.extraLakeGen = new WorldGenLakes(Blocks.water);
        this.extraLavaPoolGen = new WorldGenLakes(Blocks.lava);
        this.plantRootGen = new TFGenPlantRoots();
        this.woodRootGen = new TFGenWoodRoots();
        this.caveWaterGen = new WorldGenLiquids((Block)Blocks.flowing_water);
        this.torchBerryGen = new TFGenTorchBerries();
        this.canopyPerChunk = TwilightForestMod.canopyCoverage;
    }

    public void decorateChunk(World world, Random rand, BiomeGenBase biome, int mapX, int mapZ) {
        TFFeature nearFeature = TFFeature.getNearestFeature(mapX >> 4, mapZ >> 4, world);
        if (!nearFeature.areChunkDecorationsEnabled) {
            this.decorateUnderground(world, rand, mapX, mapZ);
            this.decorateOnlyOres(world, rand, mapX, mapZ);
        } else {
            this.currentWorld = null;
            super.decorateChunk(world, rand, biome, mapX, mapZ);
        }
    }

    protected void genDecorations(BiomeGenBase biome) {
        int ry;
        int rx;
        int i;
        int rz;
        int rx2;
        int ry2;
        if (this.randomGenerator.nextInt(6) == 0 && (ry2 = this.currentWorld.getHeightValue(rx2 = this.chunk_X + this.randomGenerator.nextInt(16) + 8, rz = this.chunk_Z + this.randomGenerator.nextInt(16) + 8)) < 75) {
            TFGenerator rf = this.randomFeature(this.randomGenerator);
            rf.generate(this.currentWorld, this.randomGenerator, rx2, ry2, rz);
        }
        int nc = (int)this.canopyPerChunk + (this.randomGenerator.nextFloat() < this.canopyPerChunk - (float)((int)this.canopyPerChunk) ? 1 : 0);
        for (i = 0; i < nc; ++i) {
            rx = this.chunk_X + this.randomGenerator.nextInt(16) + 8;
            int rz2 = this.chunk_Z + this.randomGenerator.nextInt(16) + 8;
            ry = this.currentWorld.getHeightValue(rx, rz2);
            if (this.alternateCanopyChance > 0.0f && this.randomGenerator.nextFloat() <= this.alternateCanopyChance) {
                this.alternateCanopyGen.generate(this.currentWorld, this.randomGenerator, rx, ry, rz2);
                continue;
            }
            this.canopyTreeGen.generate(this.currentWorld, this.randomGenerator, rx, ry, rz2);
        }
        for (i = 0; i < this.mangrovesPerChunk; ++i) {
            rx = this.chunk_X + this.randomGenerator.nextInt(16) + 8;
            int rz3 = this.chunk_Z + this.randomGenerator.nextInt(16) + 8;
            ry = this.currentWorld.getHeightValue(rx, rz3);
            this.mangroveTreeGen.generate(this.currentWorld, this.randomGenerator, rx, ry, rz3);
        }
        for (i = 0; i < this.lakesPerChunk; ++i) {
            rx = this.chunk_X + this.randomGenerator.nextInt(16) + 8;
            int rz4 = this.chunk_Z + this.randomGenerator.nextInt(16) + 8;
            ry = this.currentWorld.getHeightValue(rx, rz4);
            this.extraLakeGen.generate(this.currentWorld, this.randomGenerator, rx, ry, rz4);
        }
        if (this.randomGenerator.nextFloat() <= this.lavaPoolChance) {
            int rx3 = this.chunk_X + this.randomGenerator.nextInt(16) + 8;
            int rz5 = this.chunk_Z + this.randomGenerator.nextInt(16) + 8;
            int ry3 = this.currentWorld.getHeightValue(rx3, rz5);
            this.extraLavaPoolGen.generate(this.currentWorld, this.randomGenerator, rx3, ry3, rz5);
        }
        for (i = 0; i < this.myceliumPerChunk; ++i) {
            rx = this.chunk_X + this.randomGenerator.nextInt(16) + 8;
            int rz6 = this.chunk_Z + this.randomGenerator.nextInt(16) + 8;
            ry = this.currentWorld.getHeightValue(rx, rz6);
            this.myceliumBlobGen.generate(this.currentWorld, this.randomGenerator, rx, ry, rz6);
        }
        super.genDecorations(biome);
        this.decorateUnderground(this.currentWorld, this.randomGenerator, this.chunk_X, this.chunk_Z);
    }

    protected void decorateUnderground(World world, Random rand, int mapX, int mapZ) {
        int rz;
        int ry;
        int rx;
        int i;
        for (i = 0; i < 12; ++i) {
            rx = mapX + rand.nextInt(16) + 8;
            ry = 64;
            rz = mapZ + rand.nextInt(16) + 8;
            this.plantRootGen.generate(world, rand, rx, ry, rz);
        }
        for (i = 0; i < 20; ++i) {
            rx = mapX + rand.nextInt(16) + 8;
            ry = rand.nextInt(64);
            rz = mapZ + rand.nextInt(16) + 8;
            this.woodRootGen.generate(world, rand, rx, ry, rz);
        }
        if (this.generateLakes) {
            for (i = 0; i < 50; ++i) {
                rx = mapX + rand.nextInt(16) + 8;
                ry = rand.nextInt(24) + 4;
                rz = mapZ + rand.nextInt(16) + 8;
                this.caveWaterGen.generate(world, rand, rx, ry, rz);
            }
        }
        for (i = 0; i < 3; ++i) {
            rx = mapX + rand.nextInt(16) + 8;
            ry = 64;
            rz = mapZ + rand.nextInt(16) + 8;
            this.torchBerryGen.generate(world, rand, rx, ry, rz);
        }
    }

    public void decorateOnlyOres(World world, Random rand, int mapX, int mapZ) {
        this.currentWorld = world;
        this.randomGenerator = rand;
        this.chunk_X = mapX;
        this.chunk_Z = mapZ;
        this.generateOres();
        this.currentWorld = null;
        this.randomGenerator = null;
    }

    public TFGenerator randomFeature(Random rand) {
        return ((RuinEntry)WeightedRandom.getRandomItem((Random)rand, TFBiomeDecorator.ruinList)).generator;
    }

    public void setTreesPerChunk(int treesPerChunk) {
        this.treesPerChunk = treesPerChunk;
    }

    public void setBigMushroomsPerChunk(int bigMushroomsPerChunk) {
        this.bigMushroomsPerChunk = bigMushroomsPerChunk;
    }

    public void setClayPerChunk(int clayPerChunk) {
        this.clayPerChunk = clayPerChunk;
    }

    public void setDeadBushPerChunk(int deadBushPerChunk) {
        this.deadBushPerChunk = deadBushPerChunk;
    }

    public void setMushroomsPerChunk(int mushroomsPerChunk) {
        this.mushroomsPerChunk = mushroomsPerChunk;
    }

    public void setFlowersPerChunk(int flowersPerChunk) {
        this.flowersPerChunk = flowersPerChunk;
    }

    public void setReedsPerChunk(int reedsPerChunk) {
        this.reedsPerChunk = reedsPerChunk;
    }

    public void setWaterlilyPerChunk(int waterlilyPerChunk) {
        this.waterlilyPerChunk = waterlilyPerChunk;
    }

    public void setGrassPerChunk(int grassPerChunk) {
        this.grassPerChunk = grassPerChunk;
    }

    static {
        ruinList.add(new RuinEntry(new TFGenStoneCircle(), 10));
        ruinList.add(new RuinEntry(new TFGenWell(), 10));
        ruinList.add(new RuinEntry(new TFGenWitchHut(), 5));
        ruinList.add(new RuinEntry(new TFGenOutsideStalagmite(), 12));
        ruinList.add(new RuinEntry(new TFGenFoundation(), 10));
        ruinList.add(new RuinEntry(new TFGenMonolith(), 10));
        ruinList.add(new RuinEntry(new TFGenGroveRuins(), 5));
        ruinList.add(new RuinEntry(new TFGenHollowStump(), 12));
        ruinList.add(new RuinEntry(new TFGenFallenHollowLog(), 10));
        ruinList.add(new RuinEntry(new TFGenFallenSmallLog(), 10));
    }

    static class RuinEntry
    extends WeightedRandom.Item {
        public final TFGenerator generator;

        public RuinEntry(TFGenerator generator, int weight) {
            super(weight);
            this.generator = generator;
        }
    }
}

