/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.biomes;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.Achievement;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenShrub;
import twilightforest.TFAchievementPage;
import twilightforest.TFFeature;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.biomes.TFDarkForestBiomeDecorator;
import twilightforest.entity.EntityTFKingSpider;
import twilightforest.entity.EntityTFKobold;
import twilightforest.entity.EntityTFMistWolf;
import twilightforest.entity.EntityTFSkeletonDruid;

public class TFBiomeDarkForest
extends TFBiomeBase {
    private static final int MONSTER_SPAWN_RATE = 20;
    Random monsterRNG;
    ArrayList<BiomeGenBase.SpawnListEntry> emptyList = new ArrayList();

    public TFBiomeDarkForest(int i) {
        super(i);
        this.temperature = 0.7f;
        this.rainfall = 0.8f;
        this.getTFBiomeDecorator().canopyPerChunk = 5.5f;
        this.getTFBiomeDecorator().setTreesPerChunk(10);
        this.getTFBiomeDecorator().setGrassPerChunk(-99);
        this.getTFBiomeDecorator().setFlowersPerChunk(-99);
        this.getTFBiomeDecorator().setMushroomsPerChunk(2);
        this.getTFBiomeDecorator().setDeadBushPerChunk(10);
        this.rootHeight = 0.05f;
        this.heightVariation = 0.05f;
        this.monsterRNG = new Random();
        this.spawnableMonsterList.add(new BiomeGenBase.SpawnListEntry(EntityEnderman.class, 1, 1, 4));
        this.spawnableMonsterList.add(new BiomeGenBase.SpawnListEntry(EntityZombie.class, 5, 1, 4));
        this.spawnableMonsterList.add(new BiomeGenBase.SpawnListEntry(EntitySkeleton.class, 5, 1, 4));
        this.spawnableMonsterList.add(new BiomeGenBase.SpawnListEntry(EntityTFMistWolf.class, 10, 1, 4));
        this.spawnableMonsterList.add(new BiomeGenBase.SpawnListEntry(EntityTFSkeletonDruid.class, 10, 1, 4));
        this.spawnableMonsterList.add(new BiomeGenBase.SpawnListEntry(EntityTFKingSpider.class, 10, 1, 4));
        this.spawnableMonsterList.add(new BiomeGenBase.SpawnListEntry(EntityTFKobold.class, 10, 4, 8));
        this.spawnableMonsterList.add(new BiomeGenBase.SpawnListEntry(EntityWitch.class, 1, 1, 1));
        this.theBiomeDecorator.generateLakes = false;
    }

    @Override
    public BiomeDecorator createBiomeDecorator() {
        return new TFDarkForestBiomeDecorator();
    }

    @Override
    public WorldGenAbstractTree func_150567_a(Random random) {
        if (random.nextInt(5) == 0) {
            return new WorldGenShrub(3, 0);
        }
        if (random.nextInt(8) == 0) {
            return this.birchGen;
        }
        return this.worldGeneratorTrees;
    }

    public int getBiomeGrassColor(int x, int y, int z) {
        double var1 = MathHelper.clamp_float((float)this.getFloatTemperature(x, y, z), (float)0.0f, (float)1.0f);
        double var3 = MathHelper.clamp_float((float)this.getFloatRainfall(), (float)0.0f, (float)1.0f);
        return ((ColorizerGrass.getGrassColor((double)var1, (double)var3) & 0xFEFEFE) + 1969742) / 2;
    }

    public int getBiomeFoliageColor(int x, int y, int z) {
        double var1 = MathHelper.clamp_float((float)this.getFloatTemperature(x, y, z), (float)0.0f, (float)1.0f);
        double var3 = MathHelper.clamp_float((float)this.getFloatRainfall(), (float)0.0f, (float)1.0f);
        return ((ColorizerFoliage.getFoliageColor((double)var1, (double)var3) & 0xFEFEFE) + 1969742) / 2;
    }

    public List getSpawnableList(EnumCreatureType par1EnumCreatureType) {
        if (par1EnumCreatureType == EnumCreatureType.monster) {
            return this.monsterRNG.nextInt(20) == 0 ? this.spawnableMonsterList : this.emptyList;
        }
        return par1EnumCreatureType == EnumCreatureType.creature ? this.spawnableCreatureList : (par1EnumCreatureType == EnumCreatureType.waterCreature ? this.spawnableWaterCreatureList : (par1EnumCreatureType == EnumCreatureType.ambient ? this.spawnableCaveCreatureList : null));
    }

    public boolean isHighHumidity() {
        return true;
    }

    @Override
    protected Achievement getRequiredAchievement() {
        return TFAchievementPage.twilightProgressHydra;
    }

    @Override
    public void enforceProgession(EntityPlayer player, World world) {
        if (!world.isRemote && world.getWorldTime() % 60L == 0L) {
            player.addPotionEffect(new PotionEffect(Potion.blindness.id, 100, 0));
            if (world.rand.nextInt(4) == 0) {
                TFFeature.tfStronghold.trySpawnHintMonster(world, player);
            }
        }
    }
}

