/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import cpw.mods.fml.common.FMLLog;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.block.TFBlocks;
import twilightforest.world.TFWorld;

public class TFTeleporter
extends Teleporter {
    protected WorldServer myWorld;
    protected Random rand;

    public TFTeleporter(WorldServer par1WorldServer) {
        super(par1WorldServer);
        this.myWorld = par1WorldServer;
        if (this.rand == null) {
            this.rand = new Random();
        }
    }

    public void placeInPortal(Entity entity, double x, double y, double z, float facing) {
        if (!this.placeInExistingPortal(entity, x, y, z, facing)) {
            int pz;
            int px;
            if (entity.worldObj.getGameRules().getGameRuleBooleanValue("tfEnforcedProgression") && !this.isSafeBiomeAt(px = MathHelper.floor_double((double)entity.posX), pz = MathHelper.floor_double((double)entity.posZ), entity)) {
                System.out.println("[TwilightForest] Portal destination looks unsafe, rerouting!");
                ChunkCoordinates safeCoords = this.findSafeCoords(200, px, pz, entity);
                if (safeCoords != null) {
                    entity.setLocationAndAngles((double)safeCoords.posX, entity.posY, (double)safeCoords.posZ, 90.0f, 0.0f);
                    x = safeCoords.posX;
                    z = safeCoords.posZ;
                    System.out.println("[TwilightForest] Safely rerouted!");
                } else {
                    System.out.println("[TwilightForest] Did not find a safe spot at first try, trying again with longer range.");
                    safeCoords = this.findSafeCoords(400, px, pz, entity);
                    if (safeCoords != null) {
                        entity.setLocationAndAngles((double)safeCoords.posX, entity.posY, (double)safeCoords.posZ, 90.0f, 0.0f);
                        x = safeCoords.posX;
                        z = safeCoords.posZ;
                        System.out.println("[TwilightForest] Safely rerouted to long range portal.  Return trip not guaranteed.");
                    } else {
                        System.out.println("[TwilightForest] Did not find a safe spot.");
                    }
                }
            }
            this.makePortal(entity);
            this.placeInExistingPortal(entity, x, y, z, facing);
        }
    }

    private ChunkCoordinates findSafeCoords(int range, int x, int z, Entity entity) {
        for (int i = 0; i < 25; ++i) {
            int dz;
            int dx = x + (this.rand.nextInt(range) - this.rand.nextInt(range));
            if (!this.isSafeBiomeAt(dx, dz = z + (this.rand.nextInt(range) - this.rand.nextInt(range)), entity)) continue;
            return new ChunkCoordinates(dx, 100, dz);
        }
        return null;
    }

    boolean isSafeBiomeAt(int x, int z, Entity entity) {
        BiomeGenBase biomeAt = this.myWorld.getBiomeGenForCoords(x, z);
        if (biomeAt instanceof TFBiomeBase && entity instanceof EntityPlayerMP) {
            TFBiomeBase tfBiome = (TFBiomeBase)biomeAt;
            EntityPlayerMP player = (EntityPlayerMP)entity;
            return tfBiome.doesPlayerHaveRequiredAchievement((EntityPlayer)player);
        }
        return true;
    }

    public boolean placeInExistingPortal(Entity entity, double par3, double par5, double par7, float par9) {
        int c = 200;
        double d = -1.0;
        int i = 0;
        int j = 0;
        int k = 0;
        int l = MathHelper.floor_double((double)entity.posX);
        int i1 = MathHelper.floor_double((double)entity.posZ);
        for (int j1 = l - c; j1 <= l + c; ++j1) {
            double d1 = (double)j1 + 0.5 - entity.posX;
            for (int j2 = i1 - c; j2 <= i1 + c; ++j2) {
                double d3 = (double)j2 + 0.5 - entity.posZ;
                for (int k2 = TFWorld.MAXHEIGHT - 1; k2 >= 0; --k2) {
                    if (!this.isBlockPortal((World)this.myWorld, j1, k2, j2)) continue;
                    while (this.isBlockPortal((World)this.myWorld, j1, k2 - 1, j2)) {
                        --k2;
                    }
                    double d5 = (double)k2 + 0.5 - entity.posY;
                    double d7 = d1 * d1 + d5 * d5 + d3 * d3;
                    if (!(d < 0.0) && !(d7 < d)) continue;
                    d = d7;
                    i = j1;
                    j = k2;
                    k = j2;
                }
            }
        }
        if (d >= 0.0) {
            int k1 = i;
            int l1 = j;
            int i2 = k;
            double portalX = (double)k1 + 0.5;
            double portalY = (double)l1 + 0.5;
            double portalZ = (double)i2 + 0.5;
            if (this.isBlockPortal((World)this.myWorld, k1 - 1, l1, i2)) {
                portalX -= 0.5;
            }
            if (this.isBlockPortal((World)this.myWorld, k1 + 1, l1, i2)) {
                portalX += 0.5;
            }
            if (this.isBlockPortal((World)this.myWorld, k1, l1, i2 - 1)) {
                portalZ -= 0.5;
            }
            if (this.isBlockPortal((World)this.myWorld, k1, l1, i2 + 1)) {
                portalZ += 0.5;
            }
            int xOffset = 0;
            int zOffset = 0;
            while (xOffset == zOffset && xOffset == 0) {
                xOffset = this.rand.nextInt(3) - this.rand.nextInt(3);
                zOffset = this.rand.nextInt(3) - this.rand.nextInt(3);
            }
            entity.setLocationAndAngles(portalX + (double)xOffset, portalY + 1.0, portalZ + (double)zOffset, entity.rotationYaw, 0.0f);
            entity.motionZ = 0.0;
            entity.motionY = 0.0;
            entity.motionX = 0.0;
            return true;
        }
        return false;
    }

    public boolean isBlockPortal(World world, int x, int y, int z) {
        return world.getBlock(x, y, z) == TFBlocks.portal;
    }

    public boolean makePortal(Entity entity) {
        ChunkCoordinates spot = this.findPortalCoords(entity, true);
        if (spot != null) {
            FMLLog.info((String)"[TwilightForest] Found ideal portal spot", (Object[])new Object[0]);
            this.makePortalAt((World)this.myWorld, spot.posX, spot.posY, spot.posZ);
            return true;
        }
        FMLLog.info((String)"[TwilightForest] Did not find ideal portal spot, shooting for okay one", (Object[])new Object[0]);
        spot = this.findPortalCoords(entity, false);
        if (spot != null) {
            FMLLog.info((String)"[TwilightForest] Found okay portal spot", (Object[])new Object[0]);
            this.makePortalAt((World)this.myWorld, spot.posX, spot.posY, spot.posZ);
            return true;
        }
        FMLLog.info((String)"[TwilightForest] Did not even find an okay portal spot, just making a random one", (Object[])new Object[0]);
        double yFactor = this.myWorld.provider.dimensionId == 0 ? 2.0 : 0.5;
        int entityX = MathHelper.floor_double((double)entity.posX);
        int entityY = MathHelper.floor_double((double)(entity.posY * yFactor));
        int entityZ = MathHelper.floor_double((double)entity.posZ);
        this.makePortalAt((World)this.myWorld, entityX, entityY, entityZ);
        return false;
    }

    public ChunkCoordinates findPortalCoords(Entity entity, boolean ideal) {
        double yFactor = this.myWorld.provider.dimensionId == 0 ? 2.0 : 0.5;
        int entityX = MathHelper.floor_double((double)entity.posX);
        int entityZ = MathHelper.floor_double((double)entity.posZ);
        double spotWeight = -1.0;
        ChunkCoordinates spot = null;
        int range = 16;
        for (int rx = entityX - range; rx <= entityX + range; ++rx) {
            double xWeight = (double)rx + 0.5 - entity.posX;
            for (int rz = entityZ - range; rz <= entityZ + range; ++rz) {
                double zWeight = (double)rz + 0.5 - entity.posZ;
                for (int ry = 127; ry >= 0; --ry) {
                    if (!this.myWorld.isAirBlock(rx, ry, rz)) continue;
                    while (ry > 0 && this.myWorld.isAirBlock(rx, ry - 1, rz)) {
                        --ry;
                    }
                    if (!(ideal ? this.isIdealPortal(rx, rz, ry) : this.isOkayPortal(rx, rz, ry))) continue;
                    double yWeight = (double)ry + 0.5 - entity.posY * yFactor;
                    double rPosWeight = xWeight * xWeight + yWeight * yWeight + zWeight * zWeight;
                    if (!(spotWeight < 0.0) && !(rPosWeight < spotWeight)) continue;
                    spotWeight = rPosWeight;
                    spot = new ChunkCoordinates(rx, ry, rz);
                }
            }
        }
        return spot;
    }

    public boolean isIdealPortal(int rx, int rz, int ry) {
        for (int potentialZ = 0; potentialZ < 4; ++potentialZ) {
            for (int potentialX = 0; potentialX < 4; ++potentialX) {
                for (int potentialY = -1; potentialY < 3; ++potentialY) {
                    int tx = rx + (potentialX - 1);
                    int ty = ry + potentialY;
                    int tz = rz + (potentialZ - 1);
                    if ((potentialY != -1 || this.myWorld.getBlock(tx, ty, tz).getMaterial() == Material.grass) && (potentialY < 0 || this.myWorld.getBlock(tx, ty, tz).getMaterial().isReplaceable())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isOkayPortal(int rx, int rz, int ry) {
        for (int potentialZ = 0; potentialZ < 4; ++potentialZ) {
            for (int potentialX = 0; potentialX < 4; ++potentialX) {
                for (int potentialY = -1; potentialY < 3; ++potentialY) {
                    int tx = rx + (potentialX - 1);
                    int ty = ry + potentialY;
                    int tz = rz + (potentialZ - 1);
                    if ((potentialY != -1 || this.myWorld.getBlock(tx, ty, tz).getMaterial().isSolid()) && (potentialY < 0 || this.myWorld.getBlock(tx, ty, tz).getMaterial().isReplaceable())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void makePortalAt(World world, int px, int py, int pz) {
        if (py < 30) {
            py = 30;
        }
        world.getClass();
        if (py > 118) {
            world.getClass();
            py = 118;
        }
        world.setBlock(px - 1, --py + 0, pz - 1, (Block)Blocks.grass);
        world.setBlock(px + 0, py + 0, pz - 1, (Block)Blocks.grass);
        world.setBlock(px + 1, py + 0, pz - 1, (Block)Blocks.grass);
        world.setBlock(px + 2, py + 0, pz - 1, (Block)Blocks.grass);
        world.setBlock(px - 1, py + 0, pz + 0, (Block)Blocks.grass);
        world.setBlock(px + 2, py + 0, pz + 0, (Block)Blocks.grass);
        world.setBlock(px - 1, py + 0, pz + 1, (Block)Blocks.grass);
        world.setBlock(px + 2, py + 0, pz + 1, (Block)Blocks.grass);
        world.setBlock(px - 1, py + 0, pz + 2, (Block)Blocks.grass);
        world.setBlock(px + 0, py + 0, pz + 2, (Block)Blocks.grass);
        world.setBlock(px + 1, py + 0, pz + 2, (Block)Blocks.grass);
        world.setBlock(px + 2, py + 0, pz + 2, (Block)Blocks.grass);
        world.setBlock(px + 0, py - 1, pz + 0, Blocks.dirt);
        world.setBlock(px + 1, py - 1, pz + 0, Blocks.dirt);
        world.setBlock(px + 0, py - 1, pz + 1, Blocks.dirt);
        world.setBlock(px + 1, py - 1, pz + 1, Blocks.dirt);
        world.setBlock(px + 0, py + 0, pz + 0, TFBlocks.portal, 0, 2);
        world.setBlock(px + 1, py + 0, pz + 0, TFBlocks.portal, 0, 2);
        world.setBlock(px + 0, py + 0, pz + 1, TFBlocks.portal, 0, 2);
        world.setBlock(px + 1, py + 0, pz + 1, TFBlocks.portal, 0, 2);
        for (int dx = -1; dx <= 2; ++dx) {
            for (int dz = -1; dz <= 2; ++dz) {
                for (int dy = 1; dy <= 5; ++dy) {
                    world.setBlock(px + dx, py + dy, pz + dz, Blocks.air);
                }
            }
        }
        world.setBlock(px - 1, py + 1, pz - 1, this.randNatureBlock(world.rand), 0, 2);
        world.setBlock(px + 0, py + 1, pz - 1, this.randNatureBlock(world.rand), 0, 2);
        world.setBlock(px + 1, py + 1, pz - 1, this.randNatureBlock(world.rand), 0, 2);
        world.setBlock(px + 2, py + 1, pz - 1, this.randNatureBlock(world.rand), 0, 2);
        world.setBlock(px - 1, py + 1, pz + 0, this.randNatureBlock(world.rand), 0, 2);
        world.setBlock(px + 2, py + 1, pz + 0, this.randNatureBlock(world.rand), 0, 2);
        world.setBlock(px - 1, py + 1, pz + 1, this.randNatureBlock(world.rand), 0, 2);
        world.setBlock(px + 2, py + 1, pz + 1, this.randNatureBlock(world.rand), 0, 2);
        world.setBlock(px - 1, py + 1, pz + 2, this.randNatureBlock(world.rand), 0, 2);
        world.setBlock(px + 0, py + 1, pz + 2, this.randNatureBlock(world.rand), 0, 2);
        world.setBlock(px + 1, py + 1, pz + 2, this.randNatureBlock(world.rand), 0, 2);
        world.setBlock(px + 2, py + 1, pz + 2, this.randNatureBlock(world.rand), 0, 2);
    }

    public Block randNatureBlock(Random random) {
        Block[] block = new Block[]{Blocks.brown_mushroom, Blocks.red_mushroom, Blocks.tallgrass, Blocks.red_flower, Blocks.yellow_flower};
        return block[random.nextInt(block.length)];
    }
}

