/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import twilightforest.TFFeature;
import twilightforest.world.TFWorldChunkManager;

public class TFMagicMapData
extends MapData {
    private static final int FEATURE_DATA_BYTE = 18;
    public List<MapData.MapCoord> featuresVisibleOnMap = new ArrayList<MapData.MapCoord>();

    public TFMagicMapData(String par1Str) {
        super(par1Str);
    }

    public void readFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readFromNBT(par1NBTTagCompound);
        byte[] featureStorage = par1NBTTagCompound.getByteArray("features");
        if (featureStorage.length > 0) {
            this.updateMPMapData(featureStorage);
        }
    }

    public void writeToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeToNBT(par1NBTTagCompound);
        if (this.featuresVisibleOnMap.size() > 0) {
            byte[] featureStorage = this.makeFeatureStorageArray();
            par1NBTTagCompound.setByteArray("features", featureStorage);
        }
    }

    public void addFeatureToMap(TFFeature feature, int x, int z) {
        byte relativeX = (byte)(x - this.xCenter >> this.scale);
        byte relativeZ = (byte)(z - this.zCenter >> this.scale);
        byte rangeX = 64;
        byte rangeY = 64;
        if (relativeX >= -rangeX && relativeZ >= -rangeY && relativeX <= rangeX && relativeZ <= rangeY) {
            byte markerIcon = (byte)feature.featureID;
            byte mapX = (byte)(relativeX << 1);
            byte mapZ = (byte)(relativeZ << 1);
            byte mapRotation = 8;
            boolean featureFound = false;
            for (MapData.MapCoord existingCoord : this.featuresVisibleOnMap) {
                if (existingCoord.centerX != mapX || existingCoord.centerZ != mapZ) continue;
                featureFound = true;
            }
            if (!featureFound) {
                this.featuresVisibleOnMap.add(new MapData.MapCoord((MapData)this, markerIcon, mapX, mapZ, mapRotation));
            }
        }
    }

    public void checkExistingFeatures(World world) {
        ArrayList<MapData.MapCoord> toRemove = null;
        for (MapData.MapCoord coord : this.featuresVisibleOnMap) {
            int worldX = (coord.centerX << this.scale - 1) + this.xCenter;
            int worldZ = (coord.centerZ << this.scale - 1) + this.zCenter;
            if (world == null || !(world.getWorldChunkManager() instanceof TFWorldChunkManager)) continue;
            TFWorldChunkManager tfManager = (TFWorldChunkManager)world.getWorldChunkManager();
            coord.iconSize = (byte)tfManager.getFeatureID(worldX, worldZ, world);
            if (coord.iconSize != 0) continue;
            if (toRemove == null) {
                toRemove = new ArrayList<MapData.MapCoord>();
            }
            toRemove.add(coord);
        }
        if (toRemove != null) {
            this.featuresVisibleOnMap.removeAll(toRemove);
        }
    }

    public void updateMPMapData(byte[] par1ArrayOfByte) {
        if (par1ArrayOfByte[0] == 18) {
            this.featuresVisibleOnMap.clear();
            for (int i = 0; i < (par1ArrayOfByte.length - 1) / 3; ++i) {
                byte markerIcon = par1ArrayOfByte[i * 3 + 1];
                byte mapX = par1ArrayOfByte[i * 3 + 2];
                byte mapZ = par1ArrayOfByte[i * 3 + 3];
                byte mapRotation = 8;
                this.featuresVisibleOnMap.add(new MapData.MapCoord((MapData)this, markerIcon, mapX, mapZ, mapRotation));
            }
        } else {
            super.updateMPMapData(par1ArrayOfByte);
        }
    }

    public byte[] makeFeatureStorageArray() {
        byte[] storage = new byte[this.featuresVisibleOnMap.size() * 3 + 1];
        storage[0] = 18;
        for (int i = 0; i < this.featuresVisibleOnMap.size(); ++i) {
            MapData.MapCoord featureCoord = this.featuresVisibleOnMap.get(i);
            storage[i * 3 + 1] = featureCoord.iconSize;
            storage[i * 3 + 2] = featureCoord.centerX;
            storage[i * 3 + 3] = featureCoord.centerZ;
        }
        return storage;
    }
}

