/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandGameRule;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import twilightforest.TFAchievementPage;
import twilightforest.TFFeature;
import twilightforest.TFGenericPacketHandler;
import twilightforest.TwilightForestMod;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.block.TFBlocks;
import twilightforest.enchantment.TFEnchantment;
import twilightforest.entity.EntityTFCharmEffect;
import twilightforest.entity.EntityTFPinchBeetle;
import twilightforest.entity.EntityTFYeti;
import twilightforest.item.TFItems;
import twilightforest.world.ChunkProviderTwilightForest;
import twilightforest.world.TFWorldChunkManager;
import twilightforest.world.WorldProviderTwilightForest;

public class TFEventListener {
    protected HashMap<String, InventoryPlayer> playerKeepsMap = new HashMap();
    private boolean isBreakingWithGiantPick = false;
    private boolean shouldMakeGiantCobble = false;
    private int amountOfCobbleToReplace = 0;
    private long lastSpawnedHintMonsterTime;

    @SubscribeEvent
    public void pickupItem(EntityItemPickupEvent event) {
        if (event.entityPlayer.worldObj.provider.dimensionId == TwilightForestMod.dimensionID) {
            Item item = event.item.getEntityItem().getItem();
            if (item == TFItems.scepterTwilight || item == TFItems.scepterLifeDrain || item == TFItems.scepterZombie) {
                this.checkPlayerForScepterMastery(event.entityPlayer);
                event.entityPlayer.triggerAchievement((StatBase)TFAchievementPage.twilightProgressLich);
            } else if (item == TFItems.nagaScale) {
                event.entityPlayer.triggerAchievement((StatBase)TFAchievementPage.twilightProgressNaga);
            } else if (item == TFItems.trophy) {
                switch (event.item.getEntityItem().getItemDamage()) {
                    case 0: {
                        event.entityPlayer.triggerAchievement((StatBase)TFAchievementPage.twilightKillHydra);
                        break;
                    }
                    case 1: {
                        event.entityPlayer.triggerAchievement((StatBase)TFAchievementPage.twilightKillNaga);
                        break;
                    }
                    case 2: {
                        event.entityPlayer.triggerAchievement((StatBase)TFAchievementPage.twilightKillLich);
                        break;
                    }
                    case 3: {
                        event.entityPlayer.triggerAchievement((StatBase)TFAchievementPage.twilightProgressUrghast);
                        break;
                    }
                    case 4: {
                        event.entityPlayer.triggerAchievement((StatBase)TFAchievementPage.twilightProgressGlacier);
                    }
                }
            } else if (item == TFItems.mazebreakerPick) {
                event.entityPlayer.triggerAchievement((StatBase)TFAchievementPage.twilightMazebreaker);
            } else if (item == TFItems.meefStroganoff || item == TFItems.minotaurAxe) {
                event.entityPlayer.triggerAchievement((StatBase)TFAchievementPage.twilightProgressLabyrinth);
            } else if (item == TFItems.fieryBlood) {
                event.entityPlayer.triggerAchievement((StatBase)TFAchievementPage.twilightProgressHydra);
            } else if (item == TFItems.phantomHelm || item == TFItems.phantomPlate) {
                event.entityPlayer.triggerAchievement((StatBase)TFAchievementPage.twilightProgressKnights);
            } else if (item == TFItems.fieryTears) {
                event.entityPlayer.triggerAchievement((StatBase)TFAchievementPage.twilightProgressUrghast);
            } else if (item == TFItems.alphaFur || item == TFItems.yetiBoots || item == TFItems.yetiHelm || item == TFItems.yetiPlate || item == TFItems.yetiLegs) {
                event.entityPlayer.triggerAchievement((StatBase)TFAchievementPage.twilightProgressYeti);
            } else if (item == TFItems.lampOfCinders) {
                event.entityPlayer.triggerAchievement((StatBase)TFAchievementPage.twilightProgressTroll);
            }
        }
    }

    private void checkPlayerForScepterMastery(EntityPlayer player) {
        boolean scepterTwilight = false;
        boolean scepterLifeDrain = false;
        boolean scepterZombie = false;
        InventoryPlayer inv = player.inventory;
        for (int i = 0; i < inv.getSizeInventory(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack == null) continue;
            Item item = stack.getItem();
            if (item == TFItems.scepterTwilight) {
                scepterTwilight = true;
                continue;
            }
            if (item == TFItems.scepterLifeDrain) {
                scepterLifeDrain = true;
                continue;
            }
            if (item != TFItems.scepterZombie) continue;
            scepterZombie = true;
        }
        if (scepterTwilight & scepterLifeDrain & scepterZombie) {
            player.triggerAchievement((StatBase)TFAchievementPage.twilightLichScepters);
        }
    }

    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        ItemStack itemStack = event.crafting;
        EntityPlayer player = event.player;
        Item item = itemStack.getItem();
        if (item == TFItems.plateNaga || item == TFItems.legsNaga) {
            this.checkPlayerForNagaArmorer(player);
        } else if (item == TFItems.magicMapFocus) {
            player.triggerAchievement((StatBase)TFAchievementPage.twilightMagicMapFocus);
        } else if (item == TFItems.emptyMagicMap) {
            player.triggerAchievement((StatBase)TFAchievementPage.twilightMagicMap);
        } else if (item == TFItems.emptyMazeMap) {
            player.triggerAchievement((StatBase)TFAchievementPage.twilightMazeMap);
        } else if (item == TFItems.emptyOreMap) {
            player.triggerAchievement((StatBase)TFAchievementPage.twilightOreMap);
        } else if (item == Item.getItemFromBlock((Block)Blocks.planks) && itemStack.stackSize == 64 && this.doesCraftMatrixHaveGiantLog(event.craftMatrix)) {
            this.addToPlayerInventoryOrDrop(player, new ItemStack(Blocks.planks, 64));
            this.addToPlayerInventoryOrDrop(player, new ItemStack(Blocks.planks, 64));
            this.addToPlayerInventoryOrDrop(player, new ItemStack(Blocks.planks, 64));
        }
    }

    private void addToPlayerInventoryOrDrop(EntityPlayer player, ItemStack itemStack) {
        if (!player.inventory.addItemStackToInventory(itemStack)) {
            player.dropPlayerItemWithRandomChoice(itemStack, false);
        }
    }

    private boolean doesCraftMatrixHaveGiantLog(IInventory inv) {
        for (int i = 0; i < inv.getSizeInventory(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack == null || stack.getItem() != Item.getItemFromBlock((Block)TFBlocks.giantLog)) continue;
            return true;
        }
        return false;
    }

    private void checkPlayerForNagaArmorer(EntityPlayer player) {
        boolean nagaScale = false;
        boolean legsNaga = false;
        InventoryPlayer inv = player.inventory;
        for (int i = 0; i < inv.getSizeInventory(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack == null) continue;
            Item item = stack.getItem();
            if (item == TFItems.nagaScale) {
                nagaScale = true;
                continue;
            }
            if (item != TFItems.legsNaga) continue;
            legsNaga = true;
        }
        if (nagaScale & legsNaga) {
            player.triggerAchievement((StatBase)TFAchievementPage.twilightNagaArmors);
        }
    }

    @SubscribeEvent
    public void harvestDrops(BlockEvent.HarvestDropsEvent event) {
        if (event.harvester != null && event.harvester.inventory.getCurrentItem() != null && event.harvester.inventory.getCurrentItem().getItem().func_150897_b(event.block) && event.harvester.inventory.getCurrentItem().getItem() == TFItems.fieryPick) {
            ArrayList<ItemStack> removeThese = new ArrayList<ItemStack>(1);
            ArrayList<ItemStack> addThese = new ArrayList<ItemStack>(1);
            for (ItemStack input : event.drops) {
                ItemStack result = FurnaceRecipes.smelting().getSmeltingResult(input);
                if (result == null) continue;
                addThese.add(new ItemStack(result.getItem(), input.stackSize));
                removeThese.add(input);
                this.spawnSpeltXP(result, event.world, event.x, event.y, event.z);
            }
            event.drops.removeAll(removeThese);
            event.drops.addAll(addThese);
        }
        if (this.shouldMakeGiantCobble && event.drops.size() > 0 && ((ItemStack)event.drops.get(0)).getItem() == Item.getItemFromBlock((Block)Blocks.cobblestone)) {
            event.drops.remove(0);
            if (this.amountOfCobbleToReplace == 64) {
                event.drops.add(new ItemStack(TFBlocks.giantCobble));
            }
            --this.amountOfCobbleToReplace;
            if (this.amountOfCobbleToReplace <= 0) {
                this.shouldMakeGiantCobble = false;
            }
        }
    }

    private void spawnSpeltXP(ItemStack smelted, World world, int x, int y, int z) {
        int smeltXP;
        float floatXP = FurnaceRecipes.smelting().func_151398_b(smelted);
        if (floatXP > (float)(smeltXP = (int)floatXP) && world.rand.nextFloat() < floatXP - (float)smeltXP) {
            ++smeltXP;
        }
        while (smeltXP > 0) {
            int splitXP = EntityXPOrb.getXPSplit((int)smeltXP);
            smeltXP -= splitXP;
            world.spawnEntityInWorld((Entity)new EntityXPOrb(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, splitXP));
        }
    }

    @SubscribeEvent
    public void entityHurts(LivingHurtEvent event) {
        EntityPlayer player;
        boolean damageSourceIsNotNull;
        boolean entityIsPlayer = event.entityLiving instanceof EntityPlayer;
        boolean damageSourceIsMob = event.source.damageType.equals("mob");
        boolean damageSourceIsArrow = event.source.damageType.equals("arrow");
        boolean damageSourceIsPlayer = event.source.getEntity() instanceof EntityPlayer;
        boolean bl = damageSourceIsNotNull = event.source.getEntity() != null;
        if (damageSourceIsNotNull) {
            ItemStack playerHeldItemStack;
            if (entityIsPlayer && damageSourceIsMob) {
                int chillLevel;
                player = (EntityPlayer)event.entityLiving;
                int fireLevel = TFEnchantment.getFieryAuraLevel(player.inventory, event.source);
                if (fireLevel > 0 && player.getRNG().nextInt(25) < fireLevel) {
                    event.source.getEntity().setFire(fireLevel / 2);
                }
                if (event.source.getEntity() instanceof EntityLivingBase && (chillLevel = TFEnchantment.getChillAuraLevel(player.inventory, event.source)) > 0) {
                    ((EntityLivingBase)event.source.getEntity()).addPotionEffect(new PotionEffect(Potion.moveSlowdown.id, chillLevel * 5 + 5, chillLevel));
                }
            }
            if (damageSourceIsArrow && damageSourceIsPlayer && (playerHeldItemStack = (player = (EntityPlayer)event.source.getEntity()).getCurrentEquippedItem()) != null) {
                Item playerHeldItem = playerHeldItemStack.getItem();
                if (playerHeldItem == TFItems.tripleBow) {
                    event.entityLiving.hurtResistantTime = 0;
                } else if (playerHeldItem == TFItems.iceBow) {
                    event.entityLiving.addPotionEffect(new PotionEffect(Potion.moveSlowdown.id, 200, 2, true));
                } else if (playerHeldItem == TFItems.enderBow) {
                    double sourceX = player.posX;
                    double sourceY = player.posY;
                    double sourceZ = player.posZ;
                    float sourceYaw = player.rotationYaw;
                    float sourcePitch = player.rotationPitch;
                    player.rotationYaw = event.entityLiving.rotationYaw;
                    player.rotationPitch = event.entityLiving.rotationPitch;
                    player.setPositionAndUpdate(event.entityLiving.posX, event.entityLiving.posY, event.entityLiving.posZ);
                    player.playSound("mob.endermen.portal", 1.0f, 1.0f);
                    event.entityLiving.setPositionAndRotation(sourceX, sourceY, sourceZ, sourceYaw, sourcePitch);
                    event.entityLiving.playSound("mob.endermen.portal", 1.0f, 1.0f);
                }
            }
        }
        if (entityIsPlayer && this.willEntityDie(event)) {
            player = (EntityPlayer)event.entityLiving;
            boolean charm1 = false;
            boolean charm2 = player.inventory.consumeInventoryItem(TFItems.charmOfLife2);
            if (!charm2) {
                charm1 = player.inventory.consumeInventoryItem(TFItems.charmOfLife1);
            }
            if (charm2 || charm1) {
                event.setResult(Event.Result.DENY);
                event.setCanceled(true);
                event.ammount = 0.0f;
                if (charm1) {
                    player.setHealth(8.0f);
                    player.addPotionEffect(new PotionEffect(Potion.regeneration.id, 100, 0));
                } else if (charm2) {
                    player.setHealth((float)player.getEntityAttribute(SharedMonsterAttributes.maxHealth).getBaseValue());
                    player.addPotionEffect(new PotionEffect(Potion.regeneration.id, 600, 3));
                    player.addPotionEffect(new PotionEffect(Potion.resistance.id, 600, 0));
                    player.addPotionEffect(new PotionEffect(Potion.fireResistance.id, 600, 0));
                }
                EntityTFCharmEffect effect = new EntityTFCharmEffect(player.worldObj, (EntityLivingBase)player, charm1 ? TFItems.charmOfLife1 : TFItems.charmOfLife2);
                player.worldObj.spawnEntityInWorld((Entity)effect);
                EntityTFCharmEffect effect2 = new EntityTFCharmEffect(player.worldObj, (EntityLivingBase)player, charm1 ? TFItems.charmOfLife1 : TFItems.charmOfLife2);
                effect2.offset = (float)Math.PI;
                player.worldObj.spawnEntityInWorld((Entity)effect2);
                player.worldObj.playSoundEffect(player.posX + 0.5, player.posY + 0.5, player.posZ + 0.5, "mob.zombie.unfect", 1.5f, 1.0f);
            }
        }
    }

    public boolean willEntityDie(LivingHurtEvent event) {
        float amount = event.ammount;
        DamageSource source = event.source;
        EntityLivingBase living = event.entityLiving;
        if (!source.isUnblockable()) {
            int armor = 25 - living.getTotalArmorValue();
            amount = amount * (float)armor / 25.0f;
        }
        if (living.isPotionActive(Potion.resistance)) {
            int resistance = 25 - (living.getActivePotionEffect(Potion.resistance).getAmplifier() + 1) * 5;
            amount = amount * (float)resistance / 25.0f;
        }
        return Math.ceil(amount) >= Math.floor(living.getHealth());
    }

    @SubscribeEvent
    public void bonemealUsed(BonemealEvent event) {
        if (event.block == TFBlocks.sapling && !event.world.isRemote) {
            ((BlockSapling)TFBlocks.sapling).func_149878_d(event.world, event.x, event.y, event.z, event.world.rand);
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void livingDies(LivingDeathEvent event) {
        if (event.entityLiving instanceof EntityPlayer && !event.entityLiving.worldObj.getGameRules().getGameRuleBooleanValue("keepInventory")) {
            int i;
            InventoryPlayer keepInventory;
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            if (player.inventory.consumeInventoryItem(TFItems.charmOfKeeping3)) {
                FMLLog.info((String)"[TwilightForest] Player died with charm of keeping III!  Keep it all!", (Object[])new Object[0]);
                keepInventory = new InventoryPlayer(null);
                this.keepAllArmor(player, keepInventory);
                for (i = 0; i < player.inventory.mainInventory.length; ++i) {
                    keepInventory.mainInventory[i] = ItemStack.copyItemStack((ItemStack)player.inventory.mainInventory[i]);
                    player.inventory.mainInventory[i] = null;
                }
                keepInventory.setItemStack(new ItemStack(TFItems.charmOfKeeping3));
                this.playerKeepsMap.put(player.getCommandSenderName(), keepInventory);
            } else if (player.inventory.consumeInventoryItem(TFItems.charmOfKeeping2)) {
                FMLLog.info((String)"[TwilightForest] Player died with charm of keeping II!  Keep armor and hotbar!", (Object[])new Object[0]);
                keepInventory = new InventoryPlayer(null);
                this.keepAllArmor(player, keepInventory);
                for (i = 0; i < 9; ++i) {
                    keepInventory.mainInventory[i] = ItemStack.copyItemStack((ItemStack)player.inventory.mainInventory[i]);
                    player.inventory.mainInventory[i] = null;
                }
                keepInventory.setItemStack(new ItemStack(TFItems.charmOfKeeping2));
                this.playerKeepsMap.put(player.getCommandSenderName(), keepInventory);
            } else if (player.inventory.consumeInventoryItem(TFItems.charmOfKeeping1)) {
                int currentItem;
                FMLLog.info((String)"[TwilightForest] Player died with charm of keeping I!  Keep armor and current item!", (Object[])new Object[0]);
                keepInventory = new InventoryPlayer(null);
                this.keepAllArmor(player, keepInventory);
                if (player.inventory.getCurrentItem() != null && (currentItem = player.inventory.currentItem) <= 8 & currentItem >= 0) {
                    keepInventory.mainInventory[currentItem] = ItemStack.copyItemStack((ItemStack)player.inventory.mainInventory[currentItem]);
                    player.inventory.mainInventory[currentItem] = null;
                }
                keepInventory.setItemStack(new ItemStack(TFItems.charmOfKeeping1));
                this.playerKeepsMap.put(player.getCommandSenderName(), keepInventory);
            }
            if (player.inventory.hasItem(TFItems.towerKey)) {
                keepInventory = this.retrieveOrMakeKeepInventory(player);
                for (i = 0; i < player.inventory.mainInventory.length; ++i) {
                    if (player.inventory.mainInventory[i] == null || player.inventory.mainInventory[i].getItem() != TFItems.towerKey) continue;
                    keepInventory.mainInventory[i] = ItemStack.copyItemStack((ItemStack)player.inventory.mainInventory[i]);
                    player.inventory.mainInventory[i] = null;
                }
                this.playerKeepsMap.put(player.getCommandSenderName(), keepInventory);
            }
        }
        if (this.playerKeepsMap.size() > 1) {
            FMLLog.warning((String)"[TwilightForest] Twilight Forest mod is keeping track of a lot of dead player inventories.  Has there been an apocalypse?", (Object[])new Object[0]);
        }
    }

    private InventoryPlayer retrieveOrMakeKeepInventory(EntityPlayer player) {
        if (this.playerKeepsMap.containsKey(player.getCommandSenderName())) {
            return this.playerKeepsMap.get(player.getCommandSenderName());
        }
        return new InventoryPlayer(null);
    }

    private void keepAllArmor(EntityPlayer player, InventoryPlayer keepInventory) {
        for (int i = 0; i < player.inventory.armorInventory.length; ++i) {
            keepInventory.armorInventory[i] = ItemStack.copyItemStack((ItemStack)player.inventory.armorInventory[i]);
            player.inventory.armorInventory[i] = null;
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        EntityPlayer player = event.player;
        if (this.playerKeepsMap.containsKey(player.getCommandSenderName())) {
            int i;
            FMLLog.info((String)"[TwilightForest] Player %s respawned and recieved items held in storage", (Object[])new Object[]{player.getCommandSenderName()});
            InventoryPlayer keepInventory = this.playerKeepsMap.get(player.getCommandSenderName());
            for (i = 0; i < player.inventory.armorInventory.length; ++i) {
                if (keepInventory.armorInventory[i] == null) continue;
                player.inventory.armorInventory[i] = keepInventory.armorInventory[i];
            }
            for (i = 0; i < player.inventory.mainInventory.length; ++i) {
                if (keepInventory.mainInventory[i] == null) continue;
                player.inventory.mainInventory[i] = keepInventory.mainInventory[i];
            }
            if (keepInventory.getItemStack() != null) {
                EntityTFCharmEffect effect = new EntityTFCharmEffect(player.worldObj, (EntityLivingBase)player, keepInventory.getItemStack().getItem());
                player.worldObj.spawnEntityInWorld((Entity)effect);
                EntityTFCharmEffect effect2 = new EntityTFCharmEffect(player.worldObj, (EntityLivingBase)player, keepInventory.getItemStack().getItem());
                effect2.offset = (float)Math.PI;
                player.worldObj.spawnEntityInWorld((Entity)effect2);
                player.worldObj.playSoundEffect(player.posX + 0.5, player.posY + 0.5, player.posZ + 0.5, "mob.zombie.unfect", 1.5f, 1.0f);
            }
            this.playerKeepsMap.remove(player.getCommandSenderName());
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        EntityPlayer player = event.player;
        if (this.playerKeepsMap.containsKey(player.getCommandSenderName())) {
            FMLLog.warning((String)"[TwilightForest] Mod was keeping inventory items in reserve for player %s but they logged out!  Items are being dropped.", (Object[])new Object[]{player.getCommandSenderName()});
            InventoryPlayer keepInventory = this.playerKeepsMap.get(player.getCommandSenderName());
            keepInventory.player = player;
            keepInventory.dropAllItems();
            this.playerKeepsMap.remove(player.getCommandSenderName());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public boolean preOverlay(RenderGameOverlayEvent.Pre event) {
        if (event.type == RenderGameOverlayEvent.ElementType.HEALTHMOUNT && this.isRidingUnfriendly((EntityLivingBase)Minecraft.getMinecraft().thePlayer)) {
            event.setCanceled(true);
            return false;
        }
        return true;
    }

    @SubscribeEvent
    public boolean livingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.entity instanceof EntityPlayer && event.entity.isSneaking() && this.isRidingUnfriendly(event.entityLiving)) {
            event.entity.setSneaking(false);
        }
        return true;
    }

    private boolean isRidingUnfriendly(EntityLivingBase entity) {
        return entity.isRiding() && (entity.ridingEntity instanceof EntityTFPinchBeetle || entity.ridingEntity instanceof EntityTFYeti);
    }

    @SubscribeEvent
    public void breakBlock(BlockEvent.BreakEvent event) {
        if (!event.getPlayer().capabilities.isCreativeMode && this.isAreaProtected(event.world, event.getPlayer(), event.x, event.y, event.z) && this.isBlockProtectedFromBreaking(event.world, event.x, event.y, event.z)) {
            event.setCanceled(true);
        } else if (!this.isBreakingWithGiantPick && event.getPlayer().getCurrentEquippedItem() != null && event.getPlayer().getCurrentEquippedItem().getItem() == TFItems.giantPick && event.getPlayer().getCurrentEquippedItem().getItem().func_150897_b(event.block)) {
            int metaThere;
            Block blockThere;
            int dz;
            int dy;
            int dx;
            this.isBreakingWithGiantPick = true;
            int bx = event.x >> 2 << 2;
            int by = event.y >> 2 << 2;
            int bz = event.z >> 2 << 2;
            boolean allCobble = event.block.getItemDropped(event.blockMetadata, event.world.rand, 0) == Item.getItemFromBlock((Block)Blocks.cobblestone);
            for (dx = 0; dx < 4; ++dx) {
                for (dy = 0; dy < 4; ++dy) {
                    for (dz = 0; dz < 4; ++dz) {
                        blockThere = event.world.getBlock(bx + dx, by + dy, bz + dz);
                        allCobble &= blockThere.getItemDropped(metaThere = event.world.getBlockMetadata(bx + dx, by + dy, bz + dz), event.world.rand, 0) == Item.getItemFromBlock((Block)Blocks.cobblestone);
                    }
                }
            }
            if (allCobble && !event.getPlayer().capabilities.isCreativeMode) {
                this.shouldMakeGiantCobble = true;
                this.amountOfCobbleToReplace = 64;
            } else {
                this.shouldMakeGiantCobble = false;
                this.amountOfCobbleToReplace = 0;
            }
            for (dx = 0; dx < 4; ++dx) {
                for (dy = 0; dy < 4; ++dy) {
                    for (dz = 0; dz < 4; ++dz) {
                        blockThere = event.world.getBlock(bx + dx, by + dy, bz + dz);
                        metaThere = event.world.getBlockMetadata(bx + dx, by + dy, bz + dz);
                        if (event.x == bx + dx && event.y == by + dy && event.z == bz + dz || blockThere != event.block || metaThere != event.blockMetadata || !(event.getPlayer() instanceof EntityPlayerMP)) continue;
                        EntityPlayerMP playerMP = (EntityPlayerMP)event.getPlayer();
                        playerMP.theItemInWorldManager.tryHarvestBlock(bx + dx, by + dy, bz + dz);
                    }
                }
            }
            this.isBreakingWithGiantPick = false;
        }
    }

    @SubscribeEvent
    public void rightClickBlock(PlayerInteractEvent event) {
        ItemStack currentItem;
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && event.entityPlayer.worldObj.provider instanceof WorldProviderTwilightForest && !event.entityPlayer.capabilities.isCreativeMode) {
            World world = event.entityPlayer.worldObj;
            EntityPlayer player = event.entityPlayer;
            int x = event.x;
            int y = event.y;
            int z = event.z;
            if (!world.isRemote && this.isBlockProtectedFromInteraction(world, x, y, z) && this.isAreaProtected(world, player, x, y, z)) {
                event.useBlock = Event.Result.DENY;
            }
        }
        if ((currentItem = event.entityPlayer.inventory.getCurrentItem()) != null && (currentItem.getItem() == TFItems.fierySword || currentItem.getItem() == TFItems.fieryPick) && this.checkPlayerForFieryArmor(event.entityPlayer)) {
            event.entityPlayer.triggerAchievement((StatBase)TFAchievementPage.twilightFierySet);
        }
    }

    private boolean isBlockProtectedFromInteraction(World world, int x, int y, int z) {
        Block block = world.getBlock(x, y, z);
        return block == TFBlocks.towerDevice || block == Blocks.chest || block == Blocks.trapped_chest || block == Blocks.stone_button || block == Blocks.wooden_button || block == Blocks.lever;
    }

    private boolean isBlockProtectedFromBreaking(World world, int x, int y, int z) {
        Block block = world.getBlock(x, y, z);
        return !block.getUnlocalizedName().equals("tile.openblocks.grave");
    }

    private boolean checkPlayerForFieryArmor(EntityPlayer entityPlayer) {
        ItemStack[] armor = entityPlayer.inventory.armorInventory;
        if (armor[0] != null && armor[0].getItem() == TFItems.fieryBoots) {
            return true;
        }
        if (armor[1] != null && armor[1].getItem() == TFItems.fieryLegs) {
            return true;
        }
        if (armor[2] != null && armor[2].getItem() == TFItems.fieryPlate) {
            return true;
        }
        return armor[3] != null && armor[3].getItem() == TFItems.fieryHelm;
    }

    private boolean isAreaProtected(World world, EntityPlayer player, int x, int y, int z) {
        TFFeature nearbyFeature;
        ChunkProviderTwilightForest chunkProvider;
        if (world.getGameRules().getGameRuleBooleanValue("tfEnforcedProgression") && world.provider instanceof WorldProviderTwilightForest && (chunkProvider = ((WorldProviderTwilightForest)world.provider).getChunkProvider()) != null && chunkProvider.isBlockInStructureBB(x, y, z) && !(nearbyFeature = ((TFWorldChunkManager)world.provider.worldChunkMgr).getFeatureAt(x, z, world)).doesPlayerHaveRequiredAchievement(player) && chunkProvider.isBlockProtected(x, y, z)) {
            StructureBoundingBox sbb = chunkProvider.getSBBAt(x, y, z);
            this.sendAreaProtectionPacket(world, x, y, z, sbb);
            nearbyFeature.trySpawnHintMonster(world, player, x, y, z);
            return true;
        }
        return false;
    }

    private void sendAreaProtectionPacket(World world, int x, int y, int z, StructureBoundingBox sbb) {
        FMLProxyPacket message = TFGenericPacketHandler.makeAreaProtectionPacket(sbb, x, y, z);
        NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(world.provider.dimensionId, (double)x, (double)y, (double)z, 64.0);
        TwilightForestMod.genericChannel.sendToAllAround(message, targetPoint);
    }

    @SubscribeEvent
    public void livingAttack(LivingAttackEvent event) {
        if (event.entityLiving instanceof IMob && event.source.getEntity() instanceof EntityPlayer && !((EntityPlayer)event.source.getEntity()).capabilities.isCreativeMode && event.entityLiving.worldObj.provider instanceof WorldProviderTwilightForest && event.entityLiving.worldObj.getGameRules().getGameRuleBooleanValue("tfEnforcedProgression")) {
            TFFeature nearbyFeature;
            ChunkProviderTwilightForest chunkProvider = ((WorldProviderTwilightForest)event.entityLiving.worldObj.provider).getChunkProvider();
            int mx = MathHelper.floor_double((double)event.entityLiving.posX);
            int my = MathHelper.floor_double((double)event.entityLiving.posY);
            int mz = MathHelper.floor_double((double)event.entityLiving.posZ);
            if (chunkProvider != null && chunkProvider.isBlockInStructureBB(mx, my, mz) && chunkProvider.isBlockProtected(mx, my, mz) && !(nearbyFeature = ((TFWorldChunkManager)event.entityLiving.worldObj.provider.worldChunkMgr).getFeatureAt(mx, mz, event.entityLiving.worldObj)).doesPlayerHaveRequiredAchievement((EntityPlayer)event.source.getEntity())) {
                event.setResult(Event.Result.DENY);
                event.setCanceled(true);
                for (int i = 0; i < 20; ++i) {
                    TwilightForestMod.proxy.spawnParticle(event.entityLiving.worldObj, "protection", event.entityLiving.posX, event.entityLiving.posY, event.entityLiving.posZ, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @SubscribeEvent
    public void playerLogsIn(PlayerEvent.PlayerLoggedInEvent event) {
        TwilightForestMod.hasBiomeIdConflicts = TFBiomeBase.areThereBiomeIdConflicts();
        if (TwilightForestMod.hasBiomeIdConflicts) {
            event.player.addChatMessage((IChatComponent)new ChatComponentText("[TwilightForest] Biome ID conflict detected.  Fix by editing the config file."));
        }
        if (!event.player.worldObj.isRemote && event.player instanceof EntityPlayerMP) {
            this.sendEnforcedProgressionStatus((EntityPlayerMP)event.player, event.player.worldObj.getGameRules().getGameRuleBooleanValue("tfEnforcedProgression"));
        }
    }

    @SubscribeEvent
    public void playerPortals(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!event.player.worldObj.isRemote && event.player instanceof EntityPlayerMP && event.toDim == TwilightForestMod.dimensionID) {
            this.sendEnforcedProgressionStatus((EntityPlayerMP)event.player, event.player.worldObj.getGameRules().getGameRuleBooleanValue("tfEnforcedProgression"));
        }
    }

    private void sendEnforcedProgressionStatus(EntityPlayerMP player, boolean isEnforced) {
        TwilightForestMod.genericChannel.sendTo(TFGenericPacketHandler.makeEnforcedProgressionStatusPacket(isEnforced), player);
    }

    @SubscribeEvent
    public void worldLoaded(WorldEvent.Load event) {
        if (!event.world.isRemote && !event.world.getGameRules().hasRule("tfEnforcedProgression")) {
            FMLLog.info((String)"[TwilightForest] Loaded a world with the tfEnforcedProgression game rule not defined.  Defining it.", (Object[])new Object[0]);
            event.world.getGameRules().addGameRule("tfEnforcedProgression", "true");
        }
    }

    @SubscribeEvent
    public void commandSent(CommandEvent event) {
        if (event.command instanceof CommandGameRule && event.parameters.length > 1 && "tfEnforcedProgression".equals(event.parameters[0])) {
            boolean isEnforced = Boolean.valueOf(event.parameters[1]);
            TwilightForestMod.genericChannel.sendToAll(TFGenericPacketHandler.makeEnforcedProgressionStatusPacket(isEnforced));
        }
    }
}

