/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import twilightforest.TFAchievementPage;

public class CommandTFProgress
extends CommandBase {
    String[] bosses = new String[]{"none", "naga", "lich", "mooshroom", "hydra", "knights", "urghast", "yeti", "snowqueen", "giants", "final"};

    public String getCommandName() {
        return "tfprogress";
    }

    public String getCommandUsage(ICommandSender sender) {
        return "tfprogress <player> <boss>";
    }

    public int getRequiredPermissionLevel() {
        return 2;
    }

    public void processCommand(ICommandSender sender, String[] args) {
        if (args.length < 2) {
            throw new WrongUsageException("tfprogress <player> <boss>", new Object[0]);
        }
        EntityPlayerMP player = CommandTFProgress.getPlayer((ICommandSender)sender, (String)args[0]);
        int bossIndex = this.getBossIndex(args[1]);
        CommandTFProgress.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"Setting player %s progress to past boss %s.", (Object[])new Object[]{player.getCommandSenderName(), this.bosses[bossIndex]});
        this.setProgress(player, bossIndex);
    }

    private void setProgress(EntityPlayerMP player, int bossIndex) {
        if (bossIndex > 0) {
            for (int i = 0; i < bossIndex; ++i) {
                this.setProgress(player, i);
            }
        }
        switch (bossIndex) {
            default: {
                break;
            }
            case 1: {
                player.triggerAchievement((StatBase)TFAchievementPage.twilightPortal);
                player.triggerAchievement((StatBase)TFAchievementPage.twilightArrival);
                player.triggerAchievement((StatBase)TFAchievementPage.twilightHunter);
                player.triggerAchievement((StatBase)TFAchievementPage.twilightKillNaga);
                player.triggerAchievement((StatBase)TFAchievementPage.twilightProgressNaga);
                break;
            }
            case 2: {
                player.triggerAchievement((StatBase)TFAchievementPage.twilightKillLich);
                player.triggerAchievement((StatBase)TFAchievementPage.twilightProgressLich);
                break;
            }
            case 3: {
                player.triggerAchievement((StatBase)TFAchievementPage.twilightProgressLabyrinth);
                break;
            }
            case 4: {
                player.triggerAchievement((StatBase)TFAchievementPage.twilightKillHydra);
                player.triggerAchievement((StatBase)TFAchievementPage.twilightProgressHydra);
                break;
            }
            case 5: {
                player.triggerAchievement((StatBase)TFAchievementPage.twilightProgressTrophyPedestal);
                player.triggerAchievement((StatBase)TFAchievementPage.twilightProgressKnights);
                break;
            }
            case 6: {
                player.triggerAchievement((StatBase)TFAchievementPage.twilightProgressUrghast);
                break;
            }
            case 7: {
                player.triggerAchievement((StatBase)TFAchievementPage.twilightProgressYeti);
                break;
            }
            case 8: {
                player.triggerAchievement((StatBase)TFAchievementPage.twilightProgressGlacier);
                break;
            }
            case 9: {
                player.triggerAchievement((StatBase)TFAchievementPage.twilightProgressTroll);
                break;
            }
            case 10: {
                player.triggerAchievement((StatBase)TFAchievementPage.twilightProgressThorns);
                player.triggerAchievement((StatBase)TFAchievementPage.twilightProgressCastle);
            }
        }
    }

    private int getBossIndex(String string) {
        for (int i = 0; i < this.bosses.length; ++i) {
            if (!this.bosses[i].equalsIgnoreCase(string)) continue;
            return i;
        }
        return 0;
    }

    public List addTabCompletionOptions(ICommandSender sender, String[] args) {
        return args.length == 1 ? CommandTFProgress.getListOfStringsMatchingLastWord((String[])args, (String[])this.getListOfPlayers()) : (args.length == 2 ? CommandTFProgress.getListOfStringsMatchingLastWord((String[])args, (String[])this.bosses) : null);
    }

    protected String[] getListOfPlayers() {
        return MinecraftServer.getServer().getAllUsernames();
    }

    public boolean isUsernameIndex(String[] p_82358_1_, int p_82358_2_) {
        return p_82358_2_ == 0;
    }
}

