/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import twilightforest.TFFeature;
import twilightforest.world.ChunkProviderTwilightForest;
import twilightforest.world.TFWorldChunkManager;
import twilightforest.world.WorldProviderTwilightForest;

public class CommandTFFeature
extends CommandBase {
    public String getCommandName() {
        return "tffeature";
    }

    public String getCommandUsage(ICommandSender sender) {
        return "tffeature accepts the following arguments: info";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processCommand(ICommandSender sender, String[] args) {
        if (args.length <= 0) throw new WrongUsageException("commands.tffeature.usage", new Object[0]);
        if (args[0].equalsIgnoreCase("info")) {
            EntityPlayerMP player = CommandTFFeature.getCommandSenderAsPlayer((ICommandSender)sender);
            int dx = MathHelper.floor_double((double)player.posX);
            int dy = MathHelper.floor_double((double)player.posY);
            int dz = MathHelper.floor_double((double)player.posZ);
            if (!(player.worldObj.provider instanceof WorldProviderTwilightForest)) {
                throw new WrongUsageException("commands.tffeature.not_in_twilight_forest", new Object[0]);
            }
            TFFeature nearbyFeature = ((TFWorldChunkManager)player.worldObj.provider.worldChunkMgr).getFeatureAt(dx, dz, player.worldObj);
            sender.addChatMessage((IChatComponent)new ChatComponentTranslation("The nearest feature is %s", new Object[]{nearbyFeature.name}));
            ChunkProviderTwilightForest chunkProvider = ((WorldProviderTwilightForest)player.worldObj.provider).getChunkProvider();
            if (chunkProvider.isBlockInStructureBB(dx, dy, dz)) {
                sender.addChatMessage((IChatComponent)new ChatComponentTranslation("You are in the structure for that feature.", new Object[0]));
                sender.addChatMessage((IChatComponent)new ChatComponentTranslation("Structure conquer flag = %s.", new Object[]{chunkProvider.isStructureConquered(dx, dy, dz)}));
                return;
            } else {
                sender.addChatMessage((IChatComponent)new ChatComponentTranslation("You are not in the structure for that feature.", new Object[0]));
            }
            return;
        } else if (args[0].equalsIgnoreCase("reactivate")) {
            this.changeStructureActivity(sender, false);
            return;
        } else if (args[0].equalsIgnoreCase("conquer")) {
            this.changeStructureActivity(sender, true);
            return;
        } else {
            if (!args[0].equalsIgnoreCase("center")) throw new WrongUsageException("commands.tffeature.usage", new Object[0]);
            EntityPlayerMP player = CommandTFFeature.getCommandSenderAsPlayer((ICommandSender)sender);
            int dx = MathHelper.floor_double((double)player.posX);
            int dz = MathHelper.floor_double((double)player.posZ);
            ChunkCoordinates cc = TFFeature.getNearestCenterXYZ(dx >> 4, dz >> 4, player.worldObj);
            TFWorldChunkManager wcm = (TFWorldChunkManager)player.worldObj.provider.worldChunkMgr;
            boolean fc = wcm.isInFeatureChunk(player.worldObj, dx, dz);
            sender.addChatMessage((IChatComponent)new ChatComponentTranslation("Center of feature = %s.", new Object[]{cc}));
            sender.addChatMessage((IChatComponent)new ChatComponentTranslation("Are in feature chunk = %s.", new Object[]{fc}));
        }
    }

    private void changeStructureActivity(ICommandSender sender, boolean flag) throws WrongUsageException {
        EntityPlayerMP player = CommandTFFeature.getCommandSenderAsPlayer((ICommandSender)sender);
        int dx = MathHelper.floor_double((double)player.posX);
        int dy = MathHelper.floor_double((double)player.posY);
        int dz = MathHelper.floor_double((double)player.posZ);
        if (!(player.worldObj.provider instanceof WorldProviderTwilightForest)) {
            throw new WrongUsageException("commands.tffeature.not_in_twilight_forest", new Object[0]);
        }
        ChunkProviderTwilightForest chunkProvider = ((WorldProviderTwilightForest)player.worldObj.provider).getChunkProvider();
        if (chunkProvider.isBlockInStructureBB(dx, dy, dz)) {
            sender.addChatMessage((IChatComponent)new ChatComponentTranslation("Structure conquer flag was %s.  Changing to %s.", new Object[]{chunkProvider.isStructureConquered(dx, dy, dz), flag}));
            chunkProvider.setStructureConquered(dx, dy, dz, flag);
        } else {
            sender.addChatMessage((IChatComponent)new ChatComponentTranslation("You are not in a structure.", new Object[0]));
        }
    }
}

