/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.world.itemblocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mantle.blocks.abstracts.MultiItemBlock;
import mantle.world.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import tconstruct.world.TinkerWorld;

public class OreberryBushSecondItem
extends MultiItemBlock {
    public Block blockB;
    public static final String[] blockTypes = new String[]{"aluminum", "essence", "", "", "aluminum", "essence", "", "", "aluminum", "essence", "", "", "aluminum", "essence", "", ""};

    public OreberryBushSecondItem(Block b) {
        super(b, "block.oreberry", blockTypes);
        this.blockB = b;
        this.setHasSubtypes(true);
    }

    public int getMetadata(int meta) {
        return meta % 4;
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (side != 1) {
            return false;
        }
        int meta = stack.getItemDamage();
        if (meta % 4 != 1 && world.getFullBlockLightValue(x, y + 1, z) >= 13) {
            return false;
        }
        if (player.canPlayerEdit(x, y, z, side, stack) && player.canPlayerEdit(x, y + 1, z, side, stack)) {
            Block block = world.getBlock(x, y, z);
            if (block != null && block.canSustainPlant((IBlockAccess)world, x, y, z, ForgeDirection.UP, (IPlantable)TinkerWorld.oreBerrySecond) && WorldHelper.isAirBlock((World)world, (int)x, (int)(y + 1), (int)z)) {
                world.setBlock(x, y + 1, z, this.blockB, stack.getItemDamage() % 4, 3);
                if (!player.capabilities.isCreativeMode) {
                    --stack.stackSize;
                }
                if (!world.isRemote) {
                    world.playAuxSFX(2001, x, y, z, Block.getIdFromBlock((Block)block));
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        switch (stack.getItemDamage() % 4) {
            case 0: {
                list.add(StatCollector.translateToLocal((String)"oreberrybush5.tooltip"));
                break;
            }
            case 1: {
                list.add(StatCollector.translateToLocal((String)"oreberrybush6.tooltip"));
            }
        }
    }
}

