/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.world.gen;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import tconstruct.util.config.PHConstruct;
import tconstruct.world.TinkerWorld;
import tconstruct.world.gen.OreberryBushGen;

public class TBaseWorldGenerator
implements IWorldGenerator {
    WorldGenMinable copper = new WorldGenMinable(TinkerWorld.oreSlag, 3, 8, Blocks.stone);
    WorldGenMinable tin = new WorldGenMinable(TinkerWorld.oreSlag, 4, 8, Blocks.stone);
    WorldGenMinable aluminum = new WorldGenMinable(TinkerWorld.oreSlag, 5, 6, Blocks.stone);
    WorldGenMinable cobalt = new WorldGenMinable(TinkerWorld.oreSlag, 1, 3, Blocks.netherrack);
    WorldGenMinable ardite = new WorldGenMinable(TinkerWorld.oreSlag, 2, 3, Blocks.netherrack);
    OreberryBushGen ironBush = new OreberryBushGen((Block)TinkerWorld.oreBerry, 12, 12);
    OreberryBushGen goldBush = new OreberryBushGen((Block)TinkerWorld.oreBerry, 13, 6);
    OreberryBushGen copperBush = new OreberryBushGen((Block)TinkerWorld.oreBerry, 14, 12);
    OreberryBushGen tinBush = new OreberryBushGen((Block)TinkerWorld.oreBerry, 15, 12);
    OreberryBushGen aluminumBush = new OreberryBushGen((Block)TinkerWorld.oreBerrySecond, 12, 14);
    OreberryBushGen silverBush = new OreberryBushGen((Block)TinkerWorld.oreBerrySecond, 13, 8);

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.provider.isHellWorld) {
            this.generateNether(random, chunkX * 16, chunkZ * 16, world);
        } else if (world.provider.terrainType != WorldType.FLAT || PHConstruct.genOresFlat) {
            this.generateSurface(random, chunkX * 16, chunkZ * 16, world);
            if (world.provider.dimensionId == 0) {
                this.generateOreBushes(random, chunkX * 16, chunkZ * 16, world);
            }
        }
        if (PHConstruct.superfunWorld && world.provider.dimensionId == 0) {
            this.superfunGenerate(random, chunkX * 16, chunkZ * 16, world);
        }
        if (PHConstruct.worldBorder) {
            this.generateChunkBorder(random, chunkX * 16, chunkZ * 16, world);
        }
    }

    void generateSurface(Random random, int xChunk, int zChunk, World world) {
        String biomeName = world.getWorldChunkManager().getBiomeGenAt((int)xChunk, (int)zChunk).biomeName;
        this.generateUndergroundOres(random, xChunk, zChunk, world);
        if (biomeName == "Extreme Hills Edge" || biomeName == "Extreme Hills") {
            this.generateUndergroundOres(random, xChunk, zChunk, world);
        }
    }

    void generateUndergroundOres(Random random, int xChunk, int zChunk, World world) {
        int zPos;
        int yPos;
        int xPos;
        int q;
        if (PHConstruct.generateCopper) {
            for (q = 0; q <= PHConstruct.copperuDensity; ++q) {
                xPos = xChunk + random.nextInt(16);
                yPos = PHConstruct.copperuMinY + random.nextInt(PHConstruct.copperuMaxY - PHConstruct.copperuMinY);
                zPos = zChunk + random.nextInt(16);
                this.copper.generate(world, random, xPos, yPos, zPos);
            }
        }
        if (PHConstruct.generateTin) {
            for (q = 0; q <= PHConstruct.tinuDensity; ++q) {
                xPos = xChunk + random.nextInt(16);
                yPos = PHConstruct.tinuMinY + random.nextInt(PHConstruct.tinuMaxY - PHConstruct.tinuMinY);
                zPos = zChunk + random.nextInt(16);
                this.tin.generate(world, random, xPos, yPos, zPos);
            }
        }
        if (PHConstruct.generateAluminum) {
            for (q = 0; q <= PHConstruct.aluminumuDensity; ++q) {
                xPos = xChunk + random.nextInt(16);
                yPos = PHConstruct.aluminumuMinY + random.nextInt(PHConstruct.aluminumuMaxY - PHConstruct.aluminumuMinY);
                zPos = zChunk + random.nextInt(16);
                this.aluminum.generate(world, random, xPos, yPos, zPos);
            }
        }
    }

    void generateOreBushes(Random random, int xChunk, int zChunk, World world) {
        int zPos;
        int yPos;
        int xPos;
        int i;
        if (PHConstruct.generateIronBush && random.nextInt(PHConstruct.ironBushRarity + 1) == 0) {
            for (i = 0; i < PHConstruct.ironBushDensity; ++i) {
                xPos = xChunk + random.nextInt(16);
                yPos = PHConstruct.seaLevel - 32;
                zPos = zChunk + random.nextInt(16);
                if ((yPos = this.findAdequateLocation(world, xPos, yPos, zPos, PHConstruct.seaLevel, 0)) == -1) continue;
                this.ironBush.generate(world, random, xPos, yPos, zPos);
            }
        }
        if (PHConstruct.generateGoldBush && random.nextInt(PHConstruct.goldBushRarity + 1) == 0) {
            for (i = 0; i < PHConstruct.goldBushDensity; ++i) {
                xPos = xChunk + random.nextInt(16);
                yPos = 16;
                zPos = zChunk + random.nextInt(16);
                if ((yPos = this.findAdequateLocation(world, xPos, yPos, zPos, 32, 0)) == -1) continue;
                this.goldBush.generate(world, random, xPos, yPos, zPos);
            }
        }
        if (PHConstruct.generateCopperBush && random.nextInt(PHConstruct.copperBushRarity + 1) == 0) {
            for (i = 0; i < PHConstruct.copperBushDensity; ++i) {
                xPos = xChunk + random.nextInt(16);
                yPos = (PHConstruct.copperBushMaxY + PHConstruct.copperBushMinY) / 2;
                zPos = zChunk + random.nextInt(16);
                if ((yPos = this.findAdequateLocation(world, xPos, yPos, zPos, PHConstruct.copperBushMaxY, PHConstruct.copperBushMinY)) == -1) continue;
                this.copperBush.generate(world, random, xPos, yPos, zPos);
            }
        }
        if (PHConstruct.generateTinBush && random.nextInt(PHConstruct.tinBushRarity + 1) == 0) {
            for (i = 0; i < PHConstruct.tinBushDensity; ++i) {
                xPos = xChunk + random.nextInt(16);
                yPos = (PHConstruct.tinBushMaxY + PHConstruct.tinBushMinY) / 2;
                zPos = zChunk + random.nextInt(16);
                if ((yPos = this.findAdequateLocation(world, xPos, yPos, zPos, PHConstruct.tinBushMaxY, PHConstruct.tinBushMinY)) == -1) continue;
                this.tinBush.generate(world, random, xPos, yPos, zPos);
            }
        }
        if (PHConstruct.generateAluminumBush && random.nextInt(PHConstruct.aluminumBushRarity + 1) == 0) {
            for (i = 0; i < PHConstruct.aluminumBushDensity; ++i) {
                xPos = xChunk + random.nextInt(16);
                yPos = (PHConstruct.aluminumBushMaxY + PHConstruct.aluminumBushMinY) / 2;
                zPos = zChunk + random.nextInt(16);
                if ((yPos = this.findAdequateLocation(world, xPos, yPos, zPos, PHConstruct.aluminumBushMaxY, PHConstruct.aluminumBushMinY)) == -1) continue;
                this.aluminumBush.generate(world, random, xPos, yPos, zPos);
            }
        }
        if (PHConstruct.generateEssenceBush && random.nextInt(PHConstruct.essenceBushRarity) == 0) {
            for (i = 0; i < PHConstruct.silverBushDensity; ++i) {
                xPos = xChunk + random.nextInt(16);
                yPos = PHConstruct.seaLevel - 16;
                zPos = zChunk + random.nextInt(16);
                if ((yPos = this.findAdequateLocation(world, xPos, yPos, zPos, 32, 0)) == -1) continue;
                this.silverBush.generate(world, random, xPos, yPos, zPos);
            }
        }
    }

    void generateNether(Random random, int xChunk, int zChunk, World world) {
        int zPos;
        int yPos;
        int xPos;
        int i;
        if (PHConstruct.generateCobalt) {
            for (i = 0; i < PHConstruct.cobaltDensity; ++i) {
                xPos = xChunk + random.nextInt(16);
                yPos = random.nextInt(64) + 32;
                zPos = zChunk + random.nextInt(16);
                this.cobalt.generate(world, random, xPos, yPos, zPos);
            }
            for (i = 0; i < PHConstruct.cobaltDensity; ++i) {
                xPos = xChunk + random.nextInt(16);
                yPos = random.nextInt(128);
                zPos = zChunk + random.nextInt(16);
                this.cobalt.generate(world, random, xPos, yPos, zPos);
            }
        }
        if (PHConstruct.generateArdite) {
            for (i = 0; i < PHConstruct.arditeDensity; ++i) {
                xPos = xChunk + random.nextInt(16);
                yPos = random.nextInt(64) + 32;
                zPos = zChunk + random.nextInt(16);
                this.ardite.generate(world, random, xPos, yPos, zPos);
            }
            for (i = 0; i < PHConstruct.arditeDensity; ++i) {
                xPos = xChunk + random.nextInt(16);
                yPos = random.nextInt(128);
                zPos = zChunk + random.nextInt(16);
                this.ardite.generate(world, random, xPos, yPos, zPos);
            }
        }
    }

    int findAdequateLocation(World world, int x, int y, int z, int heightLimit, int depthLimit) {
        int height = y;
        do {
            if (world.getBlock(x, height, z) != Blocks.air || world.getBlock(x, height + 1, z) == Blocks.air) continue;
            return height + 1;
        } while (++height < heightLimit);
        height = y;
        do {
            if (world.getBlock(x, height, z) != Blocks.air || world.getBlock(x, height - 1, z) == Blocks.air) continue;
            return height - 1;
        } while (--height > depthLimit);
        return -1;
    }

    void superfunGenerate(Random random, int chunkX, int chunkZ, World world) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 128; ++y) {
                    Block block = world.getBlock(x + chunkX, y, z + chunkZ);
                    if (block == null) continue;
                    if (block.getMaterial() == Material.leaves) {
                        world.setBlock(x + chunkX, y, z + chunkZ, Blocks.lava, 0, 0);
                    }
                    if (block.getMaterial() == Material.wood) {
                        world.setBlock(x + chunkX, y, z + chunkZ, Blocks.netherrack, 0, 0);
                    }
                    if (block == Blocks.stone) {
                        world.setBlock(x + chunkX, y, z + chunkZ, Blocks.end_stone, 0, 0);
                    }
                    if (y > 40 && (block.getMaterial() == Material.ground || block.getMaterial() == Material.grass)) {
                        world.setBlock(x + chunkX, y, z + chunkZ, Blocks.soul_sand, 0, 0);
                    }
                    if (block.getMaterial() != Material.sand) continue;
                    world.setBlock(x + chunkX, y, z + chunkZ, Blocks.monster_egg, 0, 0);
                }
            }
        }
    }

    void generateChunkBorder(Random random, int chunkX, int chunkZ, World world) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                if (x + chunkX != PHConstruct.worldBorderSize && x + chunkX != -PHConstruct.worldBorderSize && z + chunkZ != PHConstruct.worldBorderSize && z + chunkZ != -PHConstruct.worldBorderSize) continue;
                for (int y = 0; y < 256; ++y) {
                    world.setBlock(x + chunkX, y, z + chunkZ, Blocks.bedrock, 0, 0);
                }
            }
        }
    }
}

