/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.world.gen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class PlantGen
extends WorldGenerator {
    public final Block plant;
    public final int metadata;
    public int chances = 64;
    int xSize = 8;
    int ySize = 4;
    int zSize = 8;
    boolean clumped = true;

    public PlantGen(Block b, int meta) {
        this.plant = b;
        this.metadata = meta;
    }

    public PlantGen(Block b, int meta, int count, int range, int height, int width, boolean clumped) {
        this.plant = b;
        this.metadata = meta;
        this.chances = count;
        this.xSize = range;
        this.ySize = height;
        this.zSize = width;
        this.clumped = clumped;
    }

    public boolean generate(World world, Random random, int x, int y, int z) {
        for (int iter = 0; iter < this.chances; ++iter) {
            int posZ;
            int posX = this.clumped ? x + random.nextInt(this.xSize) - random.nextInt(this.xSize) : x + random.nextInt(this.xSize);
            int posY = this.clumped ? y + random.nextInt(this.ySize) - random.nextInt(this.ySize) : y + random.nextInt(this.ySize);
            int n = posZ = this.clumped ? z + random.nextInt(this.zSize) - random.nextInt(this.zSize) : z + random.nextInt(this.zSize);
            if (world.getBlock(posX, posY, posZ) != Blocks.air || world.provider.hasNoSky && posY >= 127 || !this.plant.canBlockStay(world, posX, posY, posZ)) continue;
            world.setBlock(posX, posY, posZ, this.plant, this.metadata, 2);
        }
        return true;
    }
}

