/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.world.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import tconstruct.world.TinkerWorld;

public abstract class SlimeBase
extends EntityLiving
implements IMob {
    public float sizeOffset;
    public float sizeFactor;
    public float sizeHeight;
    protected int slimeJumpDelay = 0;

    public SlimeBase(World world) {
        super(world);
        this.initializeSlime();
    }

    protected abstract String getSlimeParticle();

    protected String getJumpSound() {
        return "mob.slime." + (this.getSlimeSize() > 1 ? "big" : "small");
    }

    protected boolean makesSoundOnJump() {
        return this.getSlimeSize() > 0;
    }

    protected boolean makesSoundOnLand() {
        return this.getSlimeSize() > 2;
    }

    public int getSlimeSize() {
        return this.dataWatcher.getWatchableObjectByte(16);
    }

    public void setSlimeSize(int size) {
        this.dataWatcher.updateObject(16, (Object)((byte)size));
        this.setSize(0.6f * (float)size, 0.6f * (float)size);
        this.setPosition(this.posX, this.posY, this.posZ);
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue((double)this.getMaxHealthForSize());
        this.setHealth(this.getMaxHealthForSize());
        this.jumpMovementFactor = 0.004f * (float)size + 0.01f;
        this.experienceValue = size + 2 ^ size;
    }

    protected float getMaxHealthForSize() {
        int i = this.getSlimeSize();
        if (i == 1) {
            return 4.0f;
        }
        return Math.min(i * i + 8, 49);
    }

    protected int getJumpDelay() {
        return this.rand.nextInt(120) + 40;
    }

    protected boolean canDamagePlayer() {
        return this.getSlimeSize() > 1;
    }

    protected int getAttackStrength() {
        return this.getSlimeSize();
    }

    protected abstract SlimeBase createInstance(World var1);

    protected void initializeSlime() {
        int offset = this.rand.nextInt(299);
        offset = offset < 149 ? 1 : (offset < 298 ? 2 : 3);
        int size = 1 << offset;
        this.yOffset = 0.0f;
        this.slimeJumpDelay = this.rand.nextInt(120) + 40;
        this.setSlimeSize(size);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, (Object)1);
    }

    public void jump() {
        this.motionY = 0.05 * (double)this.getSlimeSize() + 0.37;
        if (this.isPotionActive(Potion.jump)) {
            this.motionY += (double)((float)(this.getActivePotionEffect(Potion.jump).getAmplifier() + 1) * 0.1f);
        }
        if (this.isSprinting()) {
            float f = this.rotationYaw * ((float)Math.PI / 180);
            this.motionX -= (double)(MathHelper.sin((float)f) * 0.2f);
            this.motionZ += (double)(MathHelper.cos((float)f) * 0.2f);
        }
        if (!(this instanceof IBossDisplayData) && this.getBrightness(1.0f) > 0.9f && this.rand.nextInt(5) == 0 && this.worldObj.canBlockSeeTheSky(MathHelper.floor_double((double)this.posX), MathHelper.floor_double((double)this.posY), MathHelper.floor_double((double)this.posZ))) {
            int size = this.getSlimeSize() - 1;
            if (size <= 0) {
                this.kill();
            } else {
                this.setSlimeSize(size);
            }
        }
        this.isAirBorne = true;
        ForgeHooks.onLivingJump((EntityLivingBase)this);
    }

    public void onUpdate() {
        int i;
        if (!this.worldObj.isRemote && this.worldObj.difficultySetting == EnumDifficulty.PEACEFUL && this.getSlimeSize() > 0) {
            this.isDead = true;
        }
        this.sizeFactor += (this.sizeOffset - this.sizeFactor) * 0.5f;
        this.sizeHeight = this.sizeFactor;
        boolean flag = this.onGround;
        super.onUpdate();
        if (this.onGround && !flag) {
            i = this.getSlimeSize();
            for (int j = 0; j < i * 8; ++j) {
                float f = this.rand.nextFloat() * (float)Math.PI * 2.0f;
                float offset = this.rand.nextFloat() * 0.5f + 0.5f;
                float xPos = MathHelper.sin((float)f) * (float)i * 0.5f * offset;
                float zPos = MathHelper.cos((float)f) * (float)i * 0.5f * offset;
                TinkerWorld.proxy.spawnParticle(this.getSlimeParticle(), this.posX + (double)xPos, this.boundingBox.minY, this.posZ + (double)zPos, 0.0, 0.0, 0.0);
            }
            if (this.makesSoundOnLand()) {
                this.playSound(this.getJumpSound(), this.getSoundVolume(), ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            }
            this.sizeOffset = -0.5f;
        } else if (!this.onGround && flag) {
            this.sizeOffset = 1.0f;
        }
        this.alterSquishAmount();
        if (this.worldObj.isRemote) {
            i = this.getSlimeSize();
            this.setSize(0.6f * (float)i, 0.6f * (float)i);
        }
    }

    protected void alterSquishAmount() {
        this.sizeOffset *= 0.6f;
    }

    protected void updateEntityActionState() {
        this.despawnEntity();
        EntityPlayer entityplayer = this.worldObj.getClosestVulnerablePlayerToEntity((Entity)this, 16.0);
        if (entityplayer != null) {
            this.faceEntity((Entity)entityplayer, 10.0f, 20.0f);
        } else if (this.onGround && this.slimeJumpDelay == 1) {
            this.rotationYaw = this.rotationYaw + this.rand.nextFloat() * 180.0f - 90.0f;
            if (this.rotationYaw > 360.0f) {
                this.rotationYaw -= 360.0f;
            }
            if (this.rotationYaw < 0.0f) {
                this.rotationYaw += 360.0f;
            }
        }
        if (this.onGround && this.slimeJumpDelay-- <= 0) {
            this.slimeJumpDelay = this.getJumpDelay();
            if (entityplayer != null) {
                this.slimeJumpDelay /= 12;
            }
            this.isJumping = true;
            if (this.makesSoundOnJump()) {
                this.playSound(this.getJumpSound(), this.getSoundVolume(), ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f) * 0.8f);
            }
            this.moveStrafing = 1.0f - this.rand.nextFloat() * 2.0f;
            this.moveForward = this.getSlimeSize();
        } else {
            this.isJumping = false;
            if (this.onGround) {
                this.moveForward = 0.0f;
                this.moveStrafing = 0.0f;
            }
        }
    }

    public void onCollideWithPlayer(EntityPlayer par1EntityPlayer) {
        if (this.canDamagePlayer()) {
            int i = this.getSlimeSize();
            if (this.canEntityBeSeen((Entity)par1EntityPlayer) && this.getDistanceSqToEntity((Entity)par1EntityPlayer) < 0.6 * (double)i * 0.6 * (double)i && par1EntityPlayer.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), (float)this.getAttackStrength())) {
                this.playSound("mob.attack", 1.0f, (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
            }
        }
    }

    public void setDead() {
        int size = this.getSlimeSize();
        if (!this.worldObj.isRemote && size > 1 && this.getHealth() <= 0.0f && size < 8) {
            float f = -0.5f * (float)size / 4.0f;
            float f1 = -0.5f * (float)size / 4.0f;
            SlimeBase entityslime = this.createInstance(this.worldObj);
            entityslime.setSlimeSize(size / 2);
            entityslime.setLocationAndAngles(this.posX + (double)f, this.posY + 0.5, this.posZ + (double)f1, this.rand.nextFloat() * 360.0f, 0.0f);
            this.worldObj.spawnEntityInWorld((Entity)entityslime);
        }
        super.setDead();
    }

    protected void dropFewItems(boolean par1, int par2) {
        int size = this.getSlimeSize();
        Item j = this.getDropItem();
        if (j != null && this.rand.nextInt(2) == 0 || size >= 8) {
            int k = this.rand.nextInt(3) + this.rand.nextInt(this.getSlimeSize());
            if (par2 > 0) {
                k += this.rand.nextInt(par2 + 1);
            }
            for (int l = 0; l < k; ++l) {
                this.entityDropItem(new ItemStack(j), 1.0f);
            }
        }
    }

    protected void fall(float distance) {
        ForgeHooks.onLivingFall((EntityLivingBase)this, (float)distance);
    }

    public boolean getCanSpawnHere() {
        int z;
        int y;
        if (!this.worldObj.checkNoEntityCollision(this.boundingBox) || !this.worldObj.getCollidingBoundingBoxes((Entity)this, this.boundingBox).isEmpty() || this.worldObj.isAnyLiquid(this.boundingBox)) {
            return false;
        }
        int x = MathHelper.floor_double((double)this.posX);
        if (this.worldObj.getSavedLightValue(EnumSkyBlock.Sky, x, y = MathHelper.floor_double((double)this.boundingBox.minY), z = MathHelper.floor_double((double)this.posZ)) > this.rand.nextInt(32)) {
            return false;
        }
        int light = this.worldObj.getBlockLightValue(x, y, z);
        if (this.worldObj.isThundering()) {
            int i1 = this.worldObj.skylightSubtracted;
            this.worldObj.skylightSubtracted = 10;
            light = this.worldObj.getBlockLightValue(x, y, z);
            this.worldObj.skylightSubtracted = i1;
        }
        return light <= this.rand.nextInt(8);
    }

    public double getMountedYOffset() {
        return (double)this.height * 0.3;
    }

    protected String getHurtSound() {
        return this.getJumpSound();
    }

    protected String getDeathSound() {
        return this.getJumpSound();
    }

    protected float getSoundVolume() {
        return Math.min(0.05f * (float)this.getSlimeSize(), 0.3f);
    }

    public int getVerticalFaceSpeed() {
        return 0;
    }

    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setInteger("Size", this.getSlimeSize() - 1);
    }

    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        this.setSlimeSize(par1NBTTagCompound.getInteger("Size") + 1);
    }
}

