/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.world.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import tconstruct.armor.TinkerArmor;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.ToolBuilder;
import tconstruct.library.tools.ToolCore;
import tconstruct.world.entity.BlueSlime;
import tconstruct.world.entity.SlimeBase;

public class KingBlueSlime
extends SlimeBase
implements IBossDisplayData {
    public KingBlueSlime(World world) {
        super(world);
        this.experienceValue = 500;
        this.func_110163_bv();
    }

    @Override
    protected String getSlimeParticle() {
        return "blueslime";
    }

    @Override
    protected SlimeBase createInstance(World world) {
        return new KingBlueSlime(world);
    }

    @Override
    protected void initializeSlime() {
        this.yOffset = 0.0f;
        this.slimeJumpDelay = this.rand.nextInt(120) + 40;
        this.setSlimeSize(8);
    }

    @Override
    protected float getMaxHealthForSize() {
        return 100.0f;
    }

    protected boolean canDespawn() {
        return false;
    }

    @Override
    public void setDead() {
        if (!this.worldObj.isRemote && this.getHealth() <= 0.0f) {
            for (int c = 15 + this.rand.nextInt(6); c > 0; --c) {
                BlueSlime entityslime = new BlueSlime(this.worldObj);
                entityslime.setSlimeSize(1);
                double r = this.rand.nextDouble() * Math.PI;
                double x = Math.cos(r);
                double z = Math.sin(r);
                entityslime.setLocationAndAngles(this.posX - 1.0 + x, this.posY + 0.5, this.posZ - 1.0 + z, this.rand.nextFloat() * 360.0f, 0.0f);
                entityslime.motionX = x;
                entityslime.motionY = -0.5 - this.rand.nextDouble();
                entityslime.motionZ = z;
                this.worldObj.spawnEntityInWorld((Entity)entityslime);
            }
        }
        this.isDead = true;
    }

    @Override
    protected void dropFewItems(boolean par1, int par2) {
        super.dropFewItems(par1, par2);
        ToolCore tool = this.getValidTool();
        ItemStack headStack = new ItemStack(tool.getHeadItem(), 1, 17);
        ItemStack handleStack = new ItemStack(tool.getHandleItem(), 1, 17);
        ItemStack accessoryStack = tool.getAccessoryItem() != null ? new ItemStack(tool.getAccessoryItem(), 1, 17) : null;
        ItemStack extraStack = tool.getExtraItem() != null ? new ItemStack(tool.getExtraItem(), 1, 17) : null;
        String loc = "tool." + tool.getToolName().toLowerCase() + ".kingslime";
        String name = StatCollector.canTranslate((String)loc) ? StatCollector.translateToLocal((String)loc) : StatCollector.translateToLocal((String)"tool.kingslimeprefix") + " " + tool.getLocalizedToolName();
        ItemStack toolStack = ToolBuilder.instance.buildTool(headStack, handleStack, accessoryStack, extraStack, name);
        if (toolStack != null) {
            NBTTagCompound tags = toolStack.getTagCompound().getCompoundTag("InfiTool");
            tags.setInteger("Attack", 5 + tool.getDamageVsEntity(null));
            tags.setInteger("TotalDurability", 2500);
            tags.setInteger("BaseDurability", 2500);
            tags.setInteger("MiningSpeed", 1400);
            this.entityDropItem(toolStack, 0.0f);
            if (this.rand.nextInt(5) == 0) {
                ItemStack dropStack = new ItemStack(TinkerArmor.heartCanister, 1, 1);
                this.entityDropItem(dropStack, 0.0f);
            }
        }
    }

    ToolCore getValidTool() {
        ToolCore tool = TConstructRegistry.tools.get(this.rand.nextInt(TConstructRegistry.tools.size()));
        return tool;
    }
}

