/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.world.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mantle.blocks.MantleBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import tconstruct.library.TConstructRegistry;
import tconstruct.world.TinkerWorld;
import tconstruct.world.model.SlimePadRender;

public class SlimePad
extends MantleBlock {
    public SlimePad(Material par2Material) {
        super(par2Material);
        this.setBlockBounds(0.125f, 0.0625f, 0.125f, 0.875f, 0.625f, 0.875f);
        this.setCreativeTab(TConstructRegistry.blockTab);
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        return null;
    }

    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        if (!world.isBlockIndirectlyGettingPowered(x, y, z)) {
            double moveX = 0.0;
            double moveZ = 0.0;
            double speed = 0.25;
            int meta = world.getBlockMetadata(x, y, z);
            switch (meta % 8) {
                case 6: {
                    moveX += speed;
                    break;
                }
                case 7: {
                    moveX += speed;
                    moveZ += speed;
                    break;
                }
                case 0: {
                    moveZ += speed;
                    break;
                }
                case 1: {
                    moveZ += speed;
                    moveX -= speed;
                    break;
                }
                case 2: {
                    moveX -= speed;
                    break;
                }
                case 3: {
                    moveX -= speed;
                    moveZ -= speed;
                    break;
                }
                case 4: {
                    moveZ -= speed;
                    break;
                }
                case 5: {
                    moveZ -= speed;
                    moveX += speed;
                }
            }
            if (entity instanceof EntityItem) {
                entity.posY += 1.0;
            }
            entity.fallDistance = 0.0f;
            entity.addVelocity(moveX, speed * 2.0, moveZ);
            world.playSoundEffect((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), this.stepSound.getStepResourcePath(), this.stepSound.getVolume() / 2.0f, this.stepSound.getPitch() * 0.65f);
        }
    }

    public boolean isBlockReplaceable(World world, int x, int y, int z) {
        return false;
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        int face = MathHelper.floor_double((double)((double)(entity.rotationYaw * 8.0f / 360.0f) + 0.5)) + (entity.isSneaking() ? 4 : 0) & 7;
        int meta = world.getBlockMetadata(x, y, z) & 8;
        world.setBlockMetadataWithNotify(x, y, z, face | meta, 2);
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public int getRenderBlockPass() {
        return 1;
    }

    public int getRenderType() {
        return SlimePadRender.model;
    }

    public void registerBlockIcons(IIconRegister iconRegister) {
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        return TinkerWorld.slimeGel.getIcon(side, 1);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getFluidIcon(int meta) {
        return TinkerWorld.slimeChannel.getIcon(2, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getNubIcon(int meta) {
        return TinkerWorld.slimeGel.getIcon(0, 0);
    }
}

