/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.world.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import tconstruct.library.TConstructRegistry;
import tconstruct.world.TinkerWorld;

public class GravelOre
extends BlockSand {
    public String[] textureNames = new String[]{"iron", "gold", "copper", "tin", "aluminum", "cobalt"};
    public IIcon[] icons;

    public GravelOre() {
        this.blockMaterial = Material.craftedSnow;
        this.setCreativeTab(TConstructRegistry.blockTab);
        this.setStepSound(soundTypeGravel);
    }

    public void registerBlockIcons(IIconRegister iconRegister) {
        this.icons = new IIcon[this.textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.registerIcon("tinker:ore_" + this.textureNames[i] + "_gravel");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        if (meta >= this.textureNames.length) {
            return this.icons[0];
        }
        return this.icons[meta];
    }

    public float getBlockHardness(World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        if (meta == 5) {
            return 10.0f;
        }
        return 3.0f;
    }

    public int damageDropped(int meta) {
        return meta;
    }

    public Item getItemDropped(int par1, Random par2Random, int par3) {
        return Item.getItemFromBlock((Block)TinkerWorld.oreGravel);
    }

    public void getSubBlocks(Item id, CreativeTabs tab, List list) {
        for (int iter = 0; iter < 6; ++iter) {
            list.add(new ItemStack(id, 1, iter));
        }
    }
}

