/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.weaponry.weapons;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import tconstruct.library.weaponry.BowBaseAmmo;
import tconstruct.weaponry.TinkerWeaponry;
import tconstruct.weaponry.ammo.ArrowAmmo;

public class ShortBow
extends BowBaseAmmo {
    public ShortBow() {
        super(0, "Shortbow");
    }

    @Override
    public float minAccuracy(ItemStack itemStack) {
        return 1.0f;
    }

    @Override
    public float maxAccuracy(ItemStack itemStack) {
        return 1.0f;
    }

    @Override
    protected Entity createProjectile(ItemStack arrows, World world, EntityPlayer player, float speed, float accuracy, float windup) {
        float weight;
        NBTTagCompound tags;
        float matAccuracy;
        if (arrows.getItem() instanceof ArrowAmmo && (accuracy += (100.0f - (matAccuracy = (tags = arrows.getTagCompound().getCompoundTag("InfiTool")).getFloat("Accuracy"))) / 10.0f / (weight = tags.getFloat("Mass"))) < 0.0f) {
            accuracy = 0.0f;
        }
        return super.createProjectile(arrows, world, player, speed, accuracy, windup);
    }

    @Override
    public String getIconSuffix(int partType) {
        switch (partType) {
            case 0: {
                return "_bow_top";
            }
            case 1: {
                return "_bowstring_broken";
            }
            case 2: {
                return "_bowstring";
            }
            case 3: {
                return "_bow_bottom";
            }
        }
        return "";
    }

    @Override
    public String getEffectSuffix() {
        return "_bow_effect";
    }

    @Override
    public String getDefaultFolder() {
        return "shortbow";
    }

    @Override
    public int getPartAmount() {
        return 3;
    }

    @Override
    protected boolean animateLayer(int renderPass) {
        return renderPass < 3;
    }

    @Override
    public Item getHeadItem() {
        return TinkerWeaponry.partBowLimb;
    }

    @Override
    public Item getHandleItem() {
        return TinkerWeaponry.bowstring;
    }

    @Override
    public Item getAccessoryItem() {
        return TinkerWeaponry.partBowLimb;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onUpdate(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        EntityPlayerSP player;
        ItemStack usingItem;
        super.onUpdate(stack, world, entity, par4, par5);
        if (entity instanceof EntityPlayerSP && (usingItem = (player = (EntityPlayerSP)entity).getItemInUse()) != null && usingItem.getItem() == this) {
            player.movementInput.moveForward *= 1.5f;
            player.movementInput.moveStrafe *= 1.5f;
        }
    }
}

