/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.weaponry.weapons;

import cpw.mods.fml.common.Loader;
import java.util.List;
import mods.battlegear2.api.core.InventoryPlayerBattle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.ToolBuilder;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.library.weaponry.AmmoItem;
import tconstruct.library.weaponry.IAmmo;
import tconstruct.library.weaponry.ProjectileWeapon;
import tconstruct.tools.TinkerTools;
import tconstruct.util.Reference;
import tconstruct.weaponry.TinkerWeaponry;
import tconstruct.weaponry.ammo.BoltAmmo;
import tconstruct.weaponry.entity.BoltEntity;

public class Crossbow
extends ProjectileWeapon {
    public Crossbow() {
        super(0, "Crossbow");
        this.setMaxDamage(100);
    }

    public boolean isLoaded(ItemStack itemStack) {
        if (itemStack.hasTagCompound()) {
            return this.isLoaded(itemStack.getTagCompound().getCompoundTag("InfiTool"));
        }
        return false;
    }

    public boolean isLoaded(NBTTagCompound tags) {
        return tags.getBoolean("Loaded");
    }

    public ItemStack getLoadedAmmo(ItemStack itemStack) {
        NBTTagCompound tags = itemStack.getTagCompound().getCompoundTag("InfiTool");
        if (!this.isLoaded(tags)) {
            return null;
        }
        ItemStack ammo = ItemStack.loadItemStackFromNBT((NBTTagCompound)tags.getCompoundTag("LoadedItem"));
        if (ammo != null && ammo.getItem() != null && ammo.getItem() != TinkerWeaponry.boltAmmo) {
            tags.removeTag("LoadedItem");
            ammo = null;
        }
        return ammo;
    }

    @Override
    public float getMinWindupProgress(ItemStack itemStack) {
        return 1.0f;
    }

    @Override
    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        NBTTagCompound tags = stack.getTagCompound().getCompoundTag("InfiTool");
        if (player.isSneaking() && this.unload(stack, player, tags)) {
            return stack;
        }
        if (tags.getBoolean("Loaded")) {
            this.fire(stack, world, player);
        }
        this.initiateReload(stack, player, tags);
        return stack;
    }

    @Override
    public void onUpdate(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        super.onUpdate(stack, world, entity, par4, par5);
        if (!stack.hasTagCompound()) {
            return;
        }
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (player.inventory.getCurrentItem() != stack) {
            return;
        }
        NBTTagCompound tags = stack.getTagCompound().getCompoundTag("InfiTool");
        if (tags.hasKey("Reloading")) {
            int timeLeft = tags.getInteger("Reloading");
            if (--timeLeft > 0) {
                tags.setInteger("Reloading", timeLeft);
            } else {
                tags.removeTag("Reloading");
                this.reload(stack, player, world, tags);
            }
        }
    }

    @Override
    public float getWindupProgress(ItemStack itemStack, EntityPlayer player) {
        NBTTagCompound tags = itemStack.getTagCompound().getCompoundTag("InfiTool");
        if (tags.getBoolean("Loaded")) {
            return 1.0f;
        }
        if (tags.hasKey("Reloading")) {
            return 1.0f - (float)tags.getInteger("Reloading") / (float)this.getWindupTime(itemStack);
        }
        return 0.0f;
    }

    public void initiateReload(ItemStack stack, EntityPlayer player, NBTTagCompound tags) {
        if (tags.getBoolean("Broken")) {
            return;
        }
        if (this.searchForAmmo(player, stack) != null && !tags.hasKey("Reloading")) {
            tags.setInteger("Reloading", this.getWindupTime(stack));
        }
    }

    public boolean reload(ItemStack weapon, EntityPlayer player, World world, NBTTagCompound tags) {
        ItemStack ammo = this.searchForAmmo(player, weapon);
        if (ammo == null) {
            return false;
        }
        if (tags.getBoolean("Loaded")) {
            return false;
        }
        ItemStack copy = ammo.copy();
        copy.getTagCompound().getCompoundTag("InfiTool").setInteger("Ammo", 1);
        NBTTagCompound ammotag = new NBTTagCompound();
        copy.writeToNBT(ammotag);
        tags.setTag("LoadedItem", (NBTBase)ammotag);
        tags.setBoolean("Loaded", true);
        if (ammo.getItem() instanceof IAmmo) {
            ((IAmmo)ammo.getItem()).consumeAmmo(1, ammo);
        } else if (Loader.isModLoaded((String)"battlegear2")) {
            ((InventoryPlayerBattle)player.inventory).consumeInventoryItem(ammo.getItem());
        } else {
            player.inventory.consumeInventoryItem(ammo.getItem());
        }
        this.playReloadSound(world, player, weapon, ammo);
        return true;
    }

    public boolean unload(ItemStack weapon, EntityPlayer player, NBTTagCompound tags) {
        if (tags.hasKey("Reloading")) {
            tags.removeTag("Reloading");
            return true;
        }
        if (tags.getBoolean("Loaded")) {
            ItemStack loadedItem = ItemStack.loadItemStackFromNBT((NBTTagCompound)tags.getCompoundTag("LoadedItem"));
            AmmoItem ammo = (AmmoItem)loadedItem.getItem();
            ammo.pickupAmmo(loadedItem, this.searchForAmmo(player, weapon), player);
            tags.setBoolean("Loaded", false);
            tags.removeTag("LoadedItem");
            return true;
        }
        return false;
    }

    public void fire(ItemStack weapon, World world, EntityPlayer player) {
        NBTTagCompound tags = weapon.getTagCompound().getCompoundTag("InfiTool");
        if (!tags.getBoolean("Loaded")) {
            return;
        }
        ItemStack ammo = ItemStack.loadItemStackFromNBT((NBTTagCompound)tags.getCompoundTag("LoadedItem"));
        tags.setBoolean("Loaded", false);
        tags.removeTag("LoadedItem");
        if (ammo == null) {
            return;
        }
        float projectileSpeed = this.getProjectileSpeed(weapon);
        float windup = this.getWindupTime(weapon);
        float accuracy = this.getAccuracy(weapon, (int)windup);
        Entity projectile = this.createProjectile(ammo, world, player, projectileSpeed, accuracy, 1.0f);
        int reinforced = 0;
        if (tags.hasKey("Unbreaking")) {
            reinforced = tags.getInteger("Unbreaking");
        }
        if (this.random.nextInt(10) < 10 - reinforced) {
            AbilityHelper.damageTool(weapon, 1, (EntityLivingBase)player, false);
        }
        this.playFiringSound(world, player, weapon, ammo, projectileSpeed, accuracy);
        if (!world.isRemote) {
            world.spawnEntityInWorld(projectile);
        }
    }

    @Override
    public ItemStack searchForAmmo(EntityPlayer player, ItemStack weapon) {
        ItemStack offhand;
        if (Loader.isModLoaded((String)"battlegear2") && (offhand = ((InventoryPlayerBattle)player.inventory).getCurrentOffhandWeapon()) != null && offhand.getItem() instanceof BoltAmmo && ((IAmmo)offhand.getItem()).getAmmoCount(offhand) > 0) {
            return offhand;
        }
        ItemStack[] inventory = player.inventory.mainInventory;
        for (int i = 0; i < inventory.length; ++i) {
            ItemStack stack = inventory[i];
            if (stack == null || !(stack.getItem() instanceof BoltAmmo) || ((IAmmo)stack.getItem()).getAmmoCount(stack) <= 0) continue;
            return stack;
        }
        if (player.capabilities.isCreativeMode && TinkerWeaponry.creativeBolt != null) {
            return TinkerWeaponry.creativeBolt.copy();
        }
        return null;
    }

    @Override
    protected Entity createProjectile(ItemStack ammo, World world, EntityPlayer player, float speed, float accuracy, float windup) {
        ItemStack reference = ammo.copy();
        reference.stackSize = 1;
        reference.getTagCompound().getCompoundTag("InfiTool").setInteger("Ammo", 1);
        BoltEntity arrow = new BoltEntity(world, player, speed, accuracy, reference);
        if (player.capabilities.isCreativeMode) {
            arrow.canBePickedUp = 2;
        }
        return arrow;
    }

    @Override
    public float minAccuracy(ItemStack itemStack) {
        return 0.0f;
    }

    @Override
    public float maxAccuracy(ItemStack itemStack) {
        return 0.0f;
    }

    public void playReloadSound(World world, EntityPlayer player, ItemStack weapon, ItemStack ammo) {
        world.playSoundAtEntity((Entity)player, Reference.resource("crossbowReload"), 1.0f, 1.0f);
    }

    @Override
    public void playFiringSound(World world, EntityPlayer player, ItemStack weapon, ItemStack ammo, float speed, float accuracy) {
        world.playSoundAtEntity((Entity)player, "random.bow", 1.0f, 0.5f);
    }

    @Override
    public IIcon getIcon(ItemStack stack, int renderPass) {
        float progress;
        if (!this.animateLayer(renderPass) && renderPass < this.getPartAmount()) {
            return super.getIcon(stack, renderPass);
        }
        if (!stack.hasTagCompound()) {
            return super.getIcon(stack, renderPass);
        }
        NBTTagCompound tags = stack.getTagCompound().getCompoundTag("InfiTool");
        if (tags == null || renderPass > 10) {
            return super.getIcon(stack, renderPass);
        }
        if (tags.getBoolean("Loaded")) {
            progress = 1.0f;
        } else {
            if (!tags.hasKey("Reloading")) {
                return super.getIcon(stack, renderPass);
            }
            progress = this.getWindupProgress(stack, this.getWindupTime(stack) - tags.getInteger("Reloading"));
        }
        if (renderPass >= this.getPartAmount()) {
            String effect = "Effect" + (1 + renderPass - this.getPartAmount());
            if (tags.hasKey(effect)) {
                int index = tags.getInteger(effect);
                if (this.animationEffectIcons.get(index) != null) {
                    return this.getCorrectAnimationIcon(this.animationEffectIcons, index, progress);
                }
                return (IIcon)this.effectIcons.get(index);
            }
            return super.getIcon(stack, renderPass);
        }
        switch (renderPass) {
            case 0: {
                return this.getCorrectAnimationIcon(this.animationHandleIcons, tags.getInteger("RenderHandle"), progress);
            }
            case 1: {
                return this.getCorrectAnimationIcon(this.animationHeadIcons, tags.getInteger("RenderHead"), progress);
            }
            case 2: {
                return this.getCorrectAnimationIcon(this.animationAccessoryIcons, tags.getInteger("RenderAccessory"), progress);
            }
            case 3: {
                return this.getCorrectAnimationIcon(this.animationExtraIcons, tags.getInteger("RenderExtra"), progress);
            }
        }
        return emptyIcon;
    }

    @Override
    public String getIconSuffix(int partType) {
        switch (partType) {
            case 0: {
                return "_crossbow_bow";
            }
            case 1: {
                return "";
            }
            case 2: {
                return "_crossbow_body";
            }
            case 3: {
                return "_crossbow_string";
            }
            case 4: {
                return "_crossbow_binding";
            }
        }
        return "";
    }

    @Override
    public String getEffectSuffix() {
        return "_crossbow_effect";
    }

    @Override
    public String getDefaultFolder() {
        return "crossbow";
    }

    @Override
    public int getPartAmount() {
        return 4;
    }

    @Override
    protected boolean animateLayer(int renderPass) {
        return renderPass == 1 || renderPass == 2;
    }

    @Override
    public Item getHeadItem() {
        return TinkerWeaponry.partCrossbowLimb;
    }

    @Override
    public Item getHandleItem() {
        return TinkerWeaponry.partCrossbowBody;
    }

    @Override
    public Item getAccessoryItem() {
        return TinkerWeaponry.bowstring;
    }

    @Override
    public Item getExtraItem() {
        return TinkerTools.toughBinding;
    }

    @Override
    public String[] getTraits() {
        return new String[]{"weapon", "bow", "windup"};
    }

    @Override
    public void buildTool(int id, String name, List list) {
        ItemStack extraStack;
        ItemStack accessoryStack;
        ItemStack handleStack;
        if (TConstructRegistry.getBowMaterial(id) == null) {
            return;
        }
        ItemStack headStack = new ItemStack(this.getHeadItem(), 1, id);
        ItemStack tool = ToolBuilder.instance.buildTool(headStack, handleStack = new ItemStack(this.getHandleItem(), 1, id), accessoryStack = new ItemStack(this.getAccessoryItem(), 1, 0), extraStack = this.getPartAmount() > 3 ? new ItemStack(this.getExtraItem(), 1, id) : null, "");
        if (tool != null) {
            tool.getTagCompound().getCompoundTag("InfiTool").setBoolean("Built", true);
            list.add(tool);
        }
    }

    @Override
    public int getColorFromItemStack(ItemStack stack, int renderPass) {
        if (renderPass != 2 || !stack.hasTagCompound()) {
            return super.getColorFromItemStack(stack, renderPass);
        }
        int mat = stack.getTagCompound().getCompoundTag("InfiTool").getInteger("Accessory");
        switch (mat) {
            case 0: {
                return -1;
            }
            case 1: {
                return -3355393;
            }
            case 2: {
                return -13108;
            }
        }
        return super.getColorFromItemStack(stack, renderPass);
    }
}

