/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.weaponry.entity;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import tconstruct.library.entity.ProjectileBase;
import tconstruct.weaponry.TinkerWeaponry;

public class ShurikenEntity
extends ProjectileBase {
    public int spin = 0;
    public int rollAngle = 0;

    public ShurikenEntity(World world) {
        super(world);
        this.setSize(0.3f, 0.1f);
        this.bounceOnNoDamage = false;
    }

    public ShurikenEntity(World world, double d, double d1, double d2) {
        super(world, d, d1, d2);
        this.setSize(0.3f, 0.1f);
        this.bounceOnNoDamage = false;
    }

    public ShurikenEntity(World world, EntityPlayer player, float speed, float accuracy, ItemStack stack) {
        super(world, player, speed, accuracy, stack);
        this.setSize(0.3f, 0.1f);
        this.bounceOnNoDamage = false;
    }

    @Override
    public void onUpdate() {
        if (this.ticksInGround == 0) {
            this.spin = (this.spin + 33) % 360;
        }
        super.onUpdate();
    }

    @Override
    public void readSpawnData(ByteBuf data) {
        super.readSpawnData(data);
        this.spin = TinkerWeaponry.random.nextInt(360);
    }

    @Override
    protected double getGravity() {
        return (double)(this.ticksExisted / 8) * 0.018;
    }

    @Override
    protected double getSlowdown() {
        return 0.15f;
    }

    @Override
    protected double getStuckDepth() {
        return 0.8;
    }
}

