/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.weaponry.client;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;
import tconstruct.library.weaponry.IWindup;

public class CrosshairHandler {
    private static Minecraft mc = Minecraft.getMinecraft();
    private static ResourceLocation crossHairSquare = new ResourceLocation("tinker", "textures/gui/Crosshair.png");
    private static ResourceLocation crossHairTip = new ResourceLocation("tinker", "textures/gui/Crosshair2.png");
    private static ResourceLocation crossHairWeird = new ResourceLocation("tinker", "textures/gui/Crosshair3.png");
    private static ResourceLocation crossHairSpike = new ResourceLocation("tinker", "textures/gui/Crosshair4.png");

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Pre event) {
        ResourceLocation tex;
        if (event.type != RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            return;
        }
        ItemStack equipped = CrosshairHandler.mc.thePlayer.getCurrentEquippedItem();
        if (equipped == null || equipped.getItem() == null) {
            return;
        }
        if (!(equipped.getItem() instanceof IWindup)) {
            return;
        }
        IWindup weapon = (IWindup)equipped.getItem();
        float width = event.resolution.getScaledWidth();
        float height = event.resolution.getScaledHeight();
        boolean type = false;
        switch (weapon.getCrosshairType()) {
            case SQUARE: {
                tex = crossHairSquare;
                break;
            }
            case TIP: {
                tex = crossHairTip;
                break;
            }
            case WEIRD: {
                tex = crossHairWeird;
                type = true;
                break;
            }
            case SPIKE: {
                tex = crossHairSpike;
                type = true;
                break;
            }
            default: {
                tex = crossHairSquare;
                type = false;
            }
        }
        mc.getTextureManager().bindTexture(tex);
        GL11.glEnable((int)3042);
        OpenGlHelper.glBlendFunc((int)775, (int)769, (int)1, (int)0);
        float spread = (1.0f - weapon.getWindupProgress(equipped, (EntityPlayer)CrosshairHandler.mc.thePlayer)) * 25.0f;
        if (!type) {
            this.drawCrosshairPart(width / 2.0f - spread, height / 2.0f - spread, 0);
            this.drawCrosshairPart(width / 2.0f + spread, height / 2.0f - spread, 1);
            this.drawCrosshairPart(width / 2.0f - spread, height / 2.0f + spread, 2);
            this.drawCrosshairPart(width / 2.0f + spread, height / 2.0f + spread, 3);
        } else {
            this.drawAlternateCrosshairPart(width / 2.0f, height / 2.0f - spread, 0);
            this.drawAlternateCrosshairPart(width / 2.0f - spread, height / 2.0f, 1);
            this.drawAlternateCrosshairPart(width / 2.0f + spread, height / 2.0f, 2);
            this.drawAlternateCrosshairPart(width / 2.0f, height / 2.0f + spread, 3);
        }
        OpenGlHelper.glBlendFunc((int)770, (int)771, (int)1, (int)0);
        GL11.glDisable((int)3042);
        event.setCanceled(true);
        mc.getTextureManager().bindTexture(Gui.icons);
    }

    private void drawCrosshairPart(float width, float height, int part) {
        double w = width;
        double h = height;
        double s = 4.0;
        double z = -90.0;
        double u1 = 0.0;
        double v1 = 0.0;
        switch (part) {
            case 0: {
                w -= s;
                h -= s;
                break;
            }
            case 1: {
                u1 = 0.5;
                w += s;
                h -= s;
                break;
            }
            case 2: {
                v1 = 0.5;
                w -= s;
                h += s;
                break;
            }
            case 3: {
                u1 = 0.5;
                v1 = 0.5;
                w += s;
                h += s;
            }
        }
        double u2 = u1 + 0.5;
        double v2 = v1 + 0.5;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(w - s, h - s, z, u1, v1);
        tessellator.addVertexWithUV(w - s, h + s, z, u1, v2);
        tessellator.addVertexWithUV(w + s, h + s, z, u2, v2);
        tessellator.addVertexWithUV(w + s, h - s, z, u2, v1);
        tessellator.draw();
    }

    private void drawAlternateCrosshairPart(float width, float height, int part) {
        double w = width;
        double h = height;
        double s = 8.0;
        double z = -90.0;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawing(4);
        if (part == 0) {
            tessellator.addVertexWithUV(w - 8.0, h - 8.0, -90.0, 0.0, 0.0);
            tessellator.addVertexWithUV(w, h, -90.0, 0.5, 0.5);
            tessellator.addVertexWithUV(w + 8.0, h - 8.0, -90.0, 1.0, 0.0);
        } else if (part == 1) {
            tessellator.addVertexWithUV(w - 8.0, h - 8.0, -90.0, 0.0, 0.0);
            tessellator.addVertexWithUV(w - 8.0, h + 8.0, -90.0, 0.0, 1.0);
            tessellator.addVertexWithUV(w, h, -90.0, 0.5, 0.5);
        } else if (part == 2) {
            tessellator.addVertexWithUV(w, h, -90.0, 0.5, 0.5);
            tessellator.addVertexWithUV(w + 8.0, h + 8.0, -90.0, 1.0, 1.0);
            tessellator.addVertexWithUV(w + 8.0, h - 8.0, -90.0, 1.0, 0.0);
        } else if (part == 3) {
            tessellator.addVertexWithUV(w, h, -90.0, 0.5, 0.5);
            tessellator.addVertexWithUV(w - 8.0, h + 8.0, -90.0, 0.0, 1.0);
            tessellator.addVertexWithUV(w + 8.0, h + 8.0, -90.0, 1.0, 1.0);
        }
        tessellator.draw();
    }
}

