/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.weaponry;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import tconstruct.armor.player.TPlayerStats;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.PatternBuilder;
import tconstruct.library.crafting.ToolBuilder;
import tconstruct.library.entity.ProjectileBase;
import tconstruct.library.event.PartBuilderEvent;
import tconstruct.library.event.SmelteryCastEvent;
import tconstruct.library.event.ToolBuildEvent;
import tconstruct.library.event.ToolCraftEvent;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.library.tools.ArrowMaterial;
import tconstruct.library.tools.BowMaterial;
import tconstruct.library.tools.BowstringMaterial;
import tconstruct.library.tools.CustomMaterial;
import tconstruct.library.tools.DualMaterialToolPart;
import tconstruct.library.tools.FletchingMaterial;
import tconstruct.library.tools.FletchlingLeafMaterial;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.tools.ToolMaterial;
import tconstruct.library.util.IToolPart;
import tconstruct.library.weaponry.ArrowShaftMaterial;
import tconstruct.library.weaponry.BowBaseAmmo;
import tconstruct.library.weaponry.IAmmo;
import tconstruct.library.weaponry.ProjectileWeapon;
import tconstruct.tools.TinkerTools;
import tconstruct.util.config.PHConstruct;
import tconstruct.weaponry.TinkerWeaponry;
import tconstruct.weaponry.ammo.ArrowAmmo;
import tconstruct.weaponry.ammo.BoltAmmo;
import tconstruct.weaponry.weapons.Crossbow;
import tconstruct.weaponry.weapons.LongBow;
import tconstruct.weaponry.weapons.ShortBow;

public class WeaponryHandler {
    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        Item item = event.crafting.getItem();
        if (!event.player.worldObj.isRemote && item == Item.getItemFromBlock((Block)TinkerTools.toolStationWood)) {
            if (!PHConstruct.beginnerBook) {
                return;
            }
            TPlayerStats stats = TPlayerStats.get(event.player);
            if (!stats.weaponryManual) {
                stats.weaponryManual = true;
                AbilityHelper.spawnItemAtPlayer(event.player, new ItemStack(TinkerTools.manualBook, 1, 4));
            }
        }
    }

    @SubscribeEvent
    public void onAmmoCrafted(ToolCraftEvent.NormalTool event) {
        if (!(event.tool instanceof IAmmo)) {
            return;
        }
        NBTTagCompound tags = event.toolTag.getCompoundTag("InfiTool");
        if (event.tool instanceof ArrowAmmo) {
            ToolMaterial head = TConstructRegistry.getMaterial(tags.getInteger("Head"));
            ArrowMaterial arrow = TConstructRegistry.getArrowMaterial(tags.getInteger("Head"));
            ArrowShaftMaterial shaft = (ArrowShaftMaterial)TConstructRegistry.getCustomMaterial(tags.getInteger("Handle"), ArrowShaftMaterial.class);
            FletchingMaterial fletching = (FletchingMaterial)TConstructRegistry.getCustomMaterial(tags.getInteger("Accessory"), FletchingMaterial.class);
            if (fletching == null) {
                fletching = (FletchingMaterial)TConstructRegistry.getCustomMaterial(tags.getInteger("Accessory"), FletchlingLeafMaterial.class);
            }
            if (arrow == null || shaft == null || fletching == null) {
                event.setResult(Event.Result.DENY);
                return;
            }
            int durability = (int)((float)head.durability() * shaft.durabilityModifier * fletching.durabilityModifier);
            float weight = arrow.mass + shaft.weight;
            float accuracy = fletching.accuracy;
            float breakChance = shaft.fragility * arrow.breakChance + fletching.breakChance;
            this.setAmmoData(tags, durability, weight, breakChance, accuracy, head.shoddy(), head.reinforced());
            if (tags.getInteger("Handle") == 3) {
                tags.setInteger("Fiery", 5);
            }
            int mods = Math.max(0, tags.getInteger("Modifiers") - 1);
            tags.setInteger("Modifiers", mods);
        } else if (event.tool instanceof BoltAmmo) {
            ToolMaterial headMat = TConstructRegistry.getMaterial(tags.getInteger("Head"));
            ToolMaterial coreMat = TConstructRegistry.getMaterial(tags.getInteger("Handle"));
            ArrowMaterial head = TConstructRegistry.getArrowMaterial(tags.getInteger("Head"));
            ArrowMaterial core = TConstructRegistry.getArrowMaterial(tags.getInteger("Handle"));
            FletchingMaterial fletching = (FletchingMaterial)TConstructRegistry.getCustomMaterial(tags.getInteger("Accessory"), FletchingMaterial.class);
            if (fletching == null) {
                fletching = (FletchingMaterial)TConstructRegistry.getCustomMaterial(tags.getInteger("Accessory"), FletchlingLeafMaterial.class);
            }
            if (head == null || core == null || fletching == null) {
                event.setResult(Event.Result.DENY);
                return;
            }
            int durability = (int)((float)headMat.durability() * coreMat.handleDurability() * fletching.durabilityModifier);
            float weight = head.mass + core.mass * 1.5f;
            float accuracy = (100.0f + fletching.accuracy) / 2.0f;
            float breakChance = (fletching.breakChance * 2.0f + 0.15f * core.breakChance) * head.breakChance / 2.0f;
            float shoddy = (headMat.shoddy() + coreMat.shoddy()) / 2.0f;
            int reinforced = Math.max(headMat.reinforced(), coreMat.reinforced());
            this.setAmmoData(tags, durability, weight, breakChance, accuracy, shoddy, reinforced);
            int mods = Math.max(0, tags.getInteger("Modifiers") - 1);
            tags.setInteger("Modifiers", mods);
        }
        IAmmo ammoItem = (IAmmo)((Object)event.tool);
        tags.setInteger("Ammo", ammoItem.getMaxAmmo(tags));
    }

    @SubscribeEvent
    public void onProjectileWeaponCrafted(ToolCraftEvent.NormalTool event) {
        if (!(event.tool instanceof ProjectileWeapon)) {
            return;
        }
        NBTTagCompound tags = event.toolTag.getCompoundTag("InfiTool");
        ProjectileWeapon weapon = (ProjectileWeapon)event.tool;
        int drawSpeed = 0;
        float flightSpeed = 0.0f;
        boolean enchanted = false;
        if (event.tool instanceof BowBaseAmmo) {
            BowMaterial top = TConstructRegistry.getBowMaterial(tags.getInteger("Head"));
            BowMaterial bottom = TConstructRegistry.getBowMaterial(tags.getInteger("Accessory"));
            BowstringMaterial string = (BowstringMaterial)TConstructRegistry.getCustomMaterial(tags.getInteger("Handle"), BowstringMaterial.class);
            if (top == null || bottom == null || string == null) {
                event.setResult(Event.Result.DENY);
                return;
            }
            drawSpeed = (int)((float)(top.drawspeed + bottom.drawspeed) / 2.0f * string.drawspeedModifier);
            flightSpeed = (top.flightSpeedMax + bottom.flightSpeedMax) / 2.0f * string.flightSpeedModifier;
            if (event.tool instanceof ShortBow) {
                drawSpeed = (int)((double)drawSpeed * 0.9);
            }
            if (event.tool instanceof LongBow) {
                drawSpeed = (int)((float)drawSpeed * 1.8f);
                flightSpeed *= 1.5f;
            }
            enchanted = tags.getInteger("Handle") == 1;
        } else if (event.tool instanceof Crossbow) {
            BowMaterial top = TConstructRegistry.getBowMaterial(tags.getInteger("Head"));
            BowstringMaterial string = (BowstringMaterial)TConstructRegistry.getCustomMaterial(tags.getInteger("Accessory"), BowstringMaterial.class);
            if (top == null || string == null) {
                event.setResult(Event.Result.DENY);
                return;
            }
            drawSpeed = (int)((float)top.drawspeed * string.drawspeedModifier);
            flightSpeed = top.flightSpeedMax * string.flightSpeedModifier;
            drawSpeed = (int)((float)drawSpeed * 2.5f);
            drawSpeed = (int)((float)drawSpeed - (float)drawSpeed * 0.25f);
            flightSpeed = (float)((double)flightSpeed * 1.5);
            enchanted = tags.getInteger("Accessory") == 1;
        } else {
            return;
        }
        if (enchanted) {
            int modifiers = tags.getInteger("Modifiers");
            tags.setInteger("Modifiers", ++modifiers);
        }
        tags.setInteger("DrawSpeed", drawSpeed);
        tags.setInteger("BaseDrawSpeed", drawSpeed);
        tags.setFloat("FlightSpeed", flightSpeed);
    }

    @SubscribeEvent
    public void buildArrow(ToolBuildEvent event) {
        if (event.headStack == null || event.handleStack == null || event.accessoryStack == null) {
            return;
        }
        CustomMaterial mat = TConstructRegistry.getCustomMaterial(event.handleStack, ArrowShaftMaterial.class);
        if (mat == null) {
            return;
        }
        Item extra = event.extraStack != null ? event.extraStack.getItem() : null;
        ToolCore tool = ToolBuilder.instance.getMatchingRecipe(event.headStack.getItem(), mat.craftingItem.getItem(), event.accessoryStack.getItem(), extra);
        if (tool == TinkerWeaponry.arrowAmmo) {
            event.handleStack = mat.craftingItem.copy();
        }
    }

    @SubscribeEvent
    public void buildBolt(ToolBuildEvent event) {
        if (event.headStack == null || event.handleStack == null) {
            return;
        }
        if (event.headStack.getItem() != TinkerWeaponry.partBolt) {
            return;
        }
        if (event.accessoryStack != null && event.headStack.getItem() == TinkerWeaponry.partBolt && event.handleStack.getItem() == TinkerWeaponry.partBolt && event.accessoryStack.getItem() == TinkerWeaponry.fletching) {
            return;
        }
        ItemStack bolt1 = event.headStack.copy();
        ItemStack bolt2 = event.headStack;
        ItemStack fletching = event.handleStack;
        DualMaterialToolPart dualPart = (DualMaterialToolPart)bolt2.getItem();
        bolt1.setItemDamage(dualPart.getMaterialID2(bolt1));
        event.headStack = bolt1;
        event.handleStack = bolt2;
        event.accessoryStack = fletching;
    }

    private void setAmmoData(NBTTagCompound tags, int durability, float weight, float breakChance, float accuracy, float shoddy, int reinforced) {
        tags.setInteger("TotalDurability", durability);
        tags.setInteger("BaseDurability", durability);
        tags.setFloat("Mass", weight);
        tags.setFloat("BreakChance", breakChance);
        tags.setFloat("Accuracy", accuracy);
        tags.setFloat("Shoddy", shoddy);
        tags.setInteger("Unbreaking", reinforced);
    }

    @SubscribeEvent
    public void weaponryPartCrafted(PartBuilderEvent.NormalPart event) {
        PatternBuilder.MaterialSet ms;
        PatternBuilder.ItemKey key;
        if (event.pattern == null) {
            return;
        }
        if (event.pattern.getItem() == TinkerWeaponry.woodPattern && (event.pattern.getItemDamage() == 1 || event.pattern.getItemDamage() == 3)) {
            key = PatternBuilder.instance.getItemKey(event.material);
            if (key == null) {
                return;
            }
            ms = PatternBuilder.instance.materialSets.get(key.key);
            if (ms == null) {
                return;
            }
            if (TConstructRegistry.getBowMaterial(ms.materialID) == null) {
                event.setResult(Event.Result.DENY);
            }
        }
        if (event.pattern.getItem() == TinkerTools.woodPattern && event.pattern.getItemDamage() == 25) {
            key = PatternBuilder.instance.getItemKey(event.material);
            if (key == null) {
                return;
            }
            ms = PatternBuilder.instance.materialSets.get(key.key);
            if (ms == null) {
                return;
            }
            if (TConstructRegistry.getArrowMaterial(ms.materialID) == null) {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public void weaponryPartCast(SmelteryCastEvent.CastingTable event) {
        if (event.recipe == null || event.recipe.output == null) {
            return;
        }
        if (!(event.recipe.output.getItem() instanceof IToolPart)) {
            return;
        }
        int mat = ((IToolPart)event.recipe.output.getItem()).getMaterialID(event.recipe.output);
        if (event.recipe.output.getItem() == TinkerWeaponry.arrowhead && TConstructRegistry.getArrowMaterial(mat) == null) {
            event.setResult(Event.Result.DENY);
        }
        if ((event.recipe.output.getItem() == TinkerWeaponry.partBowLimb || event.recipe.output.getItem() == TinkerWeaponry.partCrossbowLimb) && TConstructRegistry.getBowMaterial(mat) == null) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void boneanaParts(ToolBuildEvent event) {
        if (event.headStack == null || event.handleStack == null || event.accessoryStack != null || event.extraStack != null) {
            return;
        }
        if (event.headStack.getItem() == Items.golden_carrot && event.handleStack.getItem() == Items.bone) {
            if (!(event.headStack.hasTagCompound() && event.headStack.getTagCompound().hasKey("display") && event.headStack.getTagCompound().getCompoundTag("display").hasKey("Name") && event.headStack.getTagCompound().getCompoundTag("display").getString("Name").toLowerCase().equals("banana"))) {
                return;
            }
            event.name = "\u2400Bon\u00e6na";
            event.headStack = new ItemStack(TinkerTools.swordBlade, 1, 5);
            event.handleStack = new ItemStack(TinkerTools.toolRod, 1, 5);
            event.accessoryStack = new ItemStack(TinkerTools.wideGuard, 1, 5);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void boneanaBuilding(ToolCraftEvent.NormalTool event) {
        if ("\u00a7f\u2400Bon\u00e6na".equals(event.toolTag.getCompoundTag("display").getString("Name"))) {
            event.toolTag.getCompoundTag("display").setString("Name", EnumChatFormatting.YELLOW + "Bon\u00e6na");
            NBTTagList lore = new NBTTagList();
            lore.appendTag((NBTBase)new NBTTagString(StatCollector.translateToLocal((String)"tool.boneana.lore")));
            event.toolTag.getCompoundTag("display").setTag("Lore", (NBTBase)lore);
            NBTTagCompound tag = event.toolTag.getCompoundTag("InfiTool");
            tag.setBoolean("Special", true);
            tag.setInteger("Attack", 4);
            tag.setInteger("TotalDurability", 600);
            tag.setInteger("BaseDurability", 600);
            tag.setFloat("Shoddy", -2.0f);
            tag.setInteger("MiningSpeed", 1);
            tag.setInteger("HarvestLevel", 0);
            tag.setInteger("Modifiers", 0);
            ItemStack weapon = new ItemStack((Item)TinkerWeaponry.boneana);
            weapon.setTagCompound(event.toolTag);
            event.overrideResult(weapon);
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void entityJoin(EntityJoinWorldEvent event) {
        if (event.entity instanceof ProjectileBase) {
            ProjectileBase projectile = (ProjectileBase)event.entity;
            if (projectile.returnStack == null || !(projectile.returnStack.getItem() instanceof ToolCore)) {
                event.setCanceled(true);
            }
        }
    }
}

