/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.util.network;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import mantle.common.network.AbstractPacket;
import net.minecraft.entity.player.EntityPlayer;
import tconstruct.armor.ArmorProxyClient;
import tconstruct.armor.player.TPlayerStats;

public class HealthUpdatePacket
extends AbstractPacket {
    private float health;

    public HealthUpdatePacket() {
    }

    public HealthUpdatePacket(float health) {
        this.health = health;
    }

    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeFloat(this.health);
    }

    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.health = buffer.readFloat();
    }

    public void handleClientSide(EntityPlayer player) {
        ArmorProxyClient.armorExtended.recalculateHealth(player, TPlayerStats.get(player));
        player.setHealth(this.health);
    }

    public void handleServerSide(EntityPlayer player) {
    }
}

