/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.tools.logic;

import mantle.blocks.abstracts.InventoryLogic;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import tconstruct.library.crafting.StencilBuilder;
import tconstruct.tools.inventory.PatternShaperContainer;

public class StencilTableLogic
extends InventoryLogic
implements ISidedInventory {
    private ItemStack selectedStack;

    public StencilTableLogic() {
        super(2);
    }

    public boolean canUpdate() {
        return false;
    }

    public String getDefaultName() {
        return "toolstation.PatternShaper";
    }

    public Container getGuiContainer(InventoryPlayer inventoryplayer, World world, int x, int y, int z) {
        return new PatternShaperContainer(inventoryplayer, this);
    }

    public void setSelectedPattern(ItemStack stack) {
        this.selectedStack = stack;
        this.setInventorySlotContents(1, stack);
    }

    public void setInventorySlotContents(int slot, ItemStack itemstack) {
        super.setInventorySlotContents(slot, itemstack);
        if (slot == 0) {
            if (itemstack != null && StencilBuilder.isBlank(itemstack)) {
                super.setInventorySlotContents(1, this.selectedStack);
            } else if (itemstack != null) {
                ItemStack cpy = itemstack.copy();
                cpy.stackSize = 1;
                super.setInventorySlotContents(1, cpy);
            } else {
                super.setInventorySlotContents(1, null);
            }
        }
    }

    public ItemStack decrStackSize(int slot, int quantity) {
        if (slot == 1) {
            super.decrStackSize(0, 1);
            if (this.inventory[0] == null) {
                return super.decrStackSize(slot, quantity);
            }
            return this.inventory[1].copy();
        }
        ItemStack ret = super.decrStackSize(slot, quantity);
        if (this.inventory[0] == null) {
            super.decrStackSize(1, 1);
        }
        return ret;
    }

    public void altDecrStackSize(int slot, int quantity) {
        if (this.inventory[slot] != null) {
            if (this.inventory[slot].stackSize <= quantity) {
                ItemStack stack = this.inventory[slot];
                this.inventory[slot] = null;
                return;
            }
            ItemStack split = this.inventory[slot].splitStack(quantity);
            if (this.inventory[slot].stackSize == 0) {
                this.inventory[slot] = null;
            }
            return;
        }
    }

    public boolean canDropInventorySlot(int slot) {
        return slot == 0;
    }

    public int[] getAccessibleSlotsFromSide(int side) {
        return new int[0];
    }

    public boolean canInsertItem(int i, ItemStack itemstack, int j) {
        return false;
    }

    public boolean canExtractItem(int i, ItemStack itemstack, int j) {
        return false;
    }

    public String getInventoryName() {
        return StatCollector.translateToLocal((String)"toolstation.PatternShaper");
    }

    public boolean hasCustomInventoryName() {
        return true;
    }

    public void closeInventory() {
    }

    public void openInventory() {
    }
}

