/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.tools.logic;

import mantle.blocks.abstracts.InventoryLogic;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import tconstruct.library.crafting.PatternBuilder;
import tconstruct.library.util.IPattern;
import tconstruct.tools.inventory.PartCrafterChestContainer;
import tconstruct.tools.inventory.PartCrafterContainer;
import tconstruct.tools.logic.PatternChestLogic;

public class PartBuilderLogic
extends InventoryLogic
implements ISidedInventory {
    boolean craftedTop = false;
    boolean craftedBottom = false;

    public PartBuilderLogic() {
        super(10);
    }

    public String getDefaultName() {
        return "toolstation.parts";
    }

    public Container getGuiContainer(InventoryPlayer inventoryplayer, World world, int x, int y, int z) {
        for (int xPos = x - 1; xPos <= x + 1; ++xPos) {
            for (int zPos = z - 1; zPos <= z + 1; ++zPos) {
                for (int yPos = y - 1; yPos <= y + 1; ++yPos) {
                    TileEntity tile = world.getTileEntity(xPos, yPos, zPos);
                    if (tile == null || !(tile instanceof PatternChestLogic) || x != xPos && z != zPos) continue;
                    return new PartCrafterChestContainer(inventoryplayer, this, (PatternChestLogic)tile);
                }
            }
        }
        return new PartCrafterContainer(inventoryplayer, this);
    }

    public boolean canDropInventorySlot(int slot) {
        return slot <= 3;
    }

    public ItemStack decrStackSize(int slotID, int quantity) {
        ItemStack returnStack = super.decrStackSize(slotID, quantity);
        this.tryBuildPart(slotID);
        return returnStack;
    }

    public void tryBuildPart(int slotID) {
        int decrease;
        int cost;
        IPattern item;
        int value;
        if (slotID == 4 || slotID == 5) {
            if (!this.craftedTop && this.inventory[0] != null) {
                value = PatternBuilder.instance.getPartValue(this.inventory[2]);
                item = (IPattern)this.inventory[0].getItem();
                int n = cost = item != null ? item.getPatternCost(this.inventory[0]) : 0;
                if (value > 0 && cost > 0) {
                    decrease = cost / value;
                    if (cost % value != 0) {
                        ++decrease;
                    }
                    super.decrStackSize(2, decrease);
                }
            }
            this.craftedTop = this.inventory[4] != null || this.inventory[5] != null;
        }
        if (!this.craftedTop) {
            this.buildTopPart();
        }
        if (slotID == 6 || slotID == 7) {
            if (!this.craftedBottom && this.inventory[1] != null) {
                value = PatternBuilder.instance.getPartValue(this.inventory[3]);
                item = (IPattern)this.inventory[1].getItem();
                int n = cost = item != null ? item.getPatternCost(this.inventory[1]) : 0;
                if (value > 0 && cost > 0) {
                    decrease = cost / value;
                    if (cost % value != 0) {
                        ++decrease;
                    }
                    super.decrStackSize(3, decrease);
                }
            }
            this.craftedBottom = this.inventory[6] != null || this.inventory[7] != null;
        }
        if (!this.craftedBottom) {
            this.buildBottomPart();
        }
    }

    public void setInventorySlotContents(int slot, ItemStack itemstack) {
        super.setInventorySlotContents(slot, itemstack);
        if (!(slot != 0 && slot != 2 || this.craftedTop)) {
            this.buildTopPart();
        }
        if (!(slot != 1 && slot != 3 || this.craftedBottom)) {
            this.buildBottomPart();
        }
    }

    void buildTopPart() {
        ItemStack[] parts = PatternBuilder.instance.getToolPart(this.inventory[2], this.inventory[0], this.inventory[1]);
        if (parts != null) {
            this.inventory[4] = parts[0];
            this.inventory[5] = parts[1];
        } else {
            this.inventory[5] = null;
            this.inventory[4] = null;
        }
    }

    void buildBottomPart() {
        ItemStack[] parts = PatternBuilder.instance.getToolPart(this.inventory[3], this.inventory[1], this.inventory[0]);
        if (parts != null) {
            this.inventory[6] = parts[0];
            this.inventory[7] = parts[1];
        } else {
            this.inventory[7] = null;
            this.inventory[6] = null;
        }
    }

    public void readFromNBT(NBTTagCompound tags) {
        super.readFromNBT(tags);
        this.craftedTop = tags.getBoolean("CraftedTop");
        this.craftedBottom = tags.getBoolean("CraftedBottom");
    }

    public void writeToNBT(NBTTagCompound tags) {
        super.writeToNBT(tags);
        tags.setBoolean("CraftedTop", this.craftedTop);
        tags.setBoolean("CraftedBottom", this.craftedBottom);
    }

    public int[] getAccessibleSlotsFromSide(int side) {
        return new int[0];
    }

    public boolean canInsertItem(int i, ItemStack itemstack, int j) {
        return false;
    }

    public boolean canExtractItem(int i, ItemStack itemstack, int j) {
        return false;
    }

    public String getInventoryName() {
        return this.getDefaultName();
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean canUpdate() {
        return false;
    }
}

