/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.tools.logic;

import cpw.mods.fml.common.registry.GameRegistry;
import mantle.blocks.BlockUtils;
import mantle.blocks.abstracts.InventoryLogic;
import mantle.blocks.iface.IActiveLogic;
import mantle.blocks.iface.IFacingLogic;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import tconstruct.tools.inventory.FurnaceContainer;

public class FurnaceLogic
extends InventoryLogic
implements IActiveLogic,
IFacingLogic,
ISidedInventory {
    boolean active = false;
    public int fuel;
    public int fuelGague;
    public int progress;
    public int fuelScale = 200;
    byte direction;
    private static final int[] slots_top = new int[]{0};
    private static final int[] slots_bottom = new int[]{2, 1};
    private static final int[] slots_sides = new int[]{1};

    public FurnaceLogic() {
        super(3);
    }

    public String getDefaultName() {
        return "container.furnace";
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean flag) {
        this.active = flag;
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
    }

    public int gaugeProgressScaled(int scale) {
        return this.progress * scale / this.fuelScale;
    }

    public int gaugeFuelScaled(int scale) {
        if (this.fuelGague == 0) {
            this.fuelGague = this.fuel;
            if (this.fuelGague == 0) {
                this.fuelGague = this.fuelScale;
            }
        }
        return this.fuel * scale / this.fuelGague;
    }

    public void updateEntity() {
        boolean burning = this.isBurning();
        boolean updateInventory = false;
        if (this.fuel <= 0 && this.canSmelt()) {
            this.fuel = this.fuelGague = FurnaceLogic.getItemBurnTime(this.inventory[1]);
            if (this.fuel > 0) {
                if (this.inventory[1].getItem().hasContainerItem()) {
                    this.inventory[1] = new ItemStack(this.inventory[1].getItem().getContainerItem());
                } else {
                    --this.inventory[1].stackSize;
                }
                if (this.inventory[1].stackSize <= 0) {
                    this.inventory[1] = null;
                }
                updateInventory = true;
            }
        }
        if (this.isBurning() && this.canSmelt()) {
            ++this.progress;
            if (this.progress >= this.fuelScale) {
                this.progress = 0;
                this.cookItems();
                updateInventory = true;
            }
        } else {
            this.progress = 0;
        }
        if (this.fuel > 0) {
            --this.fuel;
        }
        if (burning != this.isBurning()) {
            this.setActive(this.isBurning());
            updateInventory = true;
        }
        if (updateInventory) {
            this.markDirty();
        }
    }

    public void cookItems() {
        if (this.canSmelt()) {
            ItemStack itemstack = FurnaceRecipes.smelting().getSmeltingResult(this.inventory[0]);
            if (this.inventory[2] == null) {
                this.inventory[2] = itemstack.copy();
            } else if (this.inventory[2].isItemEqual(itemstack)) {
                this.inventory[2].stackSize += itemstack.stackSize;
            }
            --this.inventory[0].stackSize;
            if (this.inventory[0].stackSize <= 0) {
                this.inventory[0] = null;
            }
        }
    }

    public boolean canSmelt() {
        if (this.inventory[0] == null) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.smelting().getSmeltingResult(this.inventory[0]);
        if (itemstack == null) {
            return false;
        }
        if (this.inventory[2] == null) {
            return true;
        }
        if (!this.inventory[2].isItemEqual(itemstack)) {
            return false;
        }
        int result = this.inventory[2].stackSize + itemstack.stackSize;
        return result <= this.getInventoryStackLimit() && result <= itemstack.getMaxStackSize();
    }

    public boolean isBurning() {
        return this.fuel > 0;
    }

    public ItemStack getResultFor(ItemStack stack) {
        ItemStack result = FurnaceRecipes.smelting().getSmeltingResult(stack);
        if (result != null) {
            return result.copy();
        }
        return null;
    }

    public static int getItemBurnTime(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        Item item = stack.getItem();
        if (stack.getItem() instanceof ItemBlock && BlockUtils.getBlockFromItem((Item)item) != null) {
            Block block = BlockUtils.getBlockFromItem((Item)item);
            if (block == Blocks.wooden_slab) {
                return 150;
            }
            if (block == Blocks.log) {
                return 1200;
            }
            if (block.getMaterial() == Material.wood) {
                return 300;
            }
            if (block == Blocks.coal_block) {
                return 16000;
            }
        }
        if (item instanceof ItemTool && ((ItemTool)item).getToolMaterialName().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemSword && ((ItemSword)item).getToolMaterialName().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemHoe && ((ItemHoe)item).getToolMaterialName().equals("WOOD")) {
            return 200;
        }
        if (item == Items.stick) {
            return 100;
        }
        if (item == Items.coal) {
            return 1600;
        }
        if (item == Items.lava_bucket) {
            return 20000;
        }
        if (item == new ItemStack(Blocks.sapling).getItem()) {
            return 100;
        }
        if (item == Items.blaze_rod) {
            return 2400;
        }
        return GameRegistry.getFuelValue((ItemStack)stack);
    }

    public void readFromNBT(NBTTagCompound tags) {
        super.readFromNBT(tags);
        this.active = tags.getBoolean("Active");
        this.fuel = tags.getInteger("Fuel");
        this.fuelGague = tags.getInteger("FuelGague");
        this.readNetworkNBT(tags);
    }

    public void writeToNBT(NBTTagCompound tags) {
        super.writeToNBT(tags);
        tags.setInteger("Fuel", this.fuel);
        tags.setInteger("FuelGague", this.fuelGague);
        this.writeNetworkNBT(tags);
    }

    public void readNetworkNBT(NBTTagCompound tags) {
        this.active = tags.getBoolean("Active");
        this.direction = tags.getByte("Direction");
    }

    public void writeNetworkNBT(NBTTagCompound tags) {
        tags.setBoolean("Active", this.active);
        tags.setByte("Direction", this.direction);
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeNetworkNBT(tag);
        return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 1, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.readNetworkNBT(packet.func_148857_g());
        this.worldObj.func_147479_m(this.xCoord, this.yCoord, this.zCoord);
    }

    public Container getGuiContainer(InventoryPlayer inventoryplayer, World world, int x, int y, int z) {
        return new FurnaceContainer(inventoryplayer, this);
    }

    public byte getRenderDirection() {
        return this.direction;
    }

    public ForgeDirection getForgeDirection() {
        return ForgeDirection.VALID_DIRECTIONS[this.direction];
    }

    @Deprecated
    public void setDirection(int side) {
    }

    @Deprecated
    public void setDirection(float yaw, float pitch, EntityLivingBase player) {
        int facing = MathHelper.floor_double((double)((double)(yaw / 360.0f) + 0.5)) & 3;
        switch (facing) {
            case 0: {
                this.direction = (byte)2;
                break;
            }
            case 1: {
                this.direction = (byte)5;
                break;
            }
            case 2: {
                this.direction = (byte)3;
                break;
            }
            case 3: {
                this.direction = (byte)4;
            }
        }
    }

    public String getInventoryName() {
        return this.getDefaultName();
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public static boolean isItemFuel(ItemStack par0ItemStack) {
        return FurnaceLogic.getItemBurnTime(par0ItemStack) > 0;
    }

    public boolean isItemValidForSlot(int par1, ItemStack par2ItemStack) {
        return par1 == 2 ? false : (par1 == 1 ? FurnaceLogic.isItemFuel(par2ItemStack) : true);
    }

    public int[] getAccessibleSlotsFromSide(int par1) {
        return par1 == 0 ? slots_bottom : (par1 == 1 ? slots_top : slots_sides);
    }

    public boolean canInsertItem(int par1, ItemStack par2ItemStack, int par3) {
        return this.isItemValidForSlot(par1, par2ItemStack);
    }

    public boolean canExtractItem(int par1, ItemStack par2ItemStack, int par3) {
        return par3 != 0 || par1 != 1 || par2ItemStack.getItem() == Items.bucket;
    }
}

