/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.tools.items;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Facing;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import tconstruct.client.TProxyClient;
import tconstruct.library.tools.ToolCore;
import tconstruct.world.entity.BlueSlime;
import tconstruct.world.entity.KingBlueSlime;
import tconstruct.world.entity.SlimeBase;

public class TitleIcon
extends Item {
    int[] primaryColor = new int[]{6732776, 6732776};
    int[] secondaryColor = new int[]{1402815, 16772206};
    String[] mobNames = new String[]{"TConstruct.EdibleSlime", "TConstruct.KingSlime"};
    String[] achievementIconNames = new String[]{"tinkerer", "preparedFight", "proTinkerer", "enemySlayer", "dualConvenience"};
    IIcon[] achievementIcons = new IIcon[this.achievementIconNames.length];

    public TitleIcon() {
        this.setCreativeTab(CreativeTabs.tabMisc);
        this.setHasSubtypes(true);
    }

    public void registerIcons(IIconRegister iconRegister) {
        ToolCore.blankSprite = iconRegister.registerIcon("tinker:blanksprite");
        TProxyClient.metalBall = iconRegister.registerIcon("tinker:metalball");
        this.itemIcon = iconRegister.registerIcon("tinker:tparts");
        for (int i = 0; i < this.achievementIcons.length; ++i) {
            this.achievementIcons[i] = iconRegister.registerIcon("tinker:achievementIcons/" + (i < this.achievementIconNames.length ? this.achievementIconNames[i] : ""));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean requiresMultipleRenderPasses() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamageForRenderPass(int par1, int par2) {
        if (par1 == 255) {
            return this.itemIcon;
        }
        if (par1 >= 4096) {
            return this.getIconFromDamage(par1);
        }
        return new ItemStack(Items.spawn_egg).getItem().getIconFromDamageForRenderPass(par1, par2);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int par1) {
        int index;
        if (par1 >= 4096 && (index = par1 - 4096) < this.achievementIcons.length) {
            return this.achievementIcons[index];
        }
        return this.itemIcon;
    }

    public String getItemStackDisplayName(ItemStack par1ItemStack) {
        String s = ("" + StatCollector.translateToLocal((String)(this.getUnlocalizedName() + ".name"))).trim();
        String s1 = this.mobNames[par1ItemStack.getItemDamage()];
        if (s1 != null) {
            s = s + " " + StatCollector.translateToLocal((String)("entity." + s1 + ".name"));
        }
        return s;
    }

    public void getSubItems(Item b, CreativeTabs tab, List list) {
        for (int i = 0; i < this.mobNames.length; ++i) {
            list.add(new ItemStack(b, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemStack(ItemStack stack, int pass) {
        int damage = stack.getItemDamage();
        if (damage == 255) {
            return 0xFFFFFF;
        }
        if (damage >= 4096) {
            return 0xFFFFFF;
        }
        return pass == 0 ? this.primaryColor[damage] : this.secondaryColor[damage];
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int posX, int posY, int posZ, int par7, float par8, float par9, float par10) {
        if (!world.isRemote) {
            Block b = world.getBlock(posX, posY, posZ);
            posX += Facing.offsetsXForSide[par7];
            posY += Facing.offsetsYForSide[par7];
            posZ += Facing.offsetsZForSide[par7];
            double d0 = 0.0;
            if (par7 == 1 && b != null && b.getRenderType() == 11) {
                d0 = 0.5;
            }
            int damage = stack.getItemDamage();
            switch (damage) {
                case 0: {
                    TitleIcon.spawnEntity(posX, posY, posZ, (Entity)new BlueSlime(world), world, player);
                    break;
                }
                case 1: {
                    TitleIcon.spawnBossSlime(posX, posY, posZ, new KingBlueSlime(world), world, player);
                }
            }
            if (!player.capabilities.isCreativeMode) {
                --stack.stackSize;
            }
        }
        return true;
    }

    public static EntityLiving activateSpawnEgg(ItemStack stack, World world, double posX, double posY, double posZ, int par7) {
        Block b = world.getBlock((int)posX, (int)posY, (int)posZ);
        posX += (double)Facing.offsetsXForSide[par7];
        posY += (double)Facing.offsetsYForSide[par7];
        posZ += (double)Facing.offsetsZForSide[par7];
        double d0 = 0.0;
        if (par7 == 1 && b != null && b.getRenderType() == 11) {
            d0 = 0.5;
        }
        int damage = stack.getItemDamage();
        SlimeBase entity = null;
        switch (damage) {
            case 0: {
                entity = new BlueSlime(world);
                TitleIcon.spawnEntity(posX, posY, posZ, (Entity)entity, world);
                break;
            }
            case 1: {
                entity = new KingBlueSlime(world);
                TitleIcon.spawnBossSlime(posX, posY, posZ, new KingBlueSlime(world), world);
            }
        }
        return entity;
    }

    public static void spawnEntity(double x, double y, double z, Entity entity, World world) {
        if (!world.isRemote) {
            entity.setPosition(x, y, z);
            ((EntityLiving)entity).onSpawnWithEgg((IEntityLivingData)null);
            world.spawnEntityInWorld(entity);
        }
    }

    public static void spawnEntity(double x, double y, double z, Entity entity, World world, EntityPlayer player) {
        if (!world.isRemote) {
            entity.setPosition(x, y, z);
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                entity.setAngles(player.cameraYaw, player.cameraYaw);
            }
            ((EntityLiving)entity).onSpawnWithEgg((IEntityLivingData)null);
            world.spawnEntityInWorld(entity);
        }
    }

    public static void spawnBossSlime(double x, double y, double z, KingBlueSlime entity, World world, EntityPlayer player) {
        if (!world.isRemote) {
            entity.setPosition(x, y, z);
            entity.setSlimeSize(8);
            entity.onSpawnWithEgg(null);
            world.spawnEntityInWorld((Entity)entity);
        }
    }

    public static void spawnBossSlime(double x, double y, double z, KingBlueSlime entity, World world) {
        if (!world.isRemote) {
            entity.setPosition(x, y, z);
            entity.setSlimeSize(8);
            entity.onSpawnWithEgg(null);
            world.spawnEntityInWorld((Entity)entity);
        }
    }
}

