/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.tools.inventory;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import tconstruct.library.event.ToolCraftedEvent;
import tconstruct.library.modifier.IModifyable;
import tconstruct.smeltery.inventory.ActiveContainer;
import tconstruct.tools.TinkerTools;
import tconstruct.tools.inventory.SlotTool;
import tconstruct.tools.logic.ToolStationLogic;

public class ToolStationContainer
extends ActiveContainer {
    public InventoryPlayer invPlayer;
    public ToolStationLogic logic;
    public Slot[] slots;
    public SlotTool toolSlot;
    public Random random = new Random();

    public ToolStationContainer(InventoryPlayer inventoryplayer, ToolStationLogic builderlogic) {
        this.initializeContainer(inventoryplayer, builderlogic);
    }

    public void initializeContainer(InventoryPlayer inventoryplayer, ToolStationLogic builderlogic) {
        int column;
        this.invPlayer = inventoryplayer;
        this.logic = builderlogic;
        this.toolSlot = new SlotTool(inventoryplayer.player, (IInventory)builderlogic, 0, 225, 38);
        this.addSlotToContainer(this.toolSlot);
        this.slots = new Slot[]{new Slot((IInventory)builderlogic, 1, 167, 29), new Slot((IInventory)builderlogic, 2, 149, 38), new Slot((IInventory)builderlogic, 3, 167, 47)};
        for (int iter = 0; iter < 3; ++iter) {
            this.addSlotToContainer(this.slots[iter]);
        }
        for (column = 0; column < 3; ++column) {
            for (int row = 0; row < 9; ++row) {
                this.addSlotToContainer(new Slot((IInventory)inventoryplayer, row + column * 9 + 9, 118 + row * 18, 84 + column * 18));
            }
        }
        for (column = 0; column < 9; ++column) {
            this.addSlotToContainer(new Slot((IInventory)inventoryplayer, column, 118 + column * 18, 142));
        }
    }

    public void resetSlots(int[] posX, int[] posY) {
        int column;
        this.inventorySlots.clear();
        this.inventoryItemStacks.clear();
        this.addSlotToContainer(this.toolSlot);
        for (int iter = 0; iter < 3; ++iter) {
            this.slots[iter].xDisplayPosition = posX[iter] + 111;
            this.slots[iter].yDisplayPosition = posY[iter] + 1;
            this.addSlotToContainer(this.slots[iter]);
        }
        for (column = 0; column < 3; ++column) {
            for (int row = 0; row < 9; ++row) {
                this.addSlotToContainer(new Slot((IInventory)this.invPlayer, row + column * 9 + 9, 118 + row * 18, 84 + column * 18));
            }
        }
        for (column = 0; column < 9; ++column) {
            this.addSlotToContainer(new Slot((IInventory)this.invPlayer, column, 118 + column * 18, 142));
        }
    }

    @Override
    public boolean canInteractWith(EntityPlayer entityplayer) {
        Block block = this.logic.getWorldObj().getBlock(this.logic.xCoord, this.logic.yCoord, this.logic.zCoord);
        if (block != TinkerTools.toolStationWood && block != TinkerTools.craftingSlabWood) {
            return false;
        }
        return this.logic.isUseableByPlayer(entityplayer);
    }

    public ItemStack transferStackInSlot(EntityPlayer player, int slotID) {
        ItemStack stack = null;
        Slot slot = (Slot)this.inventorySlots.get(slotID);
        if (slot != null && slot.getHasStack()) {
            ItemStack slotStack = slot.getStack();
            stack = slotStack.copy();
            if (slotID < this.logic.getSizeInventory() ? (slotID == 0 ? !this.mergeCraftedStack(slotStack, this.logic.getSizeInventory(), this.inventorySlots.size(), true, player) : !this.mergeItemStack(slotStack, this.logic.getSizeInventory(), this.inventorySlots.size(), true)) : !this.mergeItemStack(slotStack, 1, this.logic.getSizeInventory(), false)) {
                return null;
            }
            if (slotStack.stackSize == 0) {
                slot.putStack((ItemStack)null);
            } else {
                slot.onSlotChanged();
            }
        }
        return stack;
    }

    protected void craftTool(ItemStack stack) {
        if (stack.getItem() instanceof IModifyable) {
            NBTTagCompound tags = stack.getTagCompound().getCompoundTag(((IModifyable)stack.getItem()).getBaseTagName());
            Boolean full = this.logic.getStackInSlot(2) != null || this.logic.getStackInSlot(3) != null;
            for (int i = 2; i <= 3; ++i) {
                this.logic.decrStackSize(i, 1);
            }
            ItemStack compare = this.logic.getStackInSlot(1);
            int amount = compare.getItem() instanceof IModifyable ? compare.stackSize : 1;
            this.logic.decrStackSize(1, amount);
            EntityPlayer player = this.invPlayer.player;
            if (!player.worldObj.isRemote && full.booleanValue()) {
                player.worldObj.playSoundEffect((double)this.logic.xCoord, (double)this.logic.yCoord, (double)this.logic.zCoord, "tinker:little_saw", 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            }
            MinecraftForge.EVENT_BUS.post((Event)new ToolCraftedEvent((IInventory)this.logic, player, stack));
        } else {
            ItemStack stack2 = this.logic.getStackInSlot(1);
            int amount = this.logic.getStackInSlot((int)1).stackSize;
            this.logic.decrStackSize(1, amount);
            if (!ToolStationLogic.canRename(stack2.getTagCompound(), stack2)) {
                for (int i = 0; i < this.logic.getSizeInventory(); ++i) {
                    if (this.logic.getStackInSlot(i) == null || this.logic.getStackInSlot(i).getItem() != Items.name_tag) continue;
                    this.logic.decrStackSize(i, 1);
                    break;
                }
            }
        }
    }

    protected boolean mergeCraftedStack(ItemStack stack, int slotsStart, int slotsTotal, boolean playerInventory, EntityPlayer player) {
        boolean failedToMerge = false;
        int slotIndex = slotsStart;
        if (playerInventory) {
            slotIndex = slotsTotal - 1;
        }
        ItemStack copyStack = null;
        if (stack.stackSize > 0) {
            slotIndex = playerInventory ? slotsTotal - 1 : slotsStart;
            while (!playerInventory && slotIndex < slotsTotal || playerInventory && slotIndex >= slotsStart) {
                Slot otherInventorySlot = (Slot)this.inventorySlots.get(slotIndex);
                copyStack = otherInventorySlot.getStack();
                if (copyStack == null) {
                    this.craftTool(stack);
                    otherInventorySlot.putStack(stack.copy());
                    otherInventorySlot.onSlotChanged();
                    stack.stackSize = 0;
                    failedToMerge = true;
                    break;
                }
                if (playerInventory) {
                    --slotIndex;
                    continue;
                }
                ++slotIndex;
            }
        }
        return failedToMerge;
    }
}

