/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.tools.inventory;

import invtweaks.api.container.ChestContainer;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import tconstruct.library.util.IPattern;
import tconstruct.tools.TinkerTools;
import tconstruct.tools.inventory.SlotPattern;
import tconstruct.tools.logic.PatternChestLogic;

@ChestContainer
public class PatternChestContainer
extends Container {
    public PatternChestLogic logic;
    public int progress = 0;
    public int fuel = 0;
    public int fuelGague = 0;

    public PatternChestContainer(InventoryPlayer inventoryplayer, PatternChestLogic chest) {
        int row;
        int column;
        this.logic = chest;
        for (column = 0; column < 3; ++column) {
            for (row = 0; row < 10; ++row) {
                this.addSlotToContainer(new SlotPattern((IInventory)chest, row + column * 10, 8 + row * 18, 18 + column * 18));
            }
        }
        for (column = 0; column < 3; ++column) {
            for (row = 0; row < 9; ++row) {
                this.addSlotToContainer(new Slot((IInventory)inventoryplayer, row + column * 9 + 9, 17 + row * 18, 86 + column * 18));
            }
        }
        for (column = 0; column < 9; ++column) {
            this.addSlotToContainer(new Slot((IInventory)inventoryplayer, column, 17 + column * 18, 144));
        }
    }

    public boolean canInteractWith(EntityPlayer entityplayer) {
        Block block = this.logic.getWorldObj().getBlock(this.logic.xCoord, this.logic.yCoord, this.logic.zCoord);
        if (block != TinkerTools.toolStationWood && block != TinkerTools.craftingSlabWood) {
            return false;
        }
        return this.logic.isUseableByPlayer(entityplayer);
    }

    public ItemStack transferStackInSlot(EntityPlayer player, int slotID) {
        ItemStack stack = null;
        Slot slot = (Slot)this.inventorySlots.get(slotID);
        if (slot != null && slot.getHasStack()) {
            ItemStack slotStack = slot.getStack();
            stack = slotStack.copy();
            if (slotID < this.logic.getSizeInventory() ? !this.mergeItemStack(slotStack, this.logic.getSizeInventory(), this.inventorySlots.size(), true) : !this.mergeItemStack(slotStack, 0, this.logic.getSizeInventory(), false)) {
                return null;
            }
            if (slotStack.stackSize == 0) {
                slot.putStack((ItemStack)null);
            } else {
                slot.onSlotChanged();
            }
        }
        return stack;
    }

    protected boolean mergeItemStack(ItemStack stack, int inventorySize, int slotSize, boolean par4) {
        if (!(stack.getItem() instanceof IPattern)) {
            return false;
        }
        return super.mergeItemStack(stack, inventorySize, slotSize, par4);
    }
}

