/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.tools.inventory;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import tconstruct.armor.inventory.SlotOnlyTake;
import tconstruct.library.util.IPattern;
import tconstruct.smeltery.inventory.ActiveContainer;
import tconstruct.tools.TinkerTools;
import tconstruct.tools.inventory.SlotPattern;
import tconstruct.tools.logic.PartBuilderLogic;

public class PartCrafterContainer
extends ActiveContainer {
    protected InventoryPlayer invPlayer;
    protected PartBuilderLogic logic;
    protected Slot[] input;
    protected Slot[] inventory;
    public boolean largeInventory;

    public PartCrafterContainer(InventoryPlayer inventoryplayer, PartBuilderLogic partLogic) {
        int column;
        this.invPlayer = inventoryplayer;
        this.logic = partLogic;
        this.largeInventory = false;
        this.inventory = new Slot[]{new SlotPattern((IInventory)partLogic, 0, 40, 27), new SlotPattern((IInventory)partLogic, 1, 40, 45), new Slot((IInventory)partLogic, 2, 58, 27), new Slot((IInventory)partLogic, 3, 58, 45), new SlotOnlyTake((IInventory)partLogic, 4, 102, 27), new SlotOnlyTake((IInventory)partLogic, 5, 120, 27), new SlotOnlyTake((IInventory)partLogic, 6, 102, 45), new SlotOnlyTake((IInventory)partLogic, 7, 120, 45)};
        for (int iter = 0; iter < this.inventory.length; ++iter) {
            this.addSlotToContainer(this.inventory[iter]);
        }
        for (column = 0; column < 3; ++column) {
            for (int row = 0; row < 9; ++row) {
                this.addSlotToContainer(new Slot((IInventory)inventoryplayer, row + column * 9 + 9, 8 + row * 18, 84 + column * 18));
            }
        }
        for (column = 0; column < 9; ++column) {
            this.addSlotToContainer(new Slot((IInventory)inventoryplayer, column, 8 + column * 18, 142));
        }
    }

    @Override
    public boolean canInteractWith(EntityPlayer entityplayer) {
        Block block = this.logic.getWorldObj().getBlock(this.logic.xCoord, this.logic.yCoord, this.logic.zCoord);
        if (block != TinkerTools.toolStationWood && block != TinkerTools.craftingSlabWood) {
            return false;
        }
        return this.logic.isUseableByPlayer(entityplayer);
    }

    public ItemStack transferStackInSlot(EntityPlayer player, int slotID) {
        ItemStack stack = null;
        Slot slot = (Slot)this.inventorySlots.get(slotID);
        if (slot != null && slot.getHasStack()) {
            ItemStack slotStack = slot.getStack();
            stack = slotStack.copy();
            if (slotID < this.logic.getSizeInventory() ? !this.mergeItemStack(slotStack, this.logic.getSizeInventory(), this.inventorySlots.size(), true) : (slotStack.getItem() instanceof IPattern ? !this.mergeItemStack(slotStack, 0, 2, false) : !this.mergeItemStack(slotStack, 2, 4, false))) {
                return null;
            }
            if (slotStack.stackSize == 0) {
                slot.putStack((ItemStack)null);
                this.logic.tryBuildPart(slotID);
            }
            slot.onSlotChanged();
        }
        return stack;
    }
}

