/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.tools.inventory;

import mantle.blocks.abstracts.InventoryLogic;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;

public class InventoryCraftingStation
extends InventoryCrafting {
    private int inventoryWidth;
    private Container eventHandler;
    private InventoryLogic logic;

    public InventoryCraftingStation(Container par1Container, int size, int height, InventoryLogic logic) {
        super(par1Container, size, height);
        this.eventHandler = par1Container;
        this.inventoryWidth = size;
        this.logic = logic;
    }

    public int getSizeInventory() {
        return 9;
    }

    public ItemStack getStackInSlot(int slot) {
        return slot >= this.getSizeInventory() ? null : this.logic.getStackInSlot(slot + 1);
    }

    public ItemStack getStackInRowAndColumn(int row, int column) {
        if (row >= 0 && row < this.inventoryWidth) {
            int k = row + column * this.inventoryWidth;
            return this.getStackInSlot(k);
        }
        return null;
    }

    public String getInvName() {
        return "container.crafting";
    }

    public boolean isInvNameLocalized() {
        return false;
    }

    public ItemStack getStackInSlotOnClosing(int par1) {
        return null;
    }

    public ItemStack decrStackSize(int slotID, int par2) {
        ItemStack stack = this.logic.getStackInSlot(slotID + 1);
        if (stack != null) {
            if (stack.stackSize <= par2) {
                ItemStack itemstack = stack.copy();
                stack = null;
                this.logic.setInventorySlotContents(slotID + 1, null);
                this.eventHandler.onCraftMatrixChanged((IInventory)this);
                return itemstack;
            }
            ItemStack itemstack = stack.splitStack(par2);
            if (stack.stackSize == 0) {
                stack = null;
            }
            this.eventHandler.onCraftMatrixChanged((IInventory)this);
            return itemstack;
        }
        return null;
    }

    public void setInventorySlotContents(int slot, ItemStack itemstack) {
        this.logic.setInventorySlotContents(slot + 1, itemstack);
        this.eventHandler.onCraftMatrixChanged((IInventory)this);
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public void markDirty() {
    }

    public boolean isUseableByPlayer(EntityPlayer par1EntityPlayer) {
        return true;
    }

    public void openChest() {
    }

    public void closeChest() {
    }

    public boolean isStackValidForSlot(int par1, ItemStack par2ItemStack) {
        return true;
    }
}

