/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.tools.gui;

import codechicken.nei.VisiblityData;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.TaggedInventoryArea;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import tconstruct.TConstruct;
import tconstruct.library.client.TConstructClientRegistry;
import tconstruct.library.client.ToolGuiElement;
import tconstruct.smeltery.inventory.ActiveContainer;
import tconstruct.tools.gui.GuiButtonTool;
import tconstruct.tools.gui.ToolStationGuiHelper;
import tconstruct.tools.inventory.ToolStationContainer;
import tconstruct.tools.logic.ToolStationLogic;
import tconstruct.util.network.ToolStationPacket;

@SideOnly(value=Side.CLIENT)
@Optional.Interface(iface="codechicken.nei.api.INEIGuiHandler", modid="NotEnoughItems")
public class ToolStationGui
extends GuiContainer
implements INEIGuiHandler {
    public ToolStationLogic logic;
    public ToolStationContainer toolSlots;
    public GuiTextField text;
    public String toolName;
    public int guiType;
    public int[] slotX;
    public int[] slotY;
    public int[] iconX;
    public int[] iconY;
    public boolean active;
    public String title;
    public String body = "";
    private static final ResourceLocation background = new ResourceLocation("tinker", "textures/gui/toolstation.png");
    private static final ResourceLocation icons = new ResourceLocation("tinker", "textures/gui/icons.png");
    private static final ResourceLocation description = new ResourceLocation("tinker", "textures/gui/description.png");

    public ToolStationGui(InventoryPlayer inventoryplayer, ToolStationLogic stationlogic, World world, int x, int y, int z) {
        super((Container)((ActiveContainer)stationlogic.getGuiContainer(inventoryplayer, world, x, y, z)));
        this.logic = stationlogic;
        this.toolSlots = (ToolStationContainer)this.inventorySlots;
        this.text = new GuiTextField(this.fontRendererObj, 83, 8, 30, 12);
        this.text.setMaxStringLength(40);
        this.text.setEnableBackgroundDrawing(false);
        this.text.setVisible(true);
        this.text.setCanLoseFocus(false);
        this.text.setFocused(true);
        this.text.setTextColor(0xFFFFFF);
        this.toolName = "";
        this.resetGui();
        Keyboard.enableRepeatEvents((boolean)true);
    }

    protected void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            int gLeft = this.guiLeft + 68 + 110;
            int gTop = this.guiTop + 6;
            int gwidth = 102;
            int gheight = 12;
            this.active = mouseX > gLeft && mouseX < gLeft + gwidth && mouseY > gTop && mouseY < gTop + gheight;
        }
    }

    void resetGui() {
        this.text.setText("");
        this.guiType = 0;
        this.setSlotType(0);
        this.iconX = new int[]{0, 1, 2};
        this.iconY = new int[]{13, 13, 13};
        this.title = "\u00a7n" + StatCollector.translateToLocal((String)"gui.toolforge1");
        this.body = StatCollector.translateToLocal((String)"gui.toolforge2");
    }

    public void initGui() {
        super.initGui();
        this.xSize = 286;
        this.guiLeft = (this.width - 176) / 2 - 110;
        this.buttonList.clear();
        ToolGuiElement repair = TConstructClientRegistry.toolButtons.get(0);
        GuiButtonTool repairButton = new GuiButtonTool(0, this.guiLeft, this.guiTop, repair.buttonIconX, repair.buttonIconY, repair.domain, repair.texture, repair);
        repairButton.enabled = false;
        this.buttonList.add(repairButton);
        for (int iter = 1; iter < TConstructClientRegistry.toolButtons.size(); ++iter) {
            ToolGuiElement element = TConstructClientRegistry.toolButtons.get(iter);
            GuiButtonTool button = new GuiButtonTool(iter, this.guiLeft + 22 * (iter % 5), this.guiTop + 22 * (iter / 5), element.buttonIconX, element.buttonIconY, repair.domain, element.texture, element);
            this.buttonList.add(button);
        }
    }

    protected void actionPerformed(GuiButton button) {
        ((GuiButton)this.buttonList.get((int)this.guiType)).enabled = true;
        this.guiType = button.id;
        button.enabled = false;
        ToolGuiElement element = TConstructClientRegistry.toolButtons.get(this.guiType);
        this.setSlotType(element.slotType);
        this.iconX = element.iconsX;
        this.iconY = element.iconsY;
        this.title = "\u00a7n" + element.title;
        this.body = StatCollector.translateToLocal((String)element.body);
        if (this.body != null) {
            int i;
            while ((i = this.body.indexOf("\\n")) >= 0) {
                this.body = this.body.substring(0, i) + '\n' + this.body.substring(i + 2);
            }
        }
    }

    void setSlotType(int type) {
        switch (type) {
            case 0: {
                this.slotX = new int[]{56, 38, 38};
                this.slotY = new int[]{37, 28, 46};
                break;
            }
            case 1: {
                this.slotX = new int[]{56, 56, 56};
                this.slotY = new int[]{19, 55, 37};
                break;
            }
            case 2: {
                this.slotX = new int[]{56, 56, 14};
                this.slotY = new int[]{28, 46, 37};
                break;
            }
            case 3: {
                this.slotX = new int[]{38, 47, 56};
                this.slotY = new int[]{28, 46, 28};
                break;
            }
            case 7: {
                this.slotX = new int[]{56, 56, 56};
                this.slotY = new int[]{19, 37, 55};
            }
        }
        this.toolSlots.resetSlots(this.slotX, this.slotY);
    }

    public void updateScreen() {
        super.updateScreen();
        this.text.updateCursorCounter();
    }

    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        this.fontRendererObj.drawString(StatCollector.translateToLocal((String)this.logic.getInvName()), 116, 8, 0);
        this.fontRendererObj.drawString(StatCollector.translateToLocal((String)"container.inventory"), 118, this.ySize - 96 + 2, 0);
        this.fontRendererObj.drawString(this.toolName + "_", 180, 8, 0xFFFFFF);
        if (this.logic.isStackInSlot(0)) {
            ToolStationGuiHelper.drawToolStats(this.logic.getStackInSlot(0), 294, 0);
        } else {
            this.drawToolInformation();
        }
    }

    protected void drawToolInformation() {
        this.drawCenteredString(this.fontRendererObj, this.title, 349, 8, 0xFFFFFF);
        this.fontRendererObj.drawSplitString(this.body, 294, 24, 115, 0xFFFFFF);
    }

    protected void drawGuiContainerBackgroundLayer(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.getTextureManager().bindTexture(background);
        int cornerX = this.guiLeft + 110;
        this.drawTexturedModalRect(cornerX, this.guiTop, 0, 0, 176, this.ySize);
        if (this.active) {
            this.drawTexturedModalRect(cornerX + 62, this.guiTop, 0, this.ySize, 112, 22);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.getTextureManager().bindTexture(icons);
        for (int i = 0; i < this.slotX.length; ++i) {
            this.drawTexturedModalRect(cornerX + this.slotX[i], this.guiTop + this.slotY[i], 144, 216, 18, 18);
            if (this.logic.isStackInSlot(i + 1)) continue;
            this.drawTexturedModalRect(cornerX + this.slotX[i], this.guiTop + this.slotY[i], 18 * this.iconX[i], 18 * this.iconY[i], 18, 18);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.getTextureManager().bindTexture(description);
        this.drawTexturedModalRect(cornerX + 176, this.guiTop, 0, 0, 126, this.ySize + 30);
    }

    protected void keyTyped(char par1, int keyCode) {
        if (keyCode == 1 || !this.active && keyCode == this.mc.gameSettings.keyBindInventory.getKeyCode()) {
            this.logic.setToolname("");
            this.updateServer("");
            Keyboard.enableRepeatEvents((boolean)false);
            this.mc.thePlayer.closeScreen();
        } else if (this.active) {
            this.text.textboxKeyTyped(par1, keyCode);
            this.toolName = this.text.getText().trim();
            this.logic.setToolname(this.toolName);
            this.updateServer(this.toolName);
        }
    }

    void updateServer(String name) {
        TConstruct.packetPipeline.sendToServer(new ToolStationPacket(this.logic.xCoord, this.logic.yCoord, this.logic.zCoord, name));
    }

    public VisiblityData modifyVisiblity(GuiContainer gui, VisiblityData currentVisibility) {
        currentVisibility.showWidgets = this.width - this.xSize >= 107;
        if (this.guiLeft < 58) {
            currentVisibility.showStateButtons = false;
        }
        return currentVisibility;
    }

    public Iterable<Integer> getItemSpawnSlots(GuiContainer gui, ItemStack item) {
        return null;
    }

    public List<TaggedInventoryArea> getInventoryAreas(GuiContainer gui) {
        return Collections.emptyList();
    }

    public boolean handleDragNDrop(GuiContainer gui, int mousex, int mousey, ItemStack draggedStack, int button) {
        return false;
    }

    public boolean hideItemPanelSlot(GuiContainer gui, int x, int y, int w, int h) {
        if (y + h - 4 < this.guiTop || y + 4 > this.guiTop + this.ySize) {
            return false;
        }
        return x + 4 <= this.guiLeft + this.xSize + 126;
    }
}

