/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.tools.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import tconstruct.library.client.TConstructClientRegistry;
import tconstruct.library.client.ToolGuiElement;
import tconstruct.tools.gui.GuiButtonTool;
import tconstruct.tools.gui.ToolStationGui;
import tconstruct.tools.logic.ToolForgeLogic;

@SideOnly(value=Side.CLIENT)
public class ToolForgeGui
extends ToolStationGui {
    int selectedButton;

    public ToolForgeGui(InventoryPlayer inventoryplayer, ToolForgeLogic stationlogic, World world, int x, int y, int z) {
        super(inventoryplayer, stationlogic, world, x, y, z);
    }

    @Override
    public void initGui() {
        GuiButtonTool button;
        ToolGuiElement element;
        int iter;
        super.initGui();
        this.buttonList.clear();
        ToolGuiElement repair = TConstructClientRegistry.toolButtons.get(0);
        GuiButtonTool repairButton = new GuiButtonTool(0, this.guiLeft, this.guiTop, repair.buttonIconX, repair.buttonIconY, repair.domain, repair.texture, repair);
        repairButton.enabled = false;
        this.buttonList.add(repairButton);
        int offset = TConstructClientRegistry.tierTwoButtons.size();
        for (iter = 0; iter < TConstructClientRegistry.tierTwoButtons.size(); ++iter) {
            element = TConstructClientRegistry.tierTwoButtons.get(iter);
            button = new GuiButtonTool(iter + 1, this.guiLeft + 22 * ((iter + 1) % 5), this.guiTop + 22 * ((iter + 1) / 5), element.buttonIconX, element.buttonIconY, repair.domain, element.texture, element);
            this.buttonList.add(button);
        }
        for (iter = 1; iter < TConstructClientRegistry.toolButtons.size(); ++iter) {
            element = TConstructClientRegistry.toolButtons.get(iter);
            button = new GuiButtonTool(iter + offset, this.guiLeft + 22 * ((iter + offset) % 5), this.guiTop + 22 * ((iter + offset) / 5), element.buttonIconX, element.buttonIconY, repair.domain, element.texture, element);
            this.buttonList.add(button);
        }
    }

    @Override
    protected void actionPerformed(GuiButton button) {
        GuiButtonTool b = (GuiButtonTool)button;
        ((GuiButton)this.buttonList.get((int)this.selectedButton)).enabled = true;
        this.selectedButton = button.id;
        button.enabled = false;
        this.setSlotType(b.element.slotType);
        this.iconX = b.element.iconsX;
        this.iconY = b.element.iconsY;
        this.title = "\u00a7n" + b.element.title;
        this.body = StatCollector.translateToLocal((String)b.element.body);
        if (this.body != null) {
            int i;
            while ((i = this.body.indexOf("\\n")) >= 0) {
                this.body = this.body.substring(0, i) + '\n' + this.body.substring(i + 2);
            }
        }
    }

    @Override
    void resetGui() {
        this.text.setText("");
        this.selectedButton = 0;
        this.setSlotType(0);
        this.iconX = new int[]{0, 1, 2, 13};
        this.iconY = new int[]{13, 13, 13, 13};
        this.title = "\u00a7n" + StatCollector.translateToLocal((String)"gui.toolforge1");
        this.body = StatCollector.translateToLocal((String)"gui.toolforge2");
    }

    @Override
    void setSlotType(int type) {
        switch (type) {
            case 0: {
                this.slotX = new int[]{56, 38, 38, 14};
                this.slotY = new int[]{37, 28, 46, 37};
                break;
            }
            case 1: {
                this.slotX = new int[]{56, 56, 56, 14};
                this.slotY = new int[]{19, 55, 37, 37};
                break;
            }
            case 2: {
                this.slotX = new int[]{56, 56, 14, 14};
                this.slotY = new int[]{28, 46, 28, 46};
                break;
            }
            case 3: {
                this.slotX = new int[]{38, 47, 56, 14};
                this.slotY = new int[]{28, 46, 28, 37};
                break;
            }
            case 4: {
                this.slotX = new int[]{47, 38, 56, 47};
                this.slotY = new int[]{19, 37, 37, 55};
                break;
            }
            case 5: {
                this.slotX = new int[]{38, 47, 56, 47};
                this.slotY = new int[]{19, 55, 19, 37};
                break;
            }
            case 6: {
                this.slotX = new int[]{38, 38, 20, 56};
                this.slotY = new int[]{28, 46, 28, 28};
                break;
            }
            case 7: {
                this.slotX = new int[]{56, 56, 56, 14};
                this.slotY = new int[]{19, 37, 55, 37};
                break;
            }
            case 8: {
                this.slotX = new int[]{20, 38, 56, 38};
                this.slotY = new int[]{28, 46, 28, 28};
                break;
            }
            case 9: {
                this.slotX = new int[]{38, 56, 47, 47};
                this.slotY = new int[]{37, 37, 55, 19};
            }
        }
        this.toolSlots.resetSlots(this.slotX, this.slotY);
    }
}

